# System.Runtime.Intrinsics.X86

``` diff
 namespace System.Runtime.Intrinsics.X86 {
+    [CLSCompliantAttribute(false)]
+    public abstract class Avx512BW : Avx512F {
+        public static new bool IsSupported { get; }
+        public new abstract class VL : Avx512F.VL {
+            public static new bool IsSupported { get; }
+        }
+        public new abstract class X64 : Avx512F.X64 {
+            public static new bool IsSupported { get; }
+        }
+    }
+    [CLSCompliantAttribute(false)]
+    public abstract class Avx512CD : Avx512F {
+        public static new bool IsSupported { get; }
+        public new abstract class VL : Avx512F.VL {
+            public static new bool IsSupported { get; }
+        }
+        public new abstract class X64 : Avx512F.X64 {
+            public static new bool IsSupported { get; }
+        }
+    }
+    [CLSCompliantAttribute(false)]
+    public abstract class Avx512DQ : Avx512F {
+        public static new bool IsSupported { get; }
+        public new abstract class VL : Avx512F.VL {
+            public static new bool IsSupported { get; }
+        }
+        public new abstract class X64 : Avx512F.X64 {
+            public static new bool IsSupported { get; }
+        }
+    }
+    [CLSCompliantAttribute(false)]
+    public abstract class Avx512F : Avx2 {
+        public static new bool IsSupported { get; }
+        public static Vector512<byte> And(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<double> And(Vector512<double> left, Vector512<double> right);
+        public static Vector512<short> And(Vector512<short> left, Vector512<short> right);
+        public static Vector512<int> And(Vector512<int> left, Vector512<int> right);
+        public static Vector512<long> And(Vector512<long> left, Vector512<long> right);
+        public static Vector512<sbyte> And(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<float> And(Vector512<float> left, Vector512<float> right);
+        public static Vector512<ushort> And(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<uint> And(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<ulong> And(Vector512<ulong> left, Vector512<ulong> right);
+        public static Vector512<byte> AndNot(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<double> AndNot(Vector512<double> left, Vector512<double> right);
+        public static Vector512<short> AndNot(Vector512<short> left, Vector512<short> right);
+        public static Vector512<int> AndNot(Vector512<int> left, Vector512<int> right);
+        public static Vector512<long> AndNot(Vector512<long> left, Vector512<long> right);
+        public static Vector512<sbyte> AndNot(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<float> AndNot(Vector512<float> left, Vector512<float> right);
+        public static Vector512<ushort> AndNot(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<uint> AndNot(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<ulong> AndNot(Vector512<ulong> left, Vector512<ulong> right);
+        public unsafe static Vector512<byte> LoadAlignedVector512(byte* address);
+        public unsafe static Vector512<double> LoadAlignedVector512(double* address);
+        public unsafe static Vector512<short> LoadAlignedVector512(short* address);
+        public unsafe static Vector512<int> LoadAlignedVector512(int* address);
+        public unsafe static Vector512<long> LoadAlignedVector512(long* address);
+        public unsafe static Vector512<sbyte> LoadAlignedVector512(sbyte* address);
+        public unsafe static Vector512<float> LoadAlignedVector512(float* address);
+        public unsafe static Vector512<ushort> LoadAlignedVector512(ushort* address);
+        public unsafe static Vector512<uint> LoadAlignedVector512(uint* address);
+        public unsafe static Vector512<ulong> LoadAlignedVector512(ulong* address);
+        public unsafe static Vector512<byte> LoadVector512(byte* address);
+        public unsafe static Vector512<double> LoadVector512(double* address);
+        public unsafe static Vector512<short> LoadVector512(short* address);
+        public unsafe static Vector512<int> LoadVector512(int* address);
+        public unsafe static Vector512<long> LoadVector512(long* address);
+        public unsafe static Vector512<sbyte> LoadVector512(sbyte* address);
+        public unsafe static Vector512<float> LoadVector512(float* address);
+        public unsafe static Vector512<ushort> LoadVector512(ushort* address);
+        public unsafe static Vector512<uint> LoadVector512(uint* address);
+        public unsafe static Vector512<ulong> LoadVector512(ulong* address);
+        public static Vector512<byte> Or(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<double> Or(Vector512<double> left, Vector512<double> right);
+        public static Vector512<short> Or(Vector512<short> left, Vector512<short> right);
+        public static Vector512<int> Or(Vector512<int> left, Vector512<int> right);
+        public static Vector512<long> Or(Vector512<long> left, Vector512<long> right);
+        public static Vector512<sbyte> Or(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<float> Or(Vector512<float> left, Vector512<float> right);
+        public static Vector512<ushort> Or(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<uint> Or(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<ulong> Or(Vector512<ulong> left, Vector512<ulong> right);
+        public unsafe static void Store(byte* address, Vector512<byte> source);
+        public unsafe static void Store(double* address, Vector512<double> source);
+        public unsafe static void Store(short* address, Vector512<short> source);
+        public unsafe static void Store(int* address, Vector512<int> source);
+        public unsafe static void Store(long* address, Vector512<long> source);
+        public unsafe static void Store(sbyte* address, Vector512<sbyte> source);
+        public unsafe static void Store(float* address, Vector512<float> source);
+        public unsafe static void Store(ushort* address, Vector512<ushort> source);
+        public unsafe static void Store(uint* address, Vector512<uint> source);
+        public unsafe static void Store(ulong* address, Vector512<ulong> source);
+        public unsafe static void StoreAligned(byte* address, Vector512<byte> source);
+        public unsafe static void StoreAligned(double* address, Vector512<double> source);
+        public unsafe static void StoreAligned(short* address, Vector512<short> source);
+        public unsafe static void StoreAligned(int* address, Vector512<int> source);
+        public unsafe static void StoreAligned(long* address, Vector512<long> source);
+        public unsafe static void StoreAligned(sbyte* address, Vector512<sbyte> source);
+        public unsafe static void StoreAligned(float* address, Vector512<float> source);
+        public unsafe static void StoreAligned(ushort* address, Vector512<ushort> source);
+        public unsafe static void StoreAligned(uint* address, Vector512<uint> source);
+        public unsafe static void StoreAligned(ulong* address, Vector512<ulong> source);
+        public unsafe static void StoreAlignedNonTemporal(byte* address, Vector512<byte> source);
+        public unsafe static void StoreAlignedNonTemporal(double* address, Vector512<double> source);
+        public unsafe static void StoreAlignedNonTemporal(short* address, Vector512<short> source);
+        public unsafe static void StoreAlignedNonTemporal(int* address, Vector512<int> source);
+        public unsafe static void StoreAlignedNonTemporal(long* address, Vector512<long> source);
+        public unsafe static void StoreAlignedNonTemporal(sbyte* address, Vector512<sbyte> source);
+        public unsafe static void StoreAlignedNonTemporal(float* address, Vector512<float> source);
+        public unsafe static void StoreAlignedNonTemporal(ushort* address, Vector512<ushort> source);
+        public unsafe static void StoreAlignedNonTemporal(uint* address, Vector512<uint> source);
+        public unsafe static void StoreAlignedNonTemporal(ulong* address, Vector512<ulong> source);
+        public static Vector512<byte> Xor(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<double> Xor(Vector512<double> left, Vector512<double> right);
+        public static Vector512<short> Xor(Vector512<short> left, Vector512<short> right);
+        public static Vector512<int> Xor(Vector512<int> left, Vector512<int> right);
+        public static Vector512<long> Xor(Vector512<long> left, Vector512<long> right);
+        public static Vector512<sbyte> Xor(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<float> Xor(Vector512<float> left, Vector512<float> right);
+        public static Vector512<ushort> Xor(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<uint> Xor(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<ulong> Xor(Vector512<ulong> left, Vector512<ulong> right);
+        public abstract class VL {
+            public static bool IsSupported { get; }
+        }
+        public new abstract class X64 : Avx2.X64 {
+            public static new bool IsSupported { get; }
+        }
+    }
 }
```

