# System

``` diff
 namespace System {
-    public readonly struct Boolean : IComparable, IComparable<bool>, IConvertible, IEquatable<bool> {
+    public readonly struct Boolean : IComparable, IComparable<bool>, IConvertible, IEquatable<bool>, IParsable<bool>, ISpanParsable<bool> {
+        static bool IParsable<bool>.Parse(string s, IFormatProvider provider);
+        static bool IParsable<bool>.TryParse([NotNullWhenAttribute(true)] string s, IFormatProvider provider, out bool result);
+        static bool ISpanParsable<bool>.Parse(ReadOnlySpan<char> s, IFormatProvider provider);
+        static bool ISpanParsable<bool>.TryParse(ReadOnlySpan<char> s, IFormatProvider provider, out bool result);
     }
     public enum ConsoleKey {
+        None = 0,
     }
     [FlagsAttribute]
     public enum ConsoleModifiers {
+        None = 0,
     }
     public static class MemoryExtensions {
+        public static ReadOnlySpan<char> AsSpan(this string? text, Index startIndex);
+        public static ReadOnlySpan<char> AsSpan(this string? text, Range range);
+        public static void Replace<T>(this ReadOnlySpan<T> source, Span<T> destination, T oldValue, T newValue) where T : IEquatable<T>?;
     }
     public sealed class OperatingSystem : ICloneable, ISerializable {
+        public static bool IsWasi();
     }
-    public sealed class String : ICloneable, IComparable, IComparable<string?>, IConvertible, IEnumerable, IEnumerable<char>, IEquatable<string?> {
+    public sealed class String : ICloneable, IComparable, IComparable<string?>, IConvertible, IEnumerable, IEnumerable<char>, IEquatable<string?>, IParsable<string>, ISpanParsable<string> {
+        static string IParsable<string>.Parse(string s, IFormatProvider provider);
+        static bool IParsable<string>.TryParse([NotNullWhenAttribute(true)] string s, IFormatProvider provider, [MaybeNullWhenAttribute(false)] out string result);
+        static string ISpanParsable<string>.Parse(ReadOnlySpan<char> s, IFormatProvider provider);
+        static bool ISpanParsable<string>.TryParse(ReadOnlySpan<char> s, IFormatProvider provider, [MaybeNullWhenAttribute(false)] out string result);
     }
 }
```

