# System.Windows.Forms

``` diff
 namespace System.Windows.Forms {
     [DefaultBindingPropertyAttribute("Text")]
     [DefaultEventAttribute("SelectedIndexChanged")]
     [DefaultPropertyAttribute("Items")]
     [DesignerAttribute("System.Windows.Forms.Design.ComboBoxDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionComboBox")]
     public class ComboBox : ListControl {
         [ListBindableAttribute(false)]
         public class ObjectCollection : ICollection, IComparer<ComboBox.ObjectCollection.Entry>, IEnumerable, IList {
-            bool System.Collections.ICollection.IsSynchronized { get; }
+            bool ICollection.IsSynchronized { get; }
-            object System.Collections.ICollection.SyncRoot { get; }
+            object ICollection.SyncRoot { get; }
-            bool System.Collections.IList.IsFixedSize { get; }
+            bool IList.IsFixedSize { get; }
-            [BrowsableAttribute(false)]
-            [DesignerSerializationVisibilityAttribute(0)]
-            public virtual object this[int index] { get; set; }
+            [BrowsableAttribute(false)]
+            [DesignerSerializationVisibilityAttribute(0)]
+            public virtual object? this[int index] { get; set; }
-            public bool Contains(object value);
+            public bool Contains(object? value);
-            public int IndexOf(object value);
+            public int IndexOf(object? value);
-            public void Insert(int index, object item);
+            public void Insert(int index, object? item);
-            public void Remove(object value);
+            public void Remove(object? value);
-            int IComparer<ComboBox.ObjectCollection.Entry>.Compare(ComboBox.ObjectCollection.Entry entry1, ComboBox.ObjectCollection.Entry entry2);
+            int IComparer<ComboBox.ObjectCollection.Entry>.Compare(ComboBox.ObjectCollection.Entry? entry1, ComboBox.ObjectCollection.Entry? entry2);
-            int IList.Add(object item);
+            int IList.Add(object? item);
         }
     }
     public class HtmlWindowCollection : ICollection, IEnumerable {
-        bool System.Collections.ICollection.IsSynchronized { get; }
+        bool ICollection.IsSynchronized { get; }
-        object System.Collections.ICollection.SyncRoot { get; }
+        object ICollection.SyncRoot { get; }
-        public HtmlWindow this[int index] { get; }
+        public HtmlWindow? this[int index] { get; }
-        public HtmlWindow this[string windowId] { get; }
+        public HtmlWindow? this[string windowId] { get; }
     }
     public static class ListBindingHelper {
-        public static object GetList(object list);
+        public static object? GetList(object? list);
-        public static object GetList(object dataSource, string dataMember);
+        public static object? GetList(object? dataSource, string? dataMember);
-        public static PropertyDescriptorCollection GetListItemProperties(object list);
+        public static PropertyDescriptorCollection GetListItemProperties(object? list);
-        public static PropertyDescriptorCollection GetListItemProperties(object list, PropertyDescriptor[] listAccessors);
+        public static PropertyDescriptorCollection GetListItemProperties(object? list, PropertyDescriptor[]? listAccessors);
-        public static PropertyDescriptorCollection GetListItemProperties(object dataSource, string dataMember, PropertyDescriptor[] listAccessors);
+        public static PropertyDescriptorCollection GetListItemProperties(object? dataSource, string? dataMember, PropertyDescriptor[]? listAccessors);
-        public static Type GetListItemType(object list);
+        public static Type? GetListItemType(object? list);
-        public static Type GetListItemType(object dataSource, string dataMember);
+        public static Type? GetListItemType(object? dataSource, string? dataMember);
-        public static string GetListName(object list, PropertyDescriptor[] listAccessors);
+        public static string GetListName(object? list, PropertyDescriptor[]? listAccessors);
     }
     [DefaultEventAttribute("SelectedIndexChanged")]
     [DefaultPropertyAttribute("Items")]
     [DesignerAttribute("System.Windows.Forms.Design.ListViewDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [DockingAttribute(DockingBehavior.Ask)]
     [SRDescriptionAttribute("DescriptionListView")]
     public class ListView : Control {
         [ListBindableAttribute(false)]
         public class ListViewItemCollection : ICollection, IEnumerable, IList {
-            bool System.Collections.ICollection.IsSynchronized { get; }
+            bool ICollection.IsSynchronized { get; }
-            object System.Collections.ICollection.SyncRoot { get; }
+            object ICollection.SyncRoot { get; }
-            bool System.Collections.IList.IsFixedSize { get; }
+            bool IList.IsFixedSize { get; }
-            object System.Collections.IList.this[int index] { get; set; }
+            object? IList.this[int index] { get; set; }
-            public virtual ListViewItem this[string key] { get; }
+            public virtual ListViewItem? this[string key] { get; }
-            public virtual ListViewItem Add(string text);
+            public virtual ListViewItem Add(string? text);
-            public virtual ListViewItem Add(string text, int imageIndex);
+            public virtual ListViewItem Add(string? text, int imageIndex);
-            public virtual ListViewItem Add(string text, string imageKey);
+            public virtual ListViewItem Add(string? text, string? imageKey);
-            public virtual ListViewItem Add(string key, string text, int imageIndex);
+            public virtual ListViewItem Add(string? key, string? text, int imageIndex);
-            public virtual ListViewItem Add(string key, string text, string imageKey);
+            public virtual ListViewItem Add(string? key, string? text, string? imageKey);
-            public virtual bool ContainsKey(string key);
+            public virtual bool ContainsKey(string? key);
-            public virtual int IndexOfKey(string key);
+            public virtual int IndexOfKey(string? key);
-            public ListViewItem Insert(int index, string text);
+            public ListViewItem Insert(int index, string? text);
-            public ListViewItem Insert(int index, string text, int imageIndex);
+            public ListViewItem Insert(int index, string? text, int imageIndex);
-            public ListViewItem Insert(int index, string text, string imageKey);
+            public ListViewItem Insert(int index, string? text, string? imageKey);
-            public virtual ListViewItem Insert(int index, string key, string text, int imageIndex);
+            public virtual ListViewItem Insert(int index, string? key, string? text, int imageIndex);
-            public virtual ListViewItem Insert(int index, string key, string text, string imageKey);
+            public virtual ListViewItem Insert(int index, string? key, string? text, string? imageKey);
-            int IList.Add(object item);
+            int IList.Add(object? item);
-            bool IList.Contains(object item);
+            bool IList.Contains(object? item);
-            int IList.IndexOf(object item);
+            int IList.IndexOf(object? item);
-            void IList.Insert(int index, object item);
+            void IList.Insert(int index, object? item);
-            void IList.Remove(object item);
+            void IList.Remove(object? item);
         }
     }
     [DefaultEventAttribute("ItemClicked")]
     [DefaultPropertyAttribute("Items")]
     [DesignerAttribute("System.Windows.Forms.Design.ToolStripDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [DesignerSerializerAttribute("System.Windows.Forms.Design.ToolStripCodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", "System.ComponentModel.Design.Serialization.CodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionToolStrip")]
     public class ToolStrip : ScrollableControl, IArrangedElement, IComponent, IDisposable, ISupportToolStripPanel {
-        public override BindingContext BindingContext { get; set; }
+        public override BindingContext? BindingContext { get; set; }
-        [BrowsableAttribute(false)]
-        [DefaultValueAttribute(null)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("ToolStripImageListDescr")]
-        public ImageList ImageList { get; set; }
+        [BrowsableAttribute(false)]
+        [DefaultValueAttribute(null)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("ToolStripImageListDescr")]
+        public ImageList? ImageList { get; set; }
-        [BrowsableAttribute(false)]
-        [DefaultValueAttribute(null)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        public LayoutSettings LayoutSettings { get; set; }
+        [BrowsableAttribute(false)]
+        [DefaultValueAttribute(null)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        public LayoutSettings? LayoutSettings { get; set; }
-        [BrowsableAttribute(true)]
-        [EditorBrowsableAttribute(0)]
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("ControlOnAutoSizeChangedDescr")]
-        public new event EventHandler AutoSizeChanged;
+        [BrowsableAttribute(true)]
+        [EditorBrowsableAttribute(0)]
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("ControlOnAutoSizeChangedDescr")]
+        public new event EventHandler? AutoSizeChanged;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("ToolStripOnBeginDrag")]
-        public event EventHandler BeginDrag;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("ToolStripOnBeginDrag")]
+        public event EventHandler? BeginDrag;
-        [BrowsableAttribute(false)]
-        public new event EventHandler CausesValidationChanged;
+        [BrowsableAttribute(false)]
+        public new event EventHandler? CausesValidationChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event ControlEventHandler ControlAdded;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event ControlEventHandler? ControlAdded;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event ControlEventHandler ControlRemoved;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event ControlEventHandler? ControlRemoved;
-        [BrowsableAttribute(false)]
-        public new event EventHandler CursorChanged;
+        [BrowsableAttribute(false)]
+        public new event EventHandler? CursorChanged;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("ToolStripOnEndDrag")]
-        public event EventHandler EndDrag;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("ToolStripOnEndDrag")]
+        public event EventHandler? EndDrag;
-        [BrowsableAttribute(false)]
-        public new event EventHandler ForeColorChanged;
+        [BrowsableAttribute(false)]
+        public new event EventHandler? ForeColorChanged;
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("ToolStripItemAddedDescr")]
-        public event ToolStripItemEventHandler ItemAdded;
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("ToolStripItemAddedDescr")]
+        public event ToolStripItemEventHandler? ItemAdded;
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("ToolStripItemOnClickDescr")]
-        public event ToolStripItemClickedEventHandler ItemClicked;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("ToolStripItemOnClickDescr")]
+        public event ToolStripItemClickedEventHandler? ItemClicked;
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("ToolStripItemRemovedDescr")]
-        public event ToolStripItemEventHandler ItemRemoved;
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("ToolStripItemRemovedDescr")]
+        public event ToolStripItemEventHandler? ItemRemoved;
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("ToolStripLayoutCompleteDescr")]
-        public event EventHandler LayoutCompleted;
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("ToolStripLayoutCompleteDescr")]
+        public event EventHandler? LayoutCompleted;
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("ToolStripLayoutStyleChangedDescr")]
-        public event EventHandler LayoutStyleChanged;
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("ToolStripLayoutStyleChangedDescr")]
+        public event EventHandler? LayoutStyleChanged;
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("ToolStripPaintGripDescr")]
-        public event PaintEventHandler PaintGrip;
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("ToolStripPaintGripDescr")]
+        public event PaintEventHandler? PaintGrip;
-        public event EventHandler RendererChanged;
+        public event EventHandler? RendererChanged;
-        protected internal virtual ToolStripItem CreateDefaultItem(string text, Image image, EventHandler onClick);
+        protected internal virtual ToolStripItem CreateDefaultItem(string? text, Image? image, EventHandler? onClick);
-        protected virtual LayoutSettings CreateLayoutSettings(ToolStripLayoutStyle layoutStyle);
+        protected virtual LayoutSettings? CreateLayoutSettings(ToolStripLayoutStyle layoutStyle);
-        [EditorBrowsableAttribute(1)]
-        public new Control GetChildAtPoint(Point point);
+        [EditorBrowsableAttribute(1)]
+        public new Control? GetChildAtPoint(Point point);
-        [EditorBrowsableAttribute(1)]
-        public new Control GetChildAtPoint(Point pt, GetChildAtPointSkip skipValue);
+        [EditorBrowsableAttribute(1)]
+        public new Control? GetChildAtPoint(Point pt, GetChildAtPointSkip skipValue);
-        public ToolStripItem GetItemAt(Point point);
+        public ToolStripItem? GetItemAt(Point point);
-        public ToolStripItem GetItemAt(int x, int y);
+        public ToolStripItem? GetItemAt(int x, int y);
-        public virtual ToolStripItem GetNextItem(ToolStripItem start, ArrowDirection direction);
+        public virtual ToolStripItem? GetNextItem(ToolStripItem? start, ArrowDirection direction);
     }
     public class ToolStripControlHost : ToolStripItem {
-        [DefaultValueAttribute(null)]
-        [LocalizableAttribute(true)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("ToolStripItemImageDescr")]
-        public override Image BackgroundImage { get; set; }
+        [DefaultValueAttribute(null)]
+        [LocalizableAttribute(true)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("ToolStripItemImageDescr")]
+        public override Image? BackgroundImage { get; set; }
-        public override Font Font { get; set; }
+        [AllowNullAttribute]
+        public override Font Font { get; set; }
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public override Image Image { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        public override Image? Image { get; set; }
-        [EditorBrowsableAttribute(2)]
-        public override ISite Site { get; set; }
+        [EditorBrowsableAttribute(2)]
+        public override ISite? Site { get; set; }
-        [DefaultValueAttribute("")]
-        public override string Text { get; set; }
+        [DefaultValueAttribute("")]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler DisplayStyleChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? DisplayStyleChanged;
-        [SRCategoryAttribute("CatFocus")]
-        [SRDescriptionAttribute("ControlOnEnterDescr")]
-        public event EventHandler Enter;
+        [SRCategoryAttribute("CatFocus")]
+        [SRDescriptionAttribute("ControlOnEnterDescr")]
+        public event EventHandler? Enter;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(2)]
-        [SRCategoryAttribute("CatFocus")]
-        [SRDescriptionAttribute("ToolStripItemOnGotFocusDescr")]
-        public event EventHandler GotFocus;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(2)]
+        [SRCategoryAttribute("CatFocus")]
+        [SRDescriptionAttribute("ToolStripItemOnGotFocusDescr")]
+        public event EventHandler? GotFocus;
-        [SRCategoryAttribute("CatKey")]
-        [SRDescriptionAttribute("ControlOnKeyDownDescr")]
-        public event KeyEventHandler KeyDown;
+        [SRCategoryAttribute("CatKey")]
+        [SRDescriptionAttribute("ControlOnKeyDownDescr")]
+        public event KeyEventHandler? KeyDown;
-        [SRCategoryAttribute("CatKey")]
-        [SRDescriptionAttribute("ControlOnKeyPressDescr")]
-        public event KeyPressEventHandler KeyPress;
+        [SRCategoryAttribute("CatKey")]
+        [SRDescriptionAttribute("ControlOnKeyPressDescr")]
+        public event KeyPressEventHandler? KeyPress;
-        [SRCategoryAttribute("CatKey")]
-        [SRDescriptionAttribute("ControlOnKeyUpDescr")]
-        public event KeyEventHandler KeyUp;
+        [SRCategoryAttribute("CatKey")]
+        [SRDescriptionAttribute("ControlOnKeyUpDescr")]
+        public event KeyEventHandler? KeyUp;
-        [SRCategoryAttribute("CatFocus")]
-        [SRDescriptionAttribute("ControlOnLeaveDescr")]
-        public event EventHandler Leave;
+        [SRCategoryAttribute("CatFocus")]
+        [SRDescriptionAttribute("ControlOnLeaveDescr")]
+        public event EventHandler? Leave;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(2)]
-        [SRCategoryAttribute("CatFocus")]
-        [SRDescriptionAttribute("ToolStripItemOnLostFocusDescr")]
-        public event EventHandler LostFocus;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(2)]
+        [SRCategoryAttribute("CatFocus")]
+        [SRDescriptionAttribute("ToolStripItemOnLostFocusDescr")]
+        public event EventHandler? LostFocus;
-        [SRCategoryAttribute("CatFocus")]
-        [SRDescriptionAttribute("ControlOnValidatedDescr")]
-        public event EventHandler Validated;
+        [SRCategoryAttribute("CatFocus")]
+        [SRDescriptionAttribute("ControlOnValidatedDescr")]
+        public event EventHandler? Validated;
-        [SRCategoryAttribute("CatFocus")]
-        [SRDescriptionAttribute("ControlOnValidatingDescr")]
-        public event CancelEventHandler Validating;
+        [SRCategoryAttribute("CatFocus")]
+        [SRDescriptionAttribute("ControlOnValidatingDescr")]
+        public event CancelEventHandler? Validating;
-        protected override void OnParentChanged(ToolStrip oldParent, ToolStrip newParent);
+        protected override void OnParentChanged(ToolStrip? oldParent, ToolStrip? newParent);
-        protected virtual void OnSubscribeControlEvents(Control control);
+        protected virtual void OnSubscribeControlEvents(Control? control);
-        protected virtual void OnUnsubscribeControlEvents(Control control);
+        protected virtual void OnUnsubscribeControlEvents(Control? control);
     }
 }
```

