# Microsoft.AspNetCore.Authentication.BearerToken

``` diff
+namespace Microsoft.AspNetCore.Authentication.BearerToken {
+    public static class BearerTokenDefaults {
+        public const string AuthenticationScheme = "BearerToken";
+    }
+    public class BearerTokenEvents {
+        public BearerTokenEvents();
+        public Func<MessageReceivedContext, Task> OnMessageReceived { get; set; }
+        public virtual Task MessageReceived(MessageReceivedContext context);
+    }
+    public sealed class BearerTokenOptions : AuthenticationSchemeOptions {
+        public BearerTokenOptions();
+        public TimeSpan BearerTokenExpiration { get; set; }
+        public ISecureDataFormat<AuthenticationTicket>? BearerTokenProtector { get; set; }
+        public new BearerTokenEvents Events { get; set; }
+    }
+    public class MessageReceivedContext : ResultContext<BearerTokenOptions> {
+        public MessageReceivedContext(HttpContext context, AuthenticationScheme scheme, BearerTokenOptions options);
+        public string Token { get; set; }
+    }
+}
```

