# Microsoft.AspNetCore.Components

``` diff
 namespace Microsoft.AspNetCore.Components {
+    public sealed class CascadingModelBinder : IComponent, IDisposable {
+        public CascadingModelBinder();
+        [ParameterAttribute]
+        public RenderFragment<ModelBindingContext> ChildContent { get; set; }
+        [ParameterAttribute]
+        public bool IsFixed { get; set; }
+        [ParameterAttribute]
+        public string Name { get; set; }
+        void IComponent.Attach(RenderHandle renderHandle);
+        Task IComponent.SetParametersAsync(ParameterView parameters);
+        void IDisposable.Dispose();
+    }
+    public sealed class ModelBindingContext {
+        public string BindingContextId { get; }
+        public string Name { get; }
+    }
+    [AttributeUsageAttribute(4, AllowMultiple=false)]
+    public class StreamRenderingAttribute : Attribute {
+        public StreamRenderingAttribute(bool enabled);
+        public bool Enabled { get; }
+    }
 }
```

