# Microsoft.AspNetCore.Http

``` diff
 namespace Microsoft.AspNetCore.Http {
     public static class HttpResponseJsonExtensions {
-        public static Task WriteAsJsonAsync(this HttpResponse response, object? value, Type type, CancellationToken cancellationToken = default(CancellationToken));
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
+        public static Task WriteAsJsonAsync(this HttpResponse response, object? value, Type type, CancellationToken cancellationToken = default(CancellationToken));
-        public static Task WriteAsJsonAsync<TValue>(this HttpResponse response, TValue value, CancellationToken cancellationToken = default(CancellationToken));
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
+        public static Task WriteAsJsonAsync<TValue>(this HttpResponse response, TValue value, CancellationToken cancellationToken = default(CancellationToken));
     }
     public sealed class ProblemDetailsContext {
+        public Exception? Exception { get; set; }
     }
 }
```

