# Microsoft.Extensions.DependencyInjection

``` diff
 namespace Microsoft.Extensions.DependencyInjection {
     public static class AuthenticationServiceCollectionExtensions {
-        public static AuthenticationBuilder AddAuthentication(this IServiceCollection services);
+        [RequiresUnreferencedCodeAttribute("Authentication middleware does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static AuthenticationBuilder AddAuthentication(this IServiceCollection services);
-        public static AuthenticationBuilder AddAuthentication(this IServiceCollection services, Action<AuthenticationOptions> configureOptions);
+        [RequiresUnreferencedCodeAttribute("Authentication middleware does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static AuthenticationBuilder AddAuthentication(this IServiceCollection services, Action<AuthenticationOptions> configureOptions);
-        public static AuthenticationBuilder AddAuthentication(this IServiceCollection services, string defaultScheme);
+        [RequiresUnreferencedCodeAttribute("Authentication middleware does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static AuthenticationBuilder AddAuthentication(this IServiceCollection services, string defaultScheme);
     }
+    public static class BearerTokenExtensions {
+        public static AuthenticationBuilder AddBearerToken(this AuthenticationBuilder builder);
+        public static AuthenticationBuilder AddBearerToken(this AuthenticationBuilder builder, Action<BearerTokenOptions> configure);
+        public static AuthenticationBuilder AddBearerToken(this AuthenticationBuilder builder, string authenticationScheme);
+        public static AuthenticationBuilder AddBearerToken(this AuthenticationBuilder builder, string authenticationScheme, Action<BearerTokenOptions> configure);
+    }
     public static class ComponentServiceCollectionExtensions {
-        public static IServerSideBlazorBuilder AddServerSideBlazor(this IServiceCollection services, Action<CircuitOptions>? configure = null);
+        [RequiresUnreferencedCodeAttribute("Server-side Blazor does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static IServerSideBlazorBuilder AddServerSideBlazor(this IServiceCollection services, Action<CircuitOptions>? configure = null);
     }
+    public static class IdentityApiEndpointsServiceCollectionExtensions {
+        [RequiresUnreferencedCodeAttribute("Authentication middleware does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static IdentityBuilder AddIdentityApiEndpoints<TUser>(this IServiceCollection services) where TUser : class, new();
+        [RequiresUnreferencedCodeAttribute("Authentication middleware does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static IdentityBuilder AddIdentityApiEndpoints<TUser>(this IServiceCollection services, Action<IdentityOptions> configure) where TUser : class, new();
+    }
     public static class IdentityServiceCollectionExtensions {
-        public static IdentityBuilder AddIdentity<TUser, TRole>(this IServiceCollection services) where TUser : class where TRole : class;
+        [RequiresUnreferencedCodeAttribute("Identity middleware does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static IdentityBuilder AddIdentity<TUser, TRole>(this IServiceCollection services) where TUser : class where TRole : class;
-        public static IdentityBuilder AddIdentity<TUser, TRole>(this IServiceCollection services, Action<IdentityOptions> setupAction) where TUser : class where TRole : class;
+        [RequiresUnreferencedCodeAttribute("Identity middleware does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static IdentityBuilder AddIdentity<TUser, TRole>(this IServiceCollection services, Action<IdentityOptions> setupAction) where TUser : class where TRole : class;
     }
     public static class MvcRazorPagesMvcCoreBuilderExtensions {
-        public static IMvcCoreBuilder AddRazorPages(this IMvcCoreBuilder builder);
+        [RequiresUnreferencedCodeAttribute("Razor Pages does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static IMvcCoreBuilder AddRazorPages(this IMvcCoreBuilder builder);
     }
     public static class MvcServiceCollectionExtensions {
-        public static IMvcBuilder AddControllers(this IServiceCollection services);
+        [RequiresUnreferencedCodeAttribute("MVC does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static IMvcBuilder AddControllers(this IServiceCollection services);
-        public static IMvcBuilder AddControllers(this IServiceCollection services, Action<MvcOptions>? configure);
+        [RequiresUnreferencedCodeAttribute("MVC does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static IMvcBuilder AddControllers(this IServiceCollection services, Action<MvcOptions>? configure);
-        public static IMvcBuilder AddControllersWithViews(this IServiceCollection services);
+        [RequiresUnreferencedCodeAttribute("MVC does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static IMvcBuilder AddControllersWithViews(this IServiceCollection services);
-        public static IMvcBuilder AddControllersWithViews(this IServiceCollection services, Action<MvcOptions>? configure);
+        [RequiresUnreferencedCodeAttribute("MVC does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static IMvcBuilder AddControllersWithViews(this IServiceCollection services, Action<MvcOptions>? configure);
-        public static IMvcBuilder AddMvc(this IServiceCollection services);
+        [RequiresUnreferencedCodeAttribute("MVC does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static IMvcBuilder AddMvc(this IServiceCollection services);
-        public static IMvcBuilder AddMvc(this IServiceCollection services, Action<MvcOptions> setupAction);
+        [RequiresUnreferencedCodeAttribute("MVC does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static IMvcBuilder AddMvc(this IServiceCollection services, Action<MvcOptions> setupAction);
-        public static IMvcBuilder AddRazorPages(this IServiceCollection services);
+        [RequiresUnreferencedCodeAttribute("Razor Pages does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static IMvcBuilder AddRazorPages(this IServiceCollection services);
-        public static IMvcBuilder AddRazorPages(this IServiceCollection services, Action<RazorPagesOptions>? configure);
+        [RequiresUnreferencedCodeAttribute("Razor Pages does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static IMvcBuilder AddRazorPages(this IServiceCollection services, Action<RazorPagesOptions>? configure);
     }
     public static class RazorComponentsServiceCollectionExtensions {
-        public static IRazorComponentsBuilder AddRazorComponents(this IServiceCollection services);
+        [RequiresUnreferencedCodeAttribute("Razor Components does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static IRazorComponentsBuilder AddRazorComponents(this IServiceCollection services);
     }
     public static class SessionServiceCollectionExtensions {
-        public static IServiceCollection AddSession(this IServiceCollection services);
+        [RequiresUnreferencedCodeAttribute("Session State middleware does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static IServiceCollection AddSession(this IServiceCollection services);
-        public static IServiceCollection AddSession(this IServiceCollection services, Action<SessionOptions> configure);
+        [RequiresUnreferencedCodeAttribute("Session State middleware does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static IServiceCollection AddSession(this IServiceCollection services, Action<SessionOptions> configure);
     }
     public static class SignalRDependencyInjectionExtensions {
-        public static ISignalRServerBuilder AddSignalR(this IServiceCollection services);
+        [RequiresUnreferencedCodeAttribute("SignalR does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static ISignalRServerBuilder AddSignalR(this IServiceCollection services);
-        public static ISignalRServerBuilder AddSignalR(this IServiceCollection services, Action<HubOptions> configure);
+        [RequiresUnreferencedCodeAttribute("SignalR does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static ISignalRServerBuilder AddSignalR(this IServiceCollection services, Action<HubOptions> configure);
     }
 }
```

