# System.ComponentModel.DataAnnotations

``` diff
 namespace System.ComponentModel.DataAnnotations {
     public sealed class ValidationContext : IServiceProvider {
-        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered.")]
-        public ValidationContext(object instance);
+        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered and the Type's properties can be trimmed.")]
+        public ValidationContext(object instance);
-        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered.")]
-        public ValidationContext(object instance, IDictionary<object, object?>? items);
+        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered and the Type's properties can be trimmed.")]
+        public ValidationContext(object instance, IDictionary<object, object?>? items);
-        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered.")]
-        public ValidationContext(object instance, IServiceProvider? serviceProvider, IDictionary<object, object?>? items);
+        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered and the Type's properties can be trimmed.")]
+        public ValidationContext(object instance, IServiceProvider? serviceProvider, IDictionary<object, object?>? items);
     }
     public class ValidationException : Exception {
-        protected ValidationException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected ValidationException(SerializationInfo info, StreamingContext context);
     }
     public static class Validator {
-        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered.")]
-        public static bool TryValidateObject(object instance, ValidationContext validationContext, ICollection<ValidationResult>? validationResults);
+        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered and the Type's properties can be trimmed.")]
+        public static bool TryValidateObject(object instance, ValidationContext validationContext, ICollection<ValidationResult>? validationResults);
-        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered.")]
-        public static bool TryValidateObject(object instance, ValidationContext validationContext, ICollection<ValidationResult>? validationResults, bool validateAllProperties);
+        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered and the Type's properties can be trimmed.")]
+        public static bool TryValidateObject(object instance, ValidationContext validationContext, ICollection<ValidationResult>? validationResults, bool validateAllProperties);
-        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered.")]
-        public static void ValidateObject(object instance, ValidationContext validationContext);
+        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered and the Type's properties can be trimmed.")]
+        public static void ValidateObject(object instance, ValidationContext validationContext);
-        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered.")]
-        public static void ValidateObject(object instance, ValidationContext validationContext, bool validateAllProperties);
+        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered and the Type's properties can be trimmed.")]
+        public static void ValidateObject(object instance, ValidationContext validationContext, bool validateAllProperties);
     }
 }
```

