# System.Net

``` diff
 namespace System.Net {
     public class CookieException : FormatException, ISerializable {
-        protected CookieException(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected CookieException(SerializationInfo serializationInfo, StreamingContext streamingContext);
-        public override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
     }
     public class FileWebRequest : WebRequest, ISerializable {
-        [ObsoleteAttribute("Serialization has been deprecated for FileWebRequest.")]
-        protected FileWebRequest(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("Serialization has been deprecated for FileWebRequest.")]
+        protected FileWebRequest(SerializationInfo serializationInfo, StreamingContext streamingContext);
     }
     public class FileWebResponse : WebResponse, ISerializable {
-        [ObsoleteAttribute("Serialization has been deprecated for FileWebResponse.")]
-        protected FileWebResponse(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("Serialization has been deprecated for FileWebResponse.")]
+        protected FileWebResponse(SerializationInfo serializationInfo, StreamingContext streamingContext);
     }
     public class HttpListenerException : Win32Exception {
-        protected HttpListenerException(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected HttpListenerException(SerializationInfo serializationInfo, StreamingContext streamingContext);
     }
     public class HttpWebRequest : WebRequest, ISerializable {
-        [ObsoleteAttribute("WebRequest, HttpWebRequest, ServicePoint, and WebClient are obsolete. Use HttpClient instead.", DiagnosticId="SYSLIB0014", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        protected HttpWebRequest(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("WebRequest, HttpWebRequest, ServicePoint, and WebClient are obsolete. Use HttpClient instead.", DiagnosticId="SYSLIB0014", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected HttpWebRequest(SerializationInfo serializationInfo, StreamingContext streamingContext);
     }
     public class HttpWebResponse : WebResponse, ISerializable {
-        [ObsoleteAttribute("Serialization has been deprecated for HttpWebResponse.")]
-        protected HttpWebResponse(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("Serialization has been deprecated for HttpWebResponse.")]
+        protected HttpWebResponse(SerializationInfo serializationInfo, StreamingContext streamingContext);
     }
-    public class IPAddress : IFormattable, IParsable<IPAddress>, ISpanFormattable, ISpanParsable<IPAddress> {
+    public class IPAddress : IFormattable, IParsable<IPAddress>, ISpanFormattable, ISpanParsable<IPAddress>, IUtf8SpanFormattable {
+        bool IUtf8SpanFormattable.TryFormat(Span<byte> utf8Destination, out int bytesWritten, ReadOnlySpan<char> format, IFormatProvider provider);
+        public bool TryFormat(Span<byte> utf8Destination, out int bytesWritten);
     }
+    public readonly struct IPNetwork : IEquatable<IPNetwork>, IFormattable, IParsable<IPNetwork>, ISpanFormattable, ISpanParsable<IPNetwork>, IUtf8SpanFormattable {
+        public IPNetwork(IPAddress baseAddress, int prefixLength);
+        public IPAddress BaseAddress { get; }
+        public int PrefixLength { get; }
+        public bool Contains(IPAddress address);
+        public bool Equals(IPNetwork other);
+        public override bool Equals([NotNullWhenAttribute(true)] object? obj);
+        public override int GetHashCode();
+        public static bool operator ==(IPNetwork left, IPNetwork right);
+        public static bool operator !=(IPNetwork left, IPNetwork right);
+        public static IPNetwork Parse(ReadOnlySpan<char> s);
+        public static IPNetwork Parse(string s);
+        string IFormattable.ToString(string format, IFormatProvider provider);
+        static IPNetwork IParsable<IPNetwork>.Parse([NotNullAttribute] string s, IFormatProvider provider);
+        static bool IParsable<IPNetwork>.TryParse([NotNullWhenAttribute(true)] string s, IFormatProvider provider, out IPNetwork result);
+        bool ISpanFormattable.TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format, IFormatProvider provider);
+        static IPNetwork ISpanParsable<IPNetwork>.Parse(ReadOnlySpan<char> s, IFormatProvider provider);
+        static bool ISpanParsable<IPNetwork>.TryParse(ReadOnlySpan<char> s, IFormatProvider provider, out IPNetwork result);
+        bool IUtf8SpanFormattable.TryFormat(Span<byte> utf8Destination, out int bytesWritten, ReadOnlySpan<char> format, IFormatProvider provider);
+        public override string ToString();
+        public bool TryFormat(Span<byte> utf8Destination, out int bytesWritten);
+        public bool TryFormat(Span<char> destination, out int charsWritten);
+        public static bool TryParse(ReadOnlySpan<char> s, out IPNetwork result);
+        public static bool TryParse(string? s, out IPNetwork result);
+    }
     public class ProtocolViolationException : InvalidOperationException, ISerializable {
-        protected ProtocolViolationException(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected ProtocolViolationException(SerializationInfo serializationInfo, StreamingContext streamingContext);
-        public override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
     }
     public class WebException : InvalidOperationException, ISerializable {
-        protected WebException(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected WebException(SerializationInfo serializationInfo, StreamingContext streamingContext);
-        public override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
     }
     public class WebHeaderCollection : NameValueCollection, IEnumerable, ISerializable {
-        protected WebHeaderCollection(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected WebHeaderCollection(SerializationInfo serializationInfo, StreamingContext streamingContext);
-        public override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
     }
     public class WebProxy : ISerializable, IWebProxy {
-        protected WebProxy(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected WebProxy(SerializationInfo serializationInfo, StreamingContext streamingContext);
     }
     public abstract class WebRequest : MarshalByRefObject, ISerializable {
-        [ObsoleteAttribute("WebRequest, HttpWebRequest, ServicePoint, and WebClient are obsolete. Use HttpClient instead.", DiagnosticId="SYSLIB0014", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        protected WebRequest(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("WebRequest, HttpWebRequest, ServicePoint, and WebClient are obsolete. Use HttpClient instead.", DiagnosticId="SYSLIB0014", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected WebRequest(SerializationInfo serializationInfo, StreamingContext streamingContext);
     }
     public abstract class WebResponse : MarshalByRefObject, IDisposable, ISerializable {
-        [ObsoleteAttribute("Serialization has been deprecated for WebResponse.")]
-        protected WebResponse(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("Serialization has been deprecated for WebResponse.")]
+        protected WebResponse(SerializationInfo serializationInfo, StreamingContext streamingContext);
     }
 }
```

