# System.Reflection

``` diff
 namespace System.Reflection {
     public abstract class Assembly : ICustomAttributeProvider, ISerializable {
-        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
     }
     public sealed class AssemblyName : ICloneable, IDeserializationCallback, ISerializable {
-        public void GetObjectData(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public void GetObjectData(SerializationInfo info, StreamingContext context);
     }
     public class CustomAttributeFormatException : FormatException {
-        protected CustomAttributeFormatException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected CustomAttributeFormatException(SerializationInfo info, StreamingContext context);
     }
     [FlagsAttribute]
     public enum FieldAttributes {
-        NotSerialized = 128,
+        [ObsoleteAttribute("Formatter-based serialization is obsolete and should not be used.", DiagnosticId="SYSLIB0050", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        NotSerialized = 128,
     }
     public abstract class FieldInfo : MemberInfo {
-        public bool IsNotSerialized { get; }
+        [ObsoleteAttribute("Formatter-based serialization is obsolete and should not be used.", DiagnosticId="SYSLIB0050", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public bool IsNotSerialized { get; }
     }
     public class InvalidFilterCriteriaException : ApplicationException {
-        protected InvalidFilterCriteriaException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected InvalidFilterCriteriaException(SerializationInfo info, StreamingContext context);
     }
     public abstract class Module : ICustomAttributeProvider, ISerializable {
-        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
     }
     public class ParameterInfo : ICustomAttributeProvider, IObjectReference {
-        public object GetRealObject(StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public object GetRealObject(StreamingContext context);
     }
-    public sealed class ReflectionTypeLoadException : SystemException, ISerializable {
+    public sealed class ReflectionTypeLoadException : SystemException {
-        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
     }
     [ObsoleteAttribute("Strong name signing is not supported and throws PlatformNotSupportedException.", DiagnosticId="SYSLIB0017", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
     public class StrongNameKeyPair : IDeserializationCallback, ISerializable {
-        protected StrongNameKeyPair(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected StrongNameKeyPair(SerializationInfo info, StreamingContext context);
     }
     public class TargetException : ApplicationException {
-        protected TargetException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected TargetException(SerializationInfo info, StreamingContext context);
     }
     [FlagsAttribute]
     public enum TypeAttributes {
-        Serializable = 8192,
+        [ObsoleteAttribute("Formatter-based serialization is obsolete and should not be used.", DiagnosticId="SYSLIB0050", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        Serializable = 8192,
     }
 }
```

