# System.Runtime.InteropServices

``` diff
 namespace System.Runtime.InteropServices {
     public static class CollectionsMarshal {
+        public static void SetCount<T>(List<T> list, int count);
     }
     public class COMException : ExternalException {
-        protected COMException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected COMException(SerializationInfo info, StreamingContext context);
     }
     public class ExternalException : SystemException {
-        protected ExternalException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected ExternalException(SerializationInfo info, StreamingContext context);
     }
     public class InvalidComObjectException : SystemException {
-        protected InvalidComObjectException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected InvalidComObjectException(SerializationInfo info, StreamingContext context);
     }
     public class InvalidOleVariantTypeException : SystemException {
-        protected InvalidOleVariantTypeException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected InvalidOleVariantTypeException(SerializationInfo info, StreamingContext context);
     }
     public class MarshalDirectiveException : SystemException {
-        protected MarshalDirectiveException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected MarshalDirectiveException(SerializationInfo info, StreamingContext context);
     }
-    public readonly struct NFloat : IAdditionOperators<NFloat, NFloat, NFloat>, IAdditiveIdentity<NFloat, NFloat>, IBinaryFloatingPointIeee754<NFloat>, IBinaryNumber<NFloat>, IBitwiseOperators<NFloat, NFloat, NFloat>, IComparable, IComparable<NFloat>, IComparisonOperators<NFloat, NFloat, bool>, IDecrementOperators<NFloat>, IDivisionOperators<NFloat, NFloat, NFloat>, IEqualityOperators<NFloat, NFloat, bool>, IEquatable<NFloat>, IExponentialFunctions<NFloat>, IFloatingPoint<NFloat>, IFloatingPointConstants<NFloat>, IFloatingPointIeee754<NFloat>, IFormattable, IHyperbolicFunctions<NFloat>, IIncrementOperators<NFloat>, ILogarithmicFunctions<NFloat>, IMinMaxValue<NFloat>, IModulusOperators<NFloat, NFloat, NFloat>, IMultiplicativeIdentity<NFloat, NFloat>, IMultiplyOperators<NFloat, NFloat, NFloat>, INumber<NFloat>, INumberBase<NFloat>, IParsable<NFloat>, IPowerFunctions<NFloat>, IRootFunctions<NFloat>, ISignedNumber<NFloat>, ISpanFormattable, ISpanParsable<NFloat>, ISubtractionOperators<NFloat, NFloat, NFloat>, ITrigonometricFunctions<NFloat>, IUnaryNegationOperators<NFloat, NFloat>, IUnaryPlusOperators<NFloat, NFloat> {
+    public readonly struct NFloat : IAdditionOperators<NFloat, NFloat, NFloat>, IAdditiveIdentity<NFloat, NFloat>, IBinaryFloatingPointIeee754<NFloat>, IBinaryNumber<NFloat>, IBitwiseOperators<NFloat, NFloat, NFloat>, IComparable, IComparable<NFloat>, IComparisonOperators<NFloat, NFloat, bool>, IDecrementOperators<NFloat>, IDivisionOperators<NFloat, NFloat, NFloat>, IEqualityOperators<NFloat, NFloat, bool>, IEquatable<NFloat>, IExponentialFunctions<NFloat>, IFloatingPoint<NFloat>, IFloatingPointConstants<NFloat>, IFloatingPointIeee754<NFloat>, IFormattable, IHyperbolicFunctions<NFloat>, IIncrementOperators<NFloat>, ILogarithmicFunctions<NFloat>, IMinMaxValue<NFloat>, IModulusOperators<NFloat, NFloat, NFloat>, IMultiplicativeIdentity<NFloat, NFloat>, IMultiplyOperators<NFloat, NFloat, NFloat>, INumber<NFloat>, INumberBase<NFloat>, IParsable<NFloat>, IPowerFunctions<NFloat>, IRootFunctions<NFloat>, ISignedNumber<NFloat>, ISpanFormattable, ISpanParsable<NFloat>, ISubtractionOperators<NFloat, NFloat, NFloat>, ITrigonometricFunctions<NFloat>, IUnaryNegationOperators<NFloat, NFloat>, IUnaryPlusOperators<NFloat, NFloat>, IUtf8SpanFormattable {
+        public bool TryFormat(Span<byte> utf8Destination, out int bytesWritten, [StringSyntaxAttribute("NumericFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
     }
     public class SafeArrayRankMismatchException : SystemException {
-        protected SafeArrayRankMismatchException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected SafeArrayRankMismatchException(SerializationInfo info, StreamingContext context);
     }
     public class SafeArrayTypeMismatchException : SystemException {
-        protected SafeArrayTypeMismatchException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected SafeArrayTypeMismatchException(SerializationInfo info, StreamingContext context);
     }
     public class SEHException : ExternalException {
-        protected SEHException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected SEHException(SerializationInfo info, StreamingContext context);
     }
 }
```

