# System.Runtime.Intrinsics.Wasm

``` diff
 namespace System.Runtime.Intrinsics.Wasm {
     [CLSCompliantAttribute(false)]
     public abstract class PackedSimd {
+        public static Vector128<short> Abs(Vector128<short> value);
+        public static Vector128<int> Abs(Vector128<int> value);
+        public static Vector128<long> Abs(Vector128<long> value);
+        public static Vector128<IntPtr> Abs(Vector128<IntPtr> value);
+        public static Vector128<sbyte> Abs(Vector128<sbyte> value);
+        public static Vector128<ushort> AddPairwiseWidening(Vector128<byte> value);
+        public static Vector128<int> AddPairwiseWidening(Vector128<short> value);
+        public static Vector128<short> AddPairwiseWidening(Vector128<sbyte> value);
+        public static Vector128<uint> AddPairwiseWidening(Vector128<ushort> value);
+        public static Vector128<byte> AddSaturate(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<short> AddSaturate(Vector128<short> left, Vector128<short> right);
+        public static Vector128<sbyte> AddSaturate(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> AddSaturate(Vector128<ushort> left, Vector128<ushort> right);
+        public static bool AllTrue(Vector128<byte> value);
+        public static bool AllTrue(Vector128<short> value);
+        public static bool AllTrue(Vector128<int> value);
+        public static bool AllTrue(Vector128<long> value);
+        public static bool AllTrue(Vector128<IntPtr> value);
+        public static bool AllTrue(Vector128<sbyte> value);
+        public static bool AllTrue(Vector128<ushort> value);
+        public static bool AllTrue(Vector128<uint> value);
+        public static bool AllTrue(Vector128<ulong> value);
+        public static bool AllTrue(Vector128<UIntPtr> value);
+        public static Vector128<byte> AndNot(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> AndNot(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> AndNot(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> AndNot(Vector128<int> left, Vector128<int> right);
+        public static Vector128<long> AndNot(Vector128<long> left, Vector128<long> right);
+        public static Vector128<IntPtr> AndNot(Vector128<IntPtr> left, Vector128<IntPtr> right);
+        public static Vector128<sbyte> AndNot(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<float> AndNot(Vector128<float> left, Vector128<float> right);
+        public static Vector128<ushort> AndNot(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> AndNot(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ulong> AndNot(Vector128<ulong> left, Vector128<ulong> right);
+        public static Vector128<UIntPtr> AndNot(Vector128<UIntPtr> left, Vector128<UIntPtr> right);
+        public static bool AnyTrue(Vector128<byte> value);
+        public static bool AnyTrue(Vector128<double> value);
+        public static bool AnyTrue(Vector128<short> value);
+        public static bool AnyTrue(Vector128<int> value);
+        public static bool AnyTrue(Vector128<long> value);
+        public static bool AnyTrue(Vector128<IntPtr> value);
+        public static bool AnyTrue(Vector128<sbyte> value);
+        public static bool AnyTrue(Vector128<float> value);
+        public static bool AnyTrue(Vector128<ushort> value);
+        public static bool AnyTrue(Vector128<uint> value);
+        public static bool AnyTrue(Vector128<ulong> value);
+        public static bool AnyTrue(Vector128<UIntPtr> value);
+        public static Vector128<byte> AverageRounded(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<ushort> AverageRounded(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<byte> BitwiseSelect(Vector128<byte> left, Vector128<byte> right, Vector128<byte> select);
+        public static Vector128<double> BitwiseSelect(Vector128<double> left, Vector128<double> right, Vector128<double> select);
+        public static Vector128<short> BitwiseSelect(Vector128<short> left, Vector128<short> right, Vector128<short> select);
+        public static Vector128<int> BitwiseSelect(Vector128<int> left, Vector128<int> right, Vector128<int> select);
+        public static Vector128<long> BitwiseSelect(Vector128<long> left, Vector128<long> right, Vector128<long> select);
+        public static Vector128<IntPtr> BitwiseSelect(Vector128<IntPtr> left, Vector128<IntPtr> right, Vector128<IntPtr> select);
+        public static Vector128<sbyte> BitwiseSelect(Vector128<sbyte> left, Vector128<sbyte> right, Vector128<sbyte> select);
+        public static Vector128<float> BitwiseSelect(Vector128<float> left, Vector128<float> right, Vector128<float> select);
+        public static Vector128<ushort> BitwiseSelect(Vector128<ushort> left, Vector128<ushort> right, Vector128<ushort> select);
+        public static Vector128<uint> BitwiseSelect(Vector128<uint> left, Vector128<uint> right, Vector128<uint> select);
+        public static Vector128<ulong> BitwiseSelect(Vector128<ulong> left, Vector128<ulong> right, Vector128<ulong> select);
+        public static Vector128<UIntPtr> BitwiseSelect(Vector128<UIntPtr> left, Vector128<UIntPtr> right, Vector128<UIntPtr> select);
+        public static Vector128<byte> Max(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<short> Max(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> Max(Vector128<int> left, Vector128<int> right);
+        public static Vector128<sbyte> Max(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> Max(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> Max(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<byte> Min(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<short> Min(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> Min(Vector128<int> left, Vector128<int> right);
+        public static Vector128<sbyte> Min(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> Min(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> Min(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<short> MultiplyRoundedSaturateQ15(Vector128<short> left, Vector128<short> right);
+        public static Vector128<ushort> MultiplyWideningLower(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<int> MultiplyWideningLower(Vector128<short> left, Vector128<short> right);
+        public static Vector128<long> MultiplyWideningLower(Vector128<int> left, Vector128<int> right);
+        public static Vector128<short> MultiplyWideningLower(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<uint> MultiplyWideningLower(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<ulong> MultiplyWideningLower(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ushort> MultiplyWideningUpper(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<int> MultiplyWideningUpper(Vector128<short> left, Vector128<short> right);
+        public static Vector128<long> MultiplyWideningUpper(Vector128<int> left, Vector128<int> right);
+        public static Vector128<short> MultiplyWideningUpper(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<uint> MultiplyWideningUpper(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<ulong> MultiplyWideningUpper(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<byte> Not(Vector128<byte> value);
+        public static Vector128<double> Not(Vector128<double> value);
+        public static Vector128<short> Not(Vector128<short> value);
+        public static Vector128<int> Not(Vector128<int> value);
+        public static Vector128<long> Not(Vector128<long> value);
+        public static Vector128<IntPtr> Not(Vector128<IntPtr> value);
+        public static Vector128<sbyte> Not(Vector128<sbyte> value);
+        public static Vector128<float> Not(Vector128<float> value);
+        public static Vector128<ushort> Not(Vector128<ushort> value);
+        public static Vector128<uint> Not(Vector128<uint> value);
+        public static Vector128<ulong> Not(Vector128<ulong> value);
+        public static Vector128<UIntPtr> Not(Vector128<UIntPtr> value);
+        public static Vector128<byte> Or(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> Or(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> Or(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> Or(Vector128<int> left, Vector128<int> right);
+        public static Vector128<long> Or(Vector128<long> left, Vector128<long> right);
+        public static Vector128<IntPtr> Or(Vector128<IntPtr> left, Vector128<IntPtr> right);
+        public static Vector128<sbyte> Or(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<float> Or(Vector128<float> left, Vector128<float> right);
+        public static Vector128<ushort> Or(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> Or(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ulong> Or(Vector128<ulong> left, Vector128<ulong> right);
+        public static Vector128<UIntPtr> Or(Vector128<UIntPtr> left, Vector128<UIntPtr> right);
+        public static Vector128<byte> PopCount(Vector128<byte> value);
+        public static Vector128<byte> ShiftLeft(Vector128<byte> value, int count);
+        public static Vector128<short> ShiftLeft(Vector128<short> value, int count);
+        public static Vector128<int> ShiftLeft(Vector128<int> value, int count);
+        public static Vector128<long> ShiftLeft(Vector128<long> value, int count);
+        public static Vector128<IntPtr> ShiftLeft(Vector128<IntPtr> value, int count);
+        public static Vector128<sbyte> ShiftLeft(Vector128<sbyte> value, int count);
+        public static Vector128<ushort> ShiftLeft(Vector128<ushort> value, int count);
+        public static Vector128<uint> ShiftLeft(Vector128<uint> value, int count);
+        public static Vector128<ulong> ShiftLeft(Vector128<ulong> value, int count);
+        public static Vector128<UIntPtr> ShiftLeft(Vector128<UIntPtr> value, int count);
+        public static Vector128<byte> ShiftRightArithmetic(Vector128<byte> value, int count);
+        public static Vector128<short> ShiftRightArithmetic(Vector128<short> value, int count);
+        public static Vector128<int> ShiftRightArithmetic(Vector128<int> value, int count);
+        public static Vector128<long> ShiftRightArithmetic(Vector128<long> value, int count);
+        public static Vector128<IntPtr> ShiftRightArithmetic(Vector128<IntPtr> value, int count);
+        public static Vector128<sbyte> ShiftRightArithmetic(Vector128<sbyte> value, int count);
+        public static Vector128<ushort> ShiftRightArithmetic(Vector128<ushort> value, int count);
+        public static Vector128<uint> ShiftRightArithmetic(Vector128<uint> value, int count);
+        public static Vector128<ulong> ShiftRightArithmetic(Vector128<ulong> value, int count);
+        public static Vector128<UIntPtr> ShiftRightArithmetic(Vector128<UIntPtr> value, int count);
+        public static Vector128<byte> ShiftRightLogical(Vector128<byte> value, int count);
+        public static Vector128<short> ShiftRightLogical(Vector128<short> value, int count);
+        public static Vector128<int> ShiftRightLogical(Vector128<int> value, int count);
+        public static Vector128<long> ShiftRightLogical(Vector128<long> value, int count);
+        public static Vector128<IntPtr> ShiftRightLogical(Vector128<IntPtr> value, int count);
+        public static Vector128<sbyte> ShiftRightLogical(Vector128<sbyte> value, int count);
+        public static Vector128<ushort> ShiftRightLogical(Vector128<ushort> value, int count);
+        public static Vector128<uint> ShiftRightLogical(Vector128<uint> value, int count);
+        public static Vector128<ulong> ShiftRightLogical(Vector128<ulong> value, int count);
+        public static Vector128<UIntPtr> ShiftRightLogical(Vector128<UIntPtr> value, int count);
+        public static Vector128<byte> SubtractSaturate(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<short> SubtractSaturate(Vector128<short> left, Vector128<short> right);
+        public static Vector128<sbyte> SubtractSaturate(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<ushort> SubtractSaturate(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<byte> Xor(Vector128<byte> left, Vector128<byte> right);
+        public static Vector128<double> Xor(Vector128<double> left, Vector128<double> right);
+        public static Vector128<short> Xor(Vector128<short> left, Vector128<short> right);
+        public static Vector128<int> Xor(Vector128<int> left, Vector128<int> right);
+        public static Vector128<long> Xor(Vector128<long> left, Vector128<long> right);
+        public static Vector128<IntPtr> Xor(Vector128<IntPtr> left, Vector128<IntPtr> right);
+        public static Vector128<sbyte> Xor(Vector128<sbyte> left, Vector128<sbyte> right);
+        public static Vector128<float> Xor(Vector128<float> left, Vector128<float> right);
+        public static Vector128<ushort> Xor(Vector128<ushort> left, Vector128<ushort> right);
+        public static Vector128<uint> Xor(Vector128<uint> left, Vector128<uint> right);
+        public static Vector128<ulong> Xor(Vector128<ulong> left, Vector128<ulong> right);
+        public static Vector128<UIntPtr> Xor(Vector128<UIntPtr> left, Vector128<UIntPtr> right);
     }
 }
```

