# System.Runtime.Intrinsics.X86

``` diff
 namespace System.Runtime.Intrinsics.X86 {
     [CLSCompliantAttribute(false)]
     public abstract class Avx512BW : Avx512F {
+        public static Vector512<ushort> Abs(Vector512<short> value);
+        public static Vector512<byte> Abs(Vector512<sbyte> value);
+        public static Vector512<byte> Add(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<short> Add(Vector512<short> left, Vector512<short> right);
+        public static Vector512<sbyte> Add(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<ushort> Add(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<byte> AddSaturate(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<short> AddSaturate(Vector512<short> left, Vector512<short> right);
+        public static Vector512<sbyte> AddSaturate(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<ushort> AddSaturate(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<byte> AlignRight(Vector512<byte> left, Vector512<byte> right, [ConstantExpectedAttribute] byte mask);
+        public static Vector512<sbyte> AlignRight(Vector512<sbyte> left, Vector512<sbyte> right, [ConstantExpectedAttribute] byte mask);
+        public static Vector512<byte> Average(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<ushort> Average(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<byte> BroadcastScalarToVector512(Vector128<byte> value);
+        public static Vector512<short> BroadcastScalarToVector512(Vector128<short> value);
+        public static Vector512<sbyte> BroadcastScalarToVector512(Vector128<sbyte> value);
+        public static Vector512<ushort> BroadcastScalarToVector512(Vector128<ushort> value);
+        public static Vector256<byte> ConvertToVector256Byte(Vector512<short> value);
+        public static Vector256<byte> ConvertToVector256Byte(Vector512<ushort> value);
+        public static Vector256<byte> ConvertToVector256ByteWithSaturation(Vector512<ushort> value);
+        public static Vector256<sbyte> ConvertToVector256SByte(Vector512<short> value);
+        public static Vector256<sbyte> ConvertToVector256SByte(Vector512<ushort> value);
+        public static Vector256<sbyte> ConvertToVector256SByteWithSaturation(Vector512<short> value);
+        public static Vector512<short> ConvertToVector512Int16(Vector256<byte> value);
+        public static Vector512<short> ConvertToVector512Int16(Vector256<sbyte> value);
+        public static Vector512<ushort> ConvertToVector512UInt16(Vector256<byte> value);
+        public static Vector512<ushort> ConvertToVector512UInt16(Vector256<sbyte> value);
+        public unsafe static new Vector512<byte> LoadVector512(byte* address);
+        public unsafe static new Vector512<short> LoadVector512(short* address);
+        public unsafe static new Vector512<sbyte> LoadVector512(sbyte* address);
+        public unsafe static new Vector512<ushort> LoadVector512(ushort* address);
+        public static Vector512<byte> Max(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<short> Max(Vector512<short> left, Vector512<short> right);
+        public static Vector512<sbyte> Max(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<ushort> Max(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<byte> Min(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<short> Min(Vector512<short> left, Vector512<short> right);
+        public static Vector512<sbyte> Min(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<ushort> Min(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<short> MultiplyAddAdjacent(Vector512<byte> left, Vector512<sbyte> right);
+        public static Vector512<int> MultiplyAddAdjacent(Vector512<short> left, Vector512<short> right);
+        public static Vector512<short> MultiplyHigh(Vector512<short> left, Vector512<short> right);
+        public static Vector512<ushort> MultiplyHigh(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<short> MultiplyHighRoundScale(Vector512<short> left, Vector512<short> right);
+        public static Vector512<short> MultiplyLow(Vector512<short> left, Vector512<short> right);
+        public static Vector512<ushort> MultiplyLow(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<sbyte> PackSignedSaturate(Vector512<short> left, Vector512<short> right);
+        public static Vector512<short> PackSignedSaturate(Vector512<int> left, Vector512<int> right);
+        public static Vector512<byte> PackUnsignedSaturate(Vector512<short> left, Vector512<short> right);
+        public static Vector512<ushort> PackUnsignedSaturate(Vector512<int> left, Vector512<int> right);
+        public static Vector512<short> PermuteVar32x16(Vector512<short> left, Vector512<short> control);
+        public static Vector512<ushort> PermuteVar32x16(Vector512<ushort> left, Vector512<ushort> control);
+        public static Vector512<short> ShiftLeftLogical(Vector512<short> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<short> ShiftLeftLogical(Vector512<short> value, Vector128<short> count);
+        public static Vector512<ushort> ShiftLeftLogical(Vector512<ushort> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<ushort> ShiftLeftLogical(Vector512<ushort> value, Vector128<ushort> count);
+        public static Vector512<byte> ShiftLeftLogical128BitLane(Vector512<byte> value, [ConstantExpectedAttribute] byte numBytes);
+        public static Vector512<sbyte> ShiftLeftLogical128BitLane(Vector512<sbyte> value, [ConstantExpectedAttribute] byte numBytes);
+        public static Vector512<short> ShiftLeftLogicalVariable(Vector512<short> value, Vector512<ushort> count);
+        public static Vector512<ushort> ShiftLeftLogicalVariable(Vector512<ushort> value, Vector512<ushort> count);
+        public static Vector512<short> ShiftRightArithmetic(Vector512<short> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<short> ShiftRightArithmetic(Vector512<short> value, Vector128<short> count);
+        public static Vector512<short> ShiftRightArithmeticVariable(Vector512<short> value, Vector512<ushort> count);
+        public static Vector512<short> ShiftRightLogical(Vector512<short> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<short> ShiftRightLogical(Vector512<short> value, Vector128<short> count);
+        public static Vector512<ushort> ShiftRightLogical(Vector512<ushort> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<ushort> ShiftRightLogical(Vector512<ushort> value, Vector128<ushort> count);
+        public static Vector512<byte> ShiftRightLogical128BitLane(Vector512<byte> value, [ConstantExpectedAttribute] byte numBytes);
+        public static Vector512<sbyte> ShiftRightLogical128BitLane(Vector512<sbyte> value, [ConstantExpectedAttribute] byte numBytes);
+        public static Vector512<short> ShiftRightLogicalVariable(Vector512<short> value, Vector512<ushort> count);
+        public static Vector512<ushort> ShiftRightLogicalVariable(Vector512<ushort> value, Vector512<ushort> count);
+        public static Vector512<byte> Shuffle(Vector512<byte> value, Vector512<byte> mask);
+        public static Vector512<sbyte> Shuffle(Vector512<sbyte> value, Vector512<sbyte> mask);
+        public static Vector512<short> ShuffleHigh(Vector512<short> value, [ConstantExpectedAttribute] byte control);
+        public static Vector512<ushort> ShuffleHigh(Vector512<ushort> value, [ConstantExpectedAttribute] byte control);
+        public static Vector512<short> ShuffleLow(Vector512<short> value, [ConstantExpectedAttribute] byte control);
+        public static Vector512<ushort> ShuffleLow(Vector512<ushort> value, [ConstantExpectedAttribute] byte control);
+        public unsafe static new void Store(byte* address, Vector512<byte> source);
+        public unsafe static new void Store(short* address, Vector512<short> source);
+        public unsafe static new void Store(sbyte* address, Vector512<sbyte> source);
+        public unsafe static new void Store(ushort* address, Vector512<ushort> source);
+        public static Vector512<byte> Subtract(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<short> Subtract(Vector512<short> left, Vector512<short> right);
+        public static Vector512<sbyte> Subtract(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<ushort> Subtract(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<byte> SubtractSaturate(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<short> SubtractSaturate(Vector512<short> left, Vector512<short> right);
+        public static Vector512<sbyte> SubtractSaturate(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<ushort> SubtractSaturate(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<ushort> SumAbsoluteDifferences(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<byte> UnpackHigh(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<short> UnpackHigh(Vector512<short> left, Vector512<short> right);
+        public static Vector512<sbyte> UnpackHigh(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<ushort> UnpackHigh(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<byte> UnpackLow(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<short> UnpackLow(Vector512<short> left, Vector512<short> right);
+        public static Vector512<sbyte> UnpackLow(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<ushort> UnpackLow(Vector512<ushort> left, Vector512<ushort> right);
         public new abstract class VL : Avx512F.VL {
+            public static Vector128<byte> ConvertToVector128Byte(Vector128<short> value);
+            public static Vector128<byte> ConvertToVector128Byte(Vector128<ushort> value);
+            public static Vector128<byte> ConvertToVector128Byte(Vector256<short> value);
+            public static Vector128<byte> ConvertToVector128Byte(Vector256<ushort> value);
+            public static Vector128<byte> ConvertToVector128ByteWithSaturation(Vector128<ushort> value);
+            public static Vector128<byte> ConvertToVector128ByteWithSaturation(Vector256<ushort> value);
+            public static Vector128<sbyte> ConvertToVector128SByte(Vector128<short> value);
+            public static Vector128<sbyte> ConvertToVector128SByte(Vector128<ushort> value);
+            public static Vector128<sbyte> ConvertToVector128SByte(Vector256<short> value);
+            public static Vector128<sbyte> ConvertToVector128SByte(Vector256<ushort> value);
+            public static Vector128<sbyte> ConvertToVector128SByteWithSaturation(Vector128<short> value);
+            public static Vector128<sbyte> ConvertToVector128SByteWithSaturation(Vector256<short> value);
+            public static Vector256<short> PermuteVar16x16(Vector256<short> left, Vector256<short> control);
+            public static Vector256<ushort> PermuteVar16x16(Vector256<ushort> left, Vector256<ushort> control);
+            public static Vector128<short> PermuteVar8x16(Vector128<short> left, Vector128<short> control);
+            public static Vector128<ushort> PermuteVar8x16(Vector128<ushort> left, Vector128<ushort> control);
+            public static Vector128<short> ShiftLeftLogicalVariable(Vector128<short> value, Vector128<ushort> count);
+            public static Vector128<ushort> ShiftLeftLogicalVariable(Vector128<ushort> value, Vector128<ushort> count);
+            public static Vector256<short> ShiftLeftLogicalVariable(Vector256<short> value, Vector256<ushort> count);
+            public static Vector256<ushort> ShiftLeftLogicalVariable(Vector256<ushort> value, Vector256<ushort> count);
+            public static Vector128<short> ShiftRightArithmeticVariable(Vector128<short> value, Vector128<ushort> count);
+            public static Vector256<short> ShiftRightArithmeticVariable(Vector256<short> value, Vector256<ushort> count);
+            public static Vector128<short> ShiftRightLogicalVariable(Vector128<short> value, Vector128<ushort> count);
+            public static Vector128<ushort> ShiftRightLogicalVariable(Vector128<ushort> value, Vector128<ushort> count);
+            public static Vector256<short> ShiftRightLogicalVariable(Vector256<short> value, Vector256<ushort> count);
+            public static Vector256<ushort> ShiftRightLogicalVariable(Vector256<ushort> value, Vector256<ushort> count);
         }
     }
     [CLSCompliantAttribute(false)]
     public abstract class Avx512DQ : Avx512F {
+        public static Vector512<double> And(Vector512<double> left, Vector512<double> right);
+        public static Vector512<float> And(Vector512<float> left, Vector512<float> right);
+        public static Vector512<double> AndNot(Vector512<double> left, Vector512<double> right);
+        public static Vector512<float> AndNot(Vector512<float> left, Vector512<float> right);
+        public static Vector512<int> BroadcastPairScalarToVector512(Vector128<int> value);
+        public static Vector512<float> BroadcastPairScalarToVector512(Vector128<float> value);
+        public static Vector512<uint> BroadcastPairScalarToVector512(Vector128<uint> value);
+        public unsafe static Vector512<double> BroadcastVector128ToVector512(double* address);
+        public unsafe static Vector512<long> BroadcastVector128ToVector512(long* address);
+        public unsafe static Vector512<ulong> BroadcastVector128ToVector512(ulong* address);
+        public unsafe static Vector512<int> BroadcastVector256ToVector512(int* address);
+        public unsafe static Vector512<float> BroadcastVector256ToVector512(float* address);
+        public unsafe static Vector512<uint> BroadcastVector256ToVector512(uint* address);
+        public static Vector256<float> ConvertToVector256Single(Vector512<long> value);
+        public static Vector256<float> ConvertToVector256Single(Vector512<ulong> value);
+        public static Vector512<double> ConvertToVector512Double(Vector512<long> value);
+        public static Vector512<double> ConvertToVector512Double(Vector512<ulong> value);
+        public static Vector512<long> ConvertToVector512Int64(Vector256<float> value);
+        public static Vector512<long> ConvertToVector512Int64(Vector512<double> value);
+        public static Vector512<long> ConvertToVector512Int64WithTruncation(Vector256<float> value);
+        public static Vector512<long> ConvertToVector512Int64WithTruncation(Vector512<double> value);
+        public static Vector512<ulong> ConvertToVector512UInt64(Vector256<float> value);
+        public static Vector512<ulong> ConvertToVector512UInt64(Vector512<double> value);
+        public static Vector512<ulong> ConvertToVector512UInt64WithTruncation(Vector256<float> value);
+        public static Vector512<ulong> ConvertToVector512UInt64WithTruncation(Vector512<double> value);
+        public static new Vector128<double> ExtractVector128(Vector512<double> value, [ConstantExpectedAttribute] byte index);
+        public static new Vector128<long> ExtractVector128(Vector512<long> value, [ConstantExpectedAttribute] byte index);
+        public static new Vector128<ulong> ExtractVector128(Vector512<ulong> value, [ConstantExpectedAttribute] byte index);
+        public static new Vector256<int> ExtractVector256(Vector512<int> value, [ConstantExpectedAttribute] byte index);
+        public static new Vector256<float> ExtractVector256(Vector512<float> value, [ConstantExpectedAttribute] byte index);
+        public static new Vector256<uint> ExtractVector256(Vector512<uint> value, [ConstantExpectedAttribute] byte index);
+        public static new Vector512<double> InsertVector128(Vector512<double> value, Vector128<double> data, [ConstantExpectedAttribute] byte index);
+        public static new Vector512<long> InsertVector128(Vector512<long> value, Vector128<long> data, [ConstantExpectedAttribute] byte index);
+        public static new Vector512<ulong> InsertVector128(Vector512<ulong> value, Vector128<ulong> data, [ConstantExpectedAttribute] byte index);
+        public static new Vector512<int> InsertVector256(Vector512<int> value, Vector256<int> data, [ConstantExpectedAttribute] byte index);
+        public static new Vector512<float> InsertVector256(Vector512<float> value, Vector256<float> data, [ConstantExpectedAttribute] byte index);
+        public static new Vector512<uint> InsertVector256(Vector512<uint> value, Vector256<uint> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<long> MultiplyLow(Vector512<long> left, Vector512<long> right);
+        public static Vector512<ulong> MultiplyLow(Vector512<ulong> left, Vector512<ulong> right);
+        public static Vector512<double> Or(Vector512<double> left, Vector512<double> right);
+        public static Vector512<float> Or(Vector512<float> left, Vector512<float> right);
+        public static Vector512<double> Xor(Vector512<double> left, Vector512<double> right);
+        public static Vector512<float> Xor(Vector512<float> left, Vector512<float> right);
         public new abstract class VL : Avx512F.VL {
+            public static Vector128<int> BroadcastPairScalarToVector128(Vector128<int> value);
+            public static Vector128<uint> BroadcastPairScalarToVector128(Vector128<uint> value);
+            public static Vector256<int> BroadcastPairScalarToVector256(Vector128<int> value);
+            public static Vector256<float> BroadcastPairScalarToVector256(Vector128<float> value);
+            public static Vector256<uint> BroadcastPairScalarToVector256(Vector128<uint> value);
+            public static Vector128<double> ConvertToVector128Double(Vector128<long> value);
+            public static Vector128<double> ConvertToVector128Double(Vector128<ulong> value);
+            public static Vector128<long> ConvertToVector128Int64(Vector128<double> value);
+            public static Vector128<long> ConvertToVector128Int64(Vector128<float> value);
+            public static Vector128<long> ConvertToVector128Int64WithTruncation(Vector128<double> value);
+            public static Vector128<long> ConvertToVector128Int64WithTruncation(Vector128<float> value);
+            public static Vector128<float> ConvertToVector128Single(Vector128<long> value);
+            public static Vector128<float> ConvertToVector128Single(Vector128<ulong> value);
+            public static Vector128<float> ConvertToVector128Single(Vector256<long> value);
+            public static Vector128<float> ConvertToVector128Single(Vector256<ulong> value);
+            public static Vector128<ulong> ConvertToVector128UInt64(Vector128<double> value);
+            public static Vector128<ulong> ConvertToVector128UInt64(Vector128<float> value);
+            public static Vector128<ulong> ConvertToVector128UInt64WithTruncation(Vector128<double> value);
+            public static Vector128<ulong> ConvertToVector128UInt64WithTruncation(Vector128<float> value);
+            public static Vector256<double> ConvertToVector256Double(Vector256<long> value);
+            public static Vector256<double> ConvertToVector256Double(Vector256<ulong> value);
+            public static Vector256<long> ConvertToVector256Int64(Vector128<float> value);
+            public static Vector256<long> ConvertToVector256Int64(Vector256<double> value);
+            public static Vector256<long> ConvertToVector256Int64WithTruncation(Vector128<float> value);
+            public static Vector256<long> ConvertToVector256Int64WithTruncation(Vector256<double> value);
+            public static Vector256<ulong> ConvertToVector256UInt64(Vector128<float> value);
+            public static Vector256<ulong> ConvertToVector256UInt64(Vector256<double> value);
+            public static Vector256<ulong> ConvertToVector256UInt64WithTruncation(Vector128<float> value);
+            public static Vector256<ulong> ConvertToVector256UInt64WithTruncation(Vector256<double> value);
+            public static Vector128<long> MultiplyLow(Vector128<long> left, Vector128<long> right);
+            public static Vector128<ulong> MultiplyLow(Vector128<ulong> left, Vector128<ulong> right);
+            public static Vector256<long> MultiplyLow(Vector256<long> left, Vector256<long> right);
+            public static Vector256<ulong> MultiplyLow(Vector256<ulong> left, Vector256<ulong> right);
         }
     }
     [CLSCompliantAttribute(false)]
     public abstract class Avx512F : Avx2 {
+        public static Vector512<uint> Abs(Vector512<int> value);
+        public static Vector512<ulong> Abs(Vector512<long> value);
+        public static Vector512<double> Add(Vector512<double> left, Vector512<double> right);
+        public static Vector512<int> Add(Vector512<int> left, Vector512<int> right);
+        public static Vector512<long> Add(Vector512<long> left, Vector512<long> right);
+        public static Vector512<float> Add(Vector512<float> left, Vector512<float> right);
+        public static Vector512<uint> Add(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<ulong> Add(Vector512<ulong> left, Vector512<ulong> right);
-        public static Vector512<double> And(Vector512<double> left, Vector512<double> right);
-        public static Vector512<float> And(Vector512<float> left, Vector512<float> right);
-        public static Vector512<double> AndNot(Vector512<double> left, Vector512<double> right);
-        public static Vector512<float> AndNot(Vector512<float> left, Vector512<float> right);
+        public static Vector512<double> BroadcastScalarToVector512(Vector128<double> value);
+        public static Vector512<int> BroadcastScalarToVector512(Vector128<int> value);
+        public static Vector512<long> BroadcastScalarToVector512(Vector128<long> value);
+        public static Vector512<float> BroadcastScalarToVector512(Vector128<float> value);
+        public static Vector512<uint> BroadcastScalarToVector512(Vector128<uint> value);
+        public static Vector512<ulong> BroadcastScalarToVector512(Vector128<ulong> value);
+        public unsafe static Vector512<int> BroadcastVector128ToVector512(int* address);
+        public unsafe static Vector512<float> BroadcastVector128ToVector512(float* address);
+        public unsafe static Vector512<uint> BroadcastVector128ToVector512(uint* address);
+        public unsafe static Vector512<double> BroadcastVector256ToVector512(double* address);
+        public unsafe static Vector512<long> BroadcastVector256ToVector512(long* address);
+        public unsafe static Vector512<ulong> BroadcastVector256ToVector512(ulong* address);
+        public static Vector128<double> ConvertScalarToVector128Double(Vector128<double> upper, uint value);
+        public static Vector128<float> ConvertScalarToVector128Single(Vector128<float> upper, uint value);
+        public static uint ConvertToUInt32(Vector128<double> value);
+        public static uint ConvertToUInt32(Vector128<float> value);
+        public static uint ConvertToUInt32WithTruncation(Vector128<double> value);
+        public static uint ConvertToUInt32WithTruncation(Vector128<float> value);
+        public static Vector128<byte> ConvertToVector128Byte(Vector512<int> value);
+        public static Vector128<byte> ConvertToVector128Byte(Vector512<long> value);
+        public static Vector128<byte> ConvertToVector128Byte(Vector512<uint> value);
+        public static Vector128<byte> ConvertToVector128Byte(Vector512<ulong> value);
+        public static Vector128<byte> ConvertToVector128ByteWithSaturation(Vector512<uint> value);
+        public static Vector128<byte> ConvertToVector128ByteWithSaturation(Vector512<ulong> value);
+        public static Vector128<short> ConvertToVector128Int16(Vector512<long> value);
+        public static Vector128<short> ConvertToVector128Int16(Vector512<ulong> value);
+        public static Vector128<short> ConvertToVector128Int16WithSaturation(Vector512<long> value);
+        public static Vector128<sbyte> ConvertToVector128SByte(Vector512<int> value);
+        public static Vector128<sbyte> ConvertToVector128SByte(Vector512<long> value);
+        public static Vector128<sbyte> ConvertToVector128SByte(Vector512<uint> value);
+        public static Vector128<sbyte> ConvertToVector128SByte(Vector512<ulong> value);
+        public static Vector128<sbyte> ConvertToVector128SByteWithSaturation(Vector512<int> value);
+        public static Vector128<sbyte> ConvertToVector128SByteWithSaturation(Vector512<long> value);
+        public static Vector128<ushort> ConvertToVector128UInt16(Vector512<long> value);
+        public static Vector128<ushort> ConvertToVector128UInt16(Vector512<ulong> value);
+        public static Vector128<ushort> ConvertToVector128UInt16WithSaturation(Vector512<ulong> value);
+        public static Vector256<short> ConvertToVector256Int16(Vector512<int> value);
+        public static Vector256<short> ConvertToVector256Int16(Vector512<uint> value);
+        public static Vector256<short> ConvertToVector256Int16WithSaturation(Vector512<int> value);
+        public static Vector256<int> ConvertToVector256Int32(Vector512<double> value);
+        public static Vector256<int> ConvertToVector256Int32(Vector512<long> value);
+        public static Vector256<int> ConvertToVector256Int32(Vector512<ulong> value);
+        public static Vector256<int> ConvertToVector256Int32WithSaturation(Vector512<long> value);
+        public static Vector256<int> ConvertToVector256Int32WithTruncation(Vector512<double> value);
+        public static Vector256<float> ConvertToVector256Single(Vector512<double> value);
+        public static Vector256<ushort> ConvertToVector256UInt16(Vector512<int> value);
+        public static Vector256<ushort> ConvertToVector256UInt16(Vector512<uint> value);
+        public static Vector256<ushort> ConvertToVector256UInt16WithSaturation(Vector512<uint> value);
+        public static Vector256<uint> ConvertToVector256UInt32(Vector512<double> value);
+        public static Vector256<uint> ConvertToVector256UInt32(Vector512<long> value);
+        public static Vector256<uint> ConvertToVector256UInt32(Vector512<ulong> value);
+        public static Vector256<uint> ConvertToVector256UInt32WithSaturation(Vector512<ulong> value);
+        public static Vector256<uint> ConvertToVector256UInt32WithTruncation(Vector512<double> value);
+        public static Vector512<double> ConvertToVector512Double(Vector256<int> value);
+        public static Vector512<double> ConvertToVector512Double(Vector256<float> value);
+        public static Vector512<double> ConvertToVector512Double(Vector256<uint> value);
+        public static Vector512<int> ConvertToVector512Int32(Vector128<byte> value);
+        public static Vector512<int> ConvertToVector512Int32(Vector128<sbyte> value);
+        public static Vector512<int> ConvertToVector512Int32(Vector256<short> value);
+        public static Vector512<int> ConvertToVector512Int32(Vector256<ushort> value);
+        public static Vector512<int> ConvertToVector512Int32(Vector512<float> value);
+        public static Vector512<int> ConvertToVector512Int32WithTruncation(Vector512<float> value);
+        public static Vector512<long> ConvertToVector512Int64(Vector128<byte> value);
+        public static Vector512<long> ConvertToVector512Int64(Vector128<short> value);
+        public static Vector512<long> ConvertToVector512Int64(Vector128<sbyte> value);
+        public static Vector512<long> ConvertToVector512Int64(Vector128<ushort> value);
+        public static Vector512<long> ConvertToVector512Int64(Vector256<int> value);
+        public static Vector512<long> ConvertToVector512Int64(Vector256<uint> value);
+        public static Vector512<float> ConvertToVector512Single(Vector512<int> value);
+        public static Vector512<float> ConvertToVector512Single(Vector512<uint> value);
+        public static Vector512<uint> ConvertToVector512UInt32(Vector128<byte> value);
+        public static Vector512<uint> ConvertToVector512UInt32(Vector128<sbyte> value);
+        public static Vector512<uint> ConvertToVector512UInt32(Vector256<short> value);
+        public static Vector512<uint> ConvertToVector512UInt32(Vector256<ushort> value);
+        public static Vector512<uint> ConvertToVector512UInt32(Vector512<float> value);
+        public static Vector512<uint> ConvertToVector512UInt32WithTruncation(Vector512<float> value);
+        public static Vector512<ulong> ConvertToVector512UInt64(Vector128<byte> value);
+        public static Vector512<ulong> ConvertToVector512UInt64(Vector128<short> value);
+        public static Vector512<ulong> ConvertToVector512UInt64(Vector128<sbyte> value);
+        public static Vector512<ulong> ConvertToVector512UInt64(Vector128<ushort> value);
+        public static Vector512<ulong> ConvertToVector512UInt64(Vector256<int> value);
+        public static Vector512<ulong> ConvertToVector512UInt64(Vector256<uint> value);
+        public static Vector512<double> Divide(Vector512<double> left, Vector512<double> right);
+        public static Vector512<float> Divide(Vector512<float> left, Vector512<float> right);
+        public static Vector512<double> DuplicateEvenIndexed(Vector512<double> value);
+        public static Vector512<float> DuplicateEvenIndexed(Vector512<float> value);
+        public static Vector512<float> DuplicateOddIndexed(Vector512<float> value);
+        public static Vector128<byte> ExtractVector128(Vector512<byte> value, [ConstantExpectedAttribute] byte index);
+        public static Vector128<double> ExtractVector128(Vector512<double> value, [ConstantExpectedAttribute] byte index);
+        public static Vector128<short> ExtractVector128(Vector512<short> value, [ConstantExpectedAttribute] byte index);
+        public static Vector128<int> ExtractVector128(Vector512<int> value, [ConstantExpectedAttribute] byte index);
+        public static Vector128<long> ExtractVector128(Vector512<long> value, [ConstantExpectedAttribute] byte index);
+        public static Vector128<sbyte> ExtractVector128(Vector512<sbyte> value, [ConstantExpectedAttribute] byte index);
+        public static Vector128<float> ExtractVector128(Vector512<float> value, [ConstantExpectedAttribute] byte index);
+        public static Vector128<ushort> ExtractVector128(Vector512<ushort> value, [ConstantExpectedAttribute] byte index);
+        public static Vector128<uint> ExtractVector128(Vector512<uint> value, [ConstantExpectedAttribute] byte index);
+        public static Vector128<ulong> ExtractVector128(Vector512<ulong> value, [ConstantExpectedAttribute] byte index);
+        public static Vector256<byte> ExtractVector256(Vector512<byte> value, [ConstantExpectedAttribute] byte index);
+        public static Vector256<double> ExtractVector256(Vector512<double> value, [ConstantExpectedAttribute] byte index);
+        public static Vector256<short> ExtractVector256(Vector512<short> value, [ConstantExpectedAttribute] byte index);
+        public static Vector256<int> ExtractVector256(Vector512<int> value, [ConstantExpectedAttribute] byte index);
+        public static Vector256<long> ExtractVector256(Vector512<long> value, [ConstantExpectedAttribute] byte index);
+        public static Vector256<sbyte> ExtractVector256(Vector512<sbyte> value, [ConstantExpectedAttribute] byte index);
+        public static Vector256<float> ExtractVector256(Vector512<float> value, [ConstantExpectedAttribute] byte index);
+        public static Vector256<ushort> ExtractVector256(Vector512<ushort> value, [ConstantExpectedAttribute] byte index);
+        public static Vector256<uint> ExtractVector256(Vector512<uint> value, [ConstantExpectedAttribute] byte index);
+        public static Vector256<ulong> ExtractVector256(Vector512<ulong> value, [ConstantExpectedAttribute] byte index);
+        public static Vector512<double> FusedMultiplyAdd(Vector512<double> a, Vector512<double> b, Vector512<double> c);
+        public static Vector512<float> FusedMultiplyAdd(Vector512<float> a, Vector512<float> b, Vector512<float> c);
+        public static Vector512<double> FusedMultiplyAddNegated(Vector512<double> a, Vector512<double> b, Vector512<double> c);
+        public static Vector512<float> FusedMultiplyAddNegated(Vector512<float> a, Vector512<float> b, Vector512<float> c);
+        public static Vector512<double> FusedMultiplyAddSubtract(Vector512<double> a, Vector512<double> b, Vector512<double> c);
+        public static Vector512<float> FusedMultiplyAddSubtract(Vector512<float> a, Vector512<float> b, Vector512<float> c);
+        public static Vector512<double> FusedMultiplySubtract(Vector512<double> a, Vector512<double> b, Vector512<double> c);
+        public static Vector512<float> FusedMultiplySubtract(Vector512<float> a, Vector512<float> b, Vector512<float> c);
+        public static Vector512<double> FusedMultiplySubtractAdd(Vector512<double> a, Vector512<double> b, Vector512<double> c);
+        public static Vector512<float> FusedMultiplySubtractAdd(Vector512<float> a, Vector512<float> b, Vector512<float> c);
+        public static Vector512<double> FusedMultiplySubtractNegated(Vector512<double> a, Vector512<double> b, Vector512<double> c);
+        public static Vector512<float> FusedMultiplySubtractNegated(Vector512<float> a, Vector512<float> b, Vector512<float> c);
+        public static Vector512<byte> InsertVector128(Vector512<byte> value, Vector128<byte> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<double> InsertVector128(Vector512<double> value, Vector128<double> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<short> InsertVector128(Vector512<short> value, Vector128<short> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<int> InsertVector128(Vector512<int> value, Vector128<int> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<long> InsertVector128(Vector512<long> value, Vector128<long> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<sbyte> InsertVector128(Vector512<sbyte> value, Vector128<sbyte> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<float> InsertVector128(Vector512<float> value, Vector128<float> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<ushort> InsertVector128(Vector512<ushort> value, Vector128<ushort> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<uint> InsertVector128(Vector512<uint> value, Vector128<uint> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<ulong> InsertVector128(Vector512<ulong> value, Vector128<ulong> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<byte> InsertVector256(Vector512<byte> value, Vector256<byte> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<double> InsertVector256(Vector512<double> value, Vector256<double> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<short> InsertVector256(Vector512<short> value, Vector256<short> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<int> InsertVector256(Vector512<int> value, Vector256<int> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<long> InsertVector256(Vector512<long> value, Vector256<long> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<sbyte> InsertVector256(Vector512<sbyte> value, Vector256<sbyte> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<float> InsertVector256(Vector512<float> value, Vector256<float> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<ushort> InsertVector256(Vector512<ushort> value, Vector256<ushort> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<uint> InsertVector256(Vector512<uint> value, Vector256<uint> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<ulong> InsertVector256(Vector512<ulong> value, Vector256<ulong> data, [ConstantExpectedAttribute] byte index);
+        public unsafe static Vector512<byte> LoadAlignedVector512NonTemporal(byte* address);
+        public unsafe static Vector512<short> LoadAlignedVector512NonTemporal(short* address);
+        public unsafe static Vector512<int> LoadAlignedVector512NonTemporal(int* address);
+        public unsafe static Vector512<long> LoadAlignedVector512NonTemporal(long* address);
+        public unsafe static Vector512<sbyte> LoadAlignedVector512NonTemporal(sbyte* address);
+        public unsafe static Vector512<ushort> LoadAlignedVector512NonTemporal(ushort* address);
+        public unsafe static Vector512<uint> LoadAlignedVector512NonTemporal(uint* address);
+        public unsafe static Vector512<ulong> LoadAlignedVector512NonTemporal(ulong* address);
+        public static Vector512<double> Max(Vector512<double> left, Vector512<double> right);
+        public static Vector512<int> Max(Vector512<int> left, Vector512<int> right);
+        public static Vector512<long> Max(Vector512<long> left, Vector512<long> right);
+        public static Vector512<float> Max(Vector512<float> left, Vector512<float> right);
+        public static Vector512<uint> Max(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<ulong> Max(Vector512<ulong> left, Vector512<ulong> right);
+        public static Vector512<double> Min(Vector512<double> left, Vector512<double> right);
+        public static Vector512<int> Min(Vector512<int> left, Vector512<int> right);
+        public static Vector512<long> Min(Vector512<long> left, Vector512<long> right);
+        public static Vector512<float> Min(Vector512<float> left, Vector512<float> right);
+        public static Vector512<uint> Min(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<ulong> Min(Vector512<ulong> left, Vector512<ulong> right);
+        public static Vector512<double> Multiply(Vector512<double> left, Vector512<double> right);
+        public static Vector512<long> Multiply(Vector512<int> left, Vector512<int> right);
+        public static Vector512<float> Multiply(Vector512<float> left, Vector512<float> right);
+        public static Vector512<ulong> Multiply(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<int> MultiplyLow(Vector512<int> left, Vector512<int> right);
+        public static Vector512<uint> MultiplyLow(Vector512<uint> left, Vector512<uint> right);
-        public static Vector512<double> Or(Vector512<double> left, Vector512<double> right);
-        public static Vector512<float> Or(Vector512<float> left, Vector512<float> right);
+        public static Vector512<double> Permute2x64(Vector512<double> value, [ConstantExpectedAttribute] byte control);
+        public static Vector512<float> Permute4x32(Vector512<float> value, [ConstantExpectedAttribute] byte control);
+        public static Vector512<double> Permute4x64(Vector512<double> value, [ConstantExpectedAttribute] byte control);
+        public static Vector512<long> Permute4x64(Vector512<long> value, [ConstantExpectedAttribute] byte control);
+        public static Vector512<ulong> Permute4x64(Vector512<ulong> value, [ConstantExpectedAttribute] byte control);
+        public static Vector512<int> PermuteVar16x32(Vector512<int> left, Vector512<int> control);
+        public static Vector512<float> PermuteVar16x32(Vector512<float> left, Vector512<int> control);
+        public static Vector512<uint> PermuteVar16x32(Vector512<uint> left, Vector512<uint> control);
+        public static Vector512<double> PermuteVar2x64(Vector512<double> left, Vector512<long> control);
+        public static Vector512<float> PermuteVar4x32(Vector512<float> left, Vector512<int> control);
+        public static Vector512<double> PermuteVar8x64(Vector512<double> value, Vector512<long> control);
+        public static Vector512<long> PermuteVar8x64(Vector512<long> value, Vector512<long> control);
+        public static Vector512<ulong> PermuteVar8x64(Vector512<ulong> value, Vector512<ulong> control);
+        public static Vector512<int> ShiftLeftLogical(Vector512<int> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<int> ShiftLeftLogical(Vector512<int> value, Vector128<int> count);
+        public static Vector512<long> ShiftLeftLogical(Vector512<long> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<long> ShiftLeftLogical(Vector512<long> value, Vector128<long> count);
+        public static Vector512<uint> ShiftLeftLogical(Vector512<uint> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<uint> ShiftLeftLogical(Vector512<uint> value, Vector128<uint> count);
+        public static Vector512<ulong> ShiftLeftLogical(Vector512<ulong> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<ulong> ShiftLeftLogical(Vector512<ulong> value, Vector128<ulong> count);
+        public static Vector512<int> ShiftLeftLogicalVariable(Vector512<int> value, Vector512<uint> count);
+        public static Vector512<long> ShiftLeftLogicalVariable(Vector512<long> value, Vector512<ulong> count);
+        public static Vector512<uint> ShiftLeftLogicalVariable(Vector512<uint> value, Vector512<uint> count);
+        public static Vector512<ulong> ShiftLeftLogicalVariable(Vector512<ulong> value, Vector512<ulong> count);
+        public static Vector512<int> ShiftRightArithmetic(Vector512<int> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<int> ShiftRightArithmetic(Vector512<int> value, Vector128<int> count);
+        public static Vector512<long> ShiftRightArithmetic(Vector512<long> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<long> ShiftRightArithmetic(Vector512<long> value, Vector128<long> count);
+        public static Vector512<int> ShiftRightArithmeticVariable(Vector512<int> value, Vector512<uint> count);
+        public static Vector512<long> ShiftRightArithmeticVariable(Vector512<long> value, Vector512<ulong> count);
+        public static Vector512<int> ShiftRightLogical(Vector512<int> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<int> ShiftRightLogical(Vector512<int> value, Vector128<int> count);
+        public static Vector512<long> ShiftRightLogical(Vector512<long> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<long> ShiftRightLogical(Vector512<long> value, Vector128<long> count);
+        public static Vector512<uint> ShiftRightLogical(Vector512<uint> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<uint> ShiftRightLogical(Vector512<uint> value, Vector128<uint> count);
+        public static Vector512<ulong> ShiftRightLogical(Vector512<ulong> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<ulong> ShiftRightLogical(Vector512<ulong> value, Vector128<ulong> count);
+        public static Vector512<int> ShiftRightLogicalVariable(Vector512<int> value, Vector512<uint> count);
+        public static Vector512<long> ShiftRightLogicalVariable(Vector512<long> value, Vector512<ulong> count);
+        public static Vector512<uint> ShiftRightLogicalVariable(Vector512<uint> value, Vector512<uint> count);
+        public static Vector512<ulong> ShiftRightLogicalVariable(Vector512<ulong> value, Vector512<ulong> count);
+        public static Vector512<double> Shuffle(Vector512<double> value, Vector512<double> right, [ConstantExpectedAttribute] byte control);
+        public static Vector512<int> Shuffle(Vector512<int> value, [ConstantExpectedAttribute] byte control);
+        public static Vector512<float> Shuffle(Vector512<float> value, Vector512<float> right, [ConstantExpectedAttribute] byte control);
+        public static Vector512<uint> Shuffle(Vector512<uint> value, [ConstantExpectedAttribute] byte control);
+        public static Vector512<double> Sqrt(Vector512<double> value);
+        public static Vector512<float> Sqrt(Vector512<float> value);
+        public static Vector512<double> Subtract(Vector512<double> left, Vector512<double> right);
+        public static Vector512<int> Subtract(Vector512<int> left, Vector512<int> right);
+        public static Vector512<long> Subtract(Vector512<long> left, Vector512<long> right);
+        public static Vector512<float> Subtract(Vector512<float> left, Vector512<float> right);
+        public static Vector512<uint> Subtract(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<ulong> Subtract(Vector512<ulong> left, Vector512<ulong> right);
+        public static Vector512<double> UnpackHigh(Vector512<double> left, Vector512<double> right);
+        public static Vector512<int> UnpackHigh(Vector512<int> left, Vector512<int> right);
+        public static Vector512<long> UnpackHigh(Vector512<long> left, Vector512<long> right);
+        public static Vector512<float> UnpackHigh(Vector512<float> left, Vector512<float> right);
+        public static Vector512<uint> UnpackHigh(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<ulong> UnpackHigh(Vector512<ulong> left, Vector512<ulong> right);
+        public static Vector512<double> UnpackLow(Vector512<double> left, Vector512<double> right);
+        public static Vector512<int> UnpackLow(Vector512<int> left, Vector512<int> right);
+        public static Vector512<long> UnpackLow(Vector512<long> left, Vector512<long> right);
+        public static Vector512<float> UnpackLow(Vector512<float> left, Vector512<float> right);
+        public static Vector512<uint> UnpackLow(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<ulong> UnpackLow(Vector512<ulong> left, Vector512<ulong> right);
-        public static Vector512<double> Xor(Vector512<double> left, Vector512<double> right);
-        public static Vector512<float> Xor(Vector512<float> left, Vector512<float> right);
         public abstract class VL {
+            public static Vector128<ulong> Abs(Vector128<long> value);
+            public static Vector256<ulong> Abs(Vector256<long> value);
+            public static Vector128<byte> ConvertToVector128Byte(Vector128<int> value);
+            public static Vector128<byte> ConvertToVector128Byte(Vector128<long> value);
+            public static Vector128<byte> ConvertToVector128Byte(Vector128<uint> value);
+            public static Vector128<byte> ConvertToVector128Byte(Vector128<ulong> value);
+            public static Vector128<byte> ConvertToVector128Byte(Vector256<int> value);
+            public static Vector128<byte> ConvertToVector128Byte(Vector256<long> value);
+            public static Vector128<byte> ConvertToVector128Byte(Vector256<uint> value);
+            public static Vector128<byte> ConvertToVector128Byte(Vector256<ulong> value);
+            public static Vector128<byte> ConvertToVector128ByteWithSaturation(Vector128<uint> value);
+            public static Vector128<byte> ConvertToVector128ByteWithSaturation(Vector128<ulong> value);
+            public static Vector128<byte> ConvertToVector128ByteWithSaturation(Vector256<uint> value);
+            public static Vector128<byte> ConvertToVector128ByteWithSaturation(Vector256<ulong> value);
+            public static Vector128<double> ConvertToVector128Double(Vector128<uint> value);
+            public static Vector128<short> ConvertToVector128Int16(Vector128<int> value);
+            public static Vector128<short> ConvertToVector128Int16(Vector128<long> value);
+            public static Vector128<short> ConvertToVector128Int16(Vector128<uint> value);
+            public static Vector128<short> ConvertToVector128Int16(Vector128<ulong> value);
+            public static Vector128<short> ConvertToVector128Int16(Vector256<int> value);
+            public static Vector128<short> ConvertToVector128Int16(Vector256<long> value);
+            public static Vector128<short> ConvertToVector128Int16(Vector256<uint> value);
+            public static Vector128<short> ConvertToVector128Int16(Vector256<ulong> value);
+            public static Vector128<short> ConvertToVector128Int16WithSaturation(Vector128<int> value);
+            public static Vector128<short> ConvertToVector128Int16WithSaturation(Vector128<long> value);
+            public static Vector128<short> ConvertToVector128Int16WithSaturation(Vector256<int> value);
+            public static Vector128<short> ConvertToVector128Int16WithSaturation(Vector256<long> value);
+            public static Vector128<int> ConvertToVector128Int32(Vector128<long> value);
+            public static Vector128<int> ConvertToVector128Int32(Vector128<ulong> value);
+            public static Vector128<int> ConvertToVector128Int32(Vector256<long> value);
+            public static Vector128<int> ConvertToVector128Int32(Vector256<ulong> value);
+            public static Vector128<int> ConvertToVector128Int32WithSaturation(Vector128<long> value);
+            public static Vector128<int> ConvertToVector128Int32WithSaturation(Vector256<long> value);
+            public static Vector128<sbyte> ConvertToVector128SByte(Vector128<int> value);
+            public static Vector128<sbyte> ConvertToVector128SByte(Vector128<long> value);
+            public static Vector128<sbyte> ConvertToVector128SByte(Vector128<uint> value);
+            public static Vector128<sbyte> ConvertToVector128SByte(Vector128<ulong> value);
+            public static Vector128<sbyte> ConvertToVector128SByte(Vector256<int> value);
+            public static Vector128<sbyte> ConvertToVector128SByte(Vector256<long> value);
+            public static Vector128<sbyte> ConvertToVector128SByte(Vector256<uint> value);
+            public static Vector128<sbyte> ConvertToVector128SByte(Vector256<ulong> value);
+            public static Vector128<sbyte> ConvertToVector128SByteWithSaturation(Vector128<int> value);
+            public static Vector128<sbyte> ConvertToVector128SByteWithSaturation(Vector128<long> value);
+            public static Vector128<sbyte> ConvertToVector128SByteWithSaturation(Vector256<int> value);
+            public static Vector128<sbyte> ConvertToVector128SByteWithSaturation(Vector256<long> value);
+            public static Vector128<float> ConvertToVector128Single(Vector128<uint> value);
+            public static Vector128<ushort> ConvertToVector128UInt16(Vector128<int> value);
+            public static Vector128<ushort> ConvertToVector128UInt16(Vector128<long> value);
+            public static Vector128<ushort> ConvertToVector128UInt16(Vector128<uint> value);
+            public static Vector128<ushort> ConvertToVector128UInt16(Vector128<ulong> value);
+            public static Vector128<ushort> ConvertToVector128UInt16(Vector256<int> value);
+            public static Vector128<ushort> ConvertToVector128UInt16(Vector256<long> value);
+            public static Vector128<ushort> ConvertToVector128UInt16(Vector256<uint> value);
+            public static Vector128<ushort> ConvertToVector128UInt16(Vector256<ulong> value);
+            public static Vector128<ushort> ConvertToVector128UInt16WithSaturation(Vector128<uint> value);
+            public static Vector128<ushort> ConvertToVector128UInt16WithSaturation(Vector128<ulong> value);
+            public static Vector128<ushort> ConvertToVector128UInt16WithSaturation(Vector256<uint> value);
+            public static Vector128<ushort> ConvertToVector128UInt16WithSaturation(Vector256<ulong> value);
+            public static Vector128<uint> ConvertToVector128UInt32(Vector128<double> value);
+            public static Vector128<uint> ConvertToVector128UInt32(Vector128<long> value);
+            public static Vector128<uint> ConvertToVector128UInt32(Vector128<float> value);
+            public static Vector128<uint> ConvertToVector128UInt32(Vector128<ulong> value);
+            public static Vector128<uint> ConvertToVector128UInt32(Vector256<double> value);
+            public static Vector128<uint> ConvertToVector128UInt32(Vector256<long> value);
+            public static Vector128<uint> ConvertToVector128UInt32(Vector256<ulong> value);
+            public static Vector128<uint> ConvertToVector128UInt32WithSaturation(Vector128<ulong> value);
+            public static Vector128<uint> ConvertToVector128UInt32WithSaturation(Vector256<ulong> value);
+            public static Vector128<uint> ConvertToVector128UInt32WithTruncation(Vector128<double> value);
+            public static Vector128<uint> ConvertToVector128UInt32WithTruncation(Vector128<float> value);
+            public static Vector128<uint> ConvertToVector128UInt32WithTruncation(Vector256<double> value);
+            public static Vector256<double> ConvertToVector256Double(Vector128<uint> value);
+            public static Vector256<float> ConvertToVector256Single(Vector256<uint> value);
+            public static Vector256<uint> ConvertToVector256UInt32(Vector256<float> value);
+            public static Vector256<uint> ConvertToVector256UInt32WithTruncation(Vector256<float> value);
+            public static Vector128<long> Max(Vector128<long> left, Vector128<long> right);
+            public static Vector128<ulong> Max(Vector128<ulong> left, Vector128<ulong> right);
+            public static Vector256<long> Max(Vector256<long> left, Vector256<long> right);
+            public static Vector256<ulong> Max(Vector256<ulong> left, Vector256<ulong> right);
+            public static Vector128<long> Min(Vector128<long> left, Vector128<long> right);
+            public static Vector128<ulong> Min(Vector128<ulong> left, Vector128<ulong> right);
+            public static Vector256<long> Min(Vector256<long> left, Vector256<long> right);
+            public static Vector256<ulong> Min(Vector256<ulong> left, Vector256<ulong> right);
+            public static Vector256<double> PermuteVar4x64(Vector256<double> value, Vector256<long> control);
+            public static Vector256<long> PermuteVar4x64(Vector256<long> value, Vector256<long> control);
+            public static Vector256<ulong> PermuteVar4x64(Vector256<ulong> value, Vector256<ulong> control);
+            public static Vector128<long> ShiftRightArithmetic(Vector128<long> value, [ConstantExpectedAttribute] byte count);
+            public static Vector128<long> ShiftRightArithmetic(Vector128<long> value, Vector128<long> count);
+            public static Vector256<long> ShiftRightArithmetic(Vector256<long> value, [ConstantExpectedAttribute] byte count);
+            public static Vector256<long> ShiftRightArithmetic(Vector256<long> value, Vector128<long> count);
+            public static Vector128<long> ShiftRightArithmeticVariable(Vector128<long> value, Vector128<ulong> count);
+            public static Vector256<long> ShiftRightArithmeticVariable(Vector256<long> value, Vector256<ulong> count);
         }
         public new abstract class X64 : Avx2.X64 {
+            public static Vector128<double> ConvertScalarToVector128Double(Vector128<double> upper, ulong value);
+            public static Vector128<float> ConvertScalarToVector128Single(Vector128<float> upper, ulong value);
+            public static ulong ConvertToUInt64(Vector128<double> value);
+            public static ulong ConvertToUInt64(Vector128<float> value);
+            public static ulong ConvertToUInt64WithTruncation(Vector128<double> value);
+            public static ulong ConvertToUInt64WithTruncation(Vector128<float> value);
         }
     }
+    [CLSCompliantAttribute(false)]
+    public abstract class Avx512Vbmi : Avx512BW {
+        public static new bool IsSupported { get; }
+        public static Vector512<byte> PermuteVar64x8(Vector512<byte> left, Vector512<byte> control);
+        public static Vector512<sbyte> PermuteVar64x8(Vector512<sbyte> left, Vector512<sbyte> control);
+        public new abstract class VL : Avx512BW.VL {
+            public static new bool IsSupported { get; }
+            public static Vector128<byte> PermuteVar16x8(Vector128<byte> left, Vector128<byte> control);
+            public static Vector128<sbyte> PermuteVar16x8(Vector128<sbyte> left, Vector128<sbyte> control);
+            public static Vector256<byte> PermuteVar32x8(Vector256<byte> left, Vector256<byte> control);
+            public static Vector256<sbyte> PermuteVar32x8(Vector256<sbyte> left, Vector256<sbyte> control);
+        }
+        public new abstract class X64 : Avx512BW.X64 {
+            public static new bool IsSupported { get; }
+        }
+    }
 }
```

