# System.Text.Json

``` diff
 namespace System.Text.Json {
     public class JsonException : Exception {
-        protected JsonException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected JsonException(SerializationInfo info, StreamingContext context);
-        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
     }
     public static class JsonSerializer {
+        public static bool IsReflectionEnabledByDefault { get; }
-        public static IAsyncEnumerable<object?> DeserializeAsyncEnumerable(Stream utf8Json, JsonTypeInfo jsonTypeInfo, CancellationToken cancellationToken = default(CancellationToken));
-        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
-        public static IAsyncEnumerable<object?> DeserializeAsyncEnumerable(Stream utf8Json, Type returnType, JsonSerializerOptions? options = null, CancellationToken cancellationToken = default(CancellationToken));
     }
     public sealed class JsonSerializerOptions {
+        public JsonObjectCreationHandling PreferredObjectCreationHandling { get; set; }
-        public void AddContext<TContext>() where TContext : JsonSerializerContext, new();
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("JsonSerializerOptions.AddContext is obsolete. To register a JsonSerializerContext, use either the TypeInfoResolver or TypeInfoResolverChain properties.", DiagnosticId="SYSLIB0049", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public void AddContext<TContext>() where TContext : JsonSerializerContext, new();
+        public bool TryGetTypeInfo(Type type, [NotNullWhenAttribute(true)] out JsonTypeInfo typeInfo);
     }
 }
```

