# System.Text.Unicode

``` diff
 namespace System.Text.Unicode {
     public static class Utf8 {
+        public static bool TryWrite(Span<byte> destination, IFormatProvider? provider, [InterpolatedStringHandlerArgumentAttribute(new string[]{ "destination", "provider"})] ref Utf8.TryWriteInterpolatedStringHandler handler, out int bytesWritten);
+        public static bool TryWrite(Span<byte> destination, [InterpolatedStringHandlerArgumentAttribute("destination")] ref Utf8.TryWriteInterpolatedStringHandler handler, out int bytesWritten);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [InterpolatedStringHandlerAttribute]
+        public ref struct TryWriteInterpolatedStringHandler {
+            public TryWriteInterpolatedStringHandler(int literalLength, int formattedCount, Span<byte> destination, out bool shouldAppend);
+            public TryWriteInterpolatedStringHandler(int literalLength, int formattedCount, Span<byte> destination, IFormatProvider? provider, out bool shouldAppend);
+            public bool AppendFormatted(object? value, int alignment = 0, string? format = null);
+            public bool AppendFormatted([ScopedRefAttribute] ReadOnlySpan<byte> utf8Value);
+            public bool AppendFormatted([ScopedRefAttribute] ReadOnlySpan<byte> utf8Value, int alignment = 0, string? format = null);
+            public bool AppendFormatted([ScopedRefAttribute] ReadOnlySpan<char> value);
+            public bool AppendFormatted([ScopedRefAttribute] ReadOnlySpan<char> value, int alignment = 0, string? format = null);
+            public bool AppendFormatted(string? value);
+            public bool AppendFormatted(string? value, int alignment = 0, string? format = null);
+            public bool AppendFormatted<T>(T value);
+            public bool AppendFormatted<T>(T value, int alignment);
+            public bool AppendFormatted<T>(T value, int alignment, string? format);
+            public bool AppendFormatted<T>(T value, string? format);
+            public bool AppendLiteral(string value);
+        }
     }
 }
```

