# System.Text

``` diff
 namespace System.Text {
     public static class Ascii {
+        public static bool Equals(ReadOnlySpan<byte> left, ReadOnlySpan<byte> right);
+        public static bool Equals(ReadOnlySpan<byte> left, ReadOnlySpan<char> right);
+        public static bool Equals(ReadOnlySpan<char> left, ReadOnlySpan<byte> right);
+        public static bool Equals(ReadOnlySpan<char> left, ReadOnlySpan<char> right);
+        public static bool EqualsIgnoreCase(ReadOnlySpan<byte> left, ReadOnlySpan<byte> right);
+        public static bool EqualsIgnoreCase(ReadOnlySpan<byte> left, ReadOnlySpan<char> right);
+        public static bool EqualsIgnoreCase(ReadOnlySpan<char> left, ReadOnlySpan<byte> right);
+        public static bool EqualsIgnoreCase(ReadOnlySpan<char> left, ReadOnlySpan<char> right);
     }
     public class ASCIIEncoding : Encoding {
+        public override bool TryGetBytes(ReadOnlySpan<char> chars, Span<byte> bytes, out int bytesWritten);
+        public override bool TryGetChars(ReadOnlySpan<byte> bytes, Span<char> chars, out int charsWritten);
     }
     public abstract class Encoding : ICloneable {
+        public virtual bool TryGetBytes(ReadOnlySpan<char> chars, Span<byte> bytes, out int bytesWritten);
+        public virtual bool TryGetChars(ReadOnlySpan<byte> bytes, Span<char> chars, out int charsWritten);
     }
-    public readonly struct Rune : IComparable, IComparable<Rune>, IEquatable<Rune>, IFormattable, ISpanFormattable {
+    public readonly struct Rune : IComparable, IComparable<Rune>, IEquatable<Rune>, IFormattable, ISpanFormattable, IUtf8SpanFormattable {
+        bool IUtf8SpanFormattable.TryFormat(Span<byte> utf8Destination, out int bytesWritten, ReadOnlySpan<char> format, IFormatProvider provider);
     }
     public class UTF8Encoding : Encoding {
+        public override bool TryGetBytes(ReadOnlySpan<char> chars, Span<byte> bytes, out int bytesWritten);
+        public override bool TryGetChars(ReadOnlySpan<byte> bytes, Span<char> chars, out int charsWritten);
     }
 }
```

