# System.Threading.Tasks

``` diff
 namespace System.Threading.Tasks {
     public static class Parallel {
+        public static Task ForAsync<T>(T fromInclusive, T toExclusive, Func<T, CancellationToken, ValueTask> body) where T : IBinaryInteger<T>;
+        public static Task ForAsync<T>(T fromInclusive, T toExclusive, CancellationToken cancellationToken, Func<T, CancellationToken, ValueTask> body) where T : IBinaryInteger<T>;
+        public static Task ForAsync<T>(T fromInclusive, T toExclusive, ParallelOptions parallelOptions, Func<T, CancellationToken, ValueTask> body) where T : IBinaryInteger<T>;
     }
     public class Task : IAsyncResult, IDisposable {
+        public static Task Delay(TimeSpan delay, TimeProvider timeProvider);
+        public static Task Delay(TimeSpan delay, TimeProvider timeProvider, CancellationToken cancellationToken);
+        public Task WaitAsync(TimeSpan timeout, TimeProvider timeProvider);
+        public Task WaitAsync(TimeSpan timeout, TimeProvider timeProvider, CancellationToken cancellationToken);
     }
     public class Task<TResult> : Task {
+        public new Task<TResult> WaitAsync(TimeSpan timeout, TimeProvider timeProvider);
+        public new Task<TResult> WaitAsync(TimeSpan timeout, TimeProvider timeProvider, CancellationToken cancellationToken);
     }
     public class TaskCanceledException : OperationCanceledException {
-        protected TaskCanceledException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected TaskCanceledException(SerializationInfo info, StreamingContext context);
     }
     public class TaskSchedulerException : Exception {
-        protected TaskSchedulerException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected TaskSchedulerException(SerializationInfo info, StreamingContext context);
     }
 }
```

