# Microsoft.AspNetCore.Builder

``` diff
 namespace Microsoft.AspNetCore.Builder {
-    public class ComponentTypeMetadata {
-        public ComponentTypeMetadata(Type componentType);
-        public Type Type { get; }
-    }
     public static class HttpLoggingEndpointConventionBuilderExtensions {
-        public static TBuilder WithHttpLogging<TBuilder>(this TBuilder builder, HttpLoggingFields loggingFields, int requestBodyLogLimit = -1, int responseBodyLogLimit = -1) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder WithHttpLogging<TBuilder>(this TBuilder builder, HttpLoggingFields loggingFields, int? requestBodyLogLimit = default(int?), int? responseBodyLogLimit = default(int?)) where TBuilder : IEndpointConventionBuilder;
     }
     public class RazorComponentEndpointConventionBuilder : IEndpointConventionBuilder {
+        public ComponentApplicationBuilder ApplicationBuilder { get; }
+        public RazorComponentEndpointConventionBuilder AddServerRenderMode();
+        public RazorComponentEndpointConventionBuilder AddWebAssemblyRenderMode();
     }
     public static class RazorComponentsEndpointRouteBuilderExtensions {
-        public static RazorComponentEndpointConventionBuilder MapRazorComponents<TRootComponent>(this IEndpointRouteBuilder endpoints) where TRootComponent : IRazorComponentApplication<TRootComponent>;
+        public static RazorComponentEndpointConventionBuilder MapRazorComponents<TRootComponent>(this IEndpointRouteBuilder endpoints);
     }
 }
```

