# Microsoft.AspNetCore.Components.Discovery

``` diff
+namespace Microsoft.AspNetCore.Components.Discovery {
+    [DebuggerDisplayAttribute("{GetDebuggerDisplay(),nq}")]
+    public class AssemblyComponentLibraryDescriptor {
+        public AssemblyComponentLibraryDescriptor(string name, IReadOnlyList<PageComponentBuilder> pages, IReadOnlyList<ComponentBuilder> components);
+        public string AssemblyName { get; }
+        public IReadOnlyList<ComponentBuilder> Components { get; }
+        public IReadOnlyList<PageComponentBuilder> Pages { get; }
+    }
+    public class ComponentApplicationBuilder {
+        public ComponentApplicationBuilder();
+        public void AddLibrary(AssemblyComponentLibraryDescriptor libraryBuilder);
+        public void Combine(ComponentApplicationBuilder other);
+        public void Exclude(ComponentApplicationBuilder builder);
+        public static ComponentApplicationBuilder? GetBuilder<TComponent>();
+        public bool HasLibrary(string assemblyName);
+        public void RemoveLibrary(string assembly);
+    }
+    public class ComponentBuilder : IEquatable<ComponentBuilder?> {
+        public ComponentBuilder();
+        public required string AssemblyName { get; set; }
+        public required Type ComponentType { get; set; }
+        public RenderModeAttribute? RenderMode { get; set; }
+        public bool Equals(ComponentBuilder? other);
+        public override bool Equals(object? obj);
+        public override int GetHashCode();
+    }
+    [DebuggerDisplayAttribute("{GetDebuggerDisplay(),nq}")]
+    public class PageComponentBuilder : IEquatable<PageComponentBuilder?> {
+        public PageComponentBuilder();
+        public required string AssemblyName { get; set; }
+        public required Type PageType { get; set; }
+        public required IReadOnlyList<string> RouteTemplates { get; set; }
+        public bool Equals(PageComponentBuilder? other);
+        public override bool Equals(object? obj);
+        public override int GetHashCode();
+        public bool HasSource(string source);
+    }
+}
```

