# Microsoft.AspNetCore.Components.Web

``` diff
 namespace Microsoft.AspNetCore.Components.Web {
+    public class AutoRenderMode : IComponentRenderMode {
+        public AutoRenderMode();
+        public AutoRenderMode(bool prerender);
+        public bool Prerender { get; }
+    }
+    public static class RenderMode {
+        public static AutoRenderMode Auto { get; }
+        public static ServerRenderMode Server { get; }
+        public static WebAssemblyRenderMode WebAssembly { get; }
+    }
+    public class RenderModeAutoAttribute : RenderModeAttribute {
+        public RenderModeAutoAttribute();
+        public RenderModeAutoAttribute(bool prerender);
+        public override IComponentRenderMode Mode { get; }
+    }
+    public class RenderModeServerAttribute : RenderModeAttribute {
+        public RenderModeServerAttribute();
+        public RenderModeServerAttribute(bool prerender);
+        public override IComponentRenderMode Mode { get; }
+    }
+    public class RenderModeWebAssemblyAttribute : RenderModeAttribute {
+        public RenderModeWebAssemblyAttribute();
+        public RenderModeWebAssemblyAttribute(bool prerender);
+        public override IComponentRenderMode Mode { get; }
+    }
+    public class ServerRenderMode : IComponentRenderMode {
+        public ServerRenderMode();
+        public ServerRenderMode(bool prerender);
+        public bool Prerender { get; }
+    }
+    public class WebAssemblyRenderMode : IComponentRenderMode {
+        public WebAssemblyRenderMode();
+        public WebAssemblyRenderMode(bool prerender);
+        public bool Prerender { get; }
+    }
 }
```

