# Microsoft.AspNetCore.Components

``` diff
 namespace Microsoft.AspNetCore.Components {
-    public class ComponentApplicationBuilder {
-        public ComponentApplicationBuilder();
-        public RazorComponentApplication Build();
-    }
+    public interface IComponentRenderMode
-    public interface IRazorComponentApplication<TComponent> where TComponent : IRazorComponentApplication<TComponent> {
-        static ComponentApplicationBuilder GetBuilder();
-    }
-    public class PageDefinition {
-        public string DisplayName { get; }
-        public IReadOnlyList<object> Metadata { get; }
-        public string Route { get; }
-        public Type Type { get; }
-    }
     public readonly struct ParameterView {
-        public IReadOnlyDictionary<string, object> ToDictionary();
+        public IReadOnlyDictionary<string, object?> ToDictionary();
     }
-    public class RazorComponentApplication {
-        public IEnumerable<PageDefinition> Pages { get; }
-    }
-    public enum RenderMode {
-        Server = 2,
-        ServerPrerendered = 3,
-        Static = 1,
-        WebAssembly = 4,
-        WebAssemblyPrerendered = 5,
-    }
+    [AttributeUsageAttribute(4)]
+    public abstract class RenderModeAttribute : Attribute {
+        protected RenderModeAttribute();
+        public abstract IComponentRenderMode Mode { get; }
+    }
     public sealed class RouteData {
-        public RouteData(Type pageType, IReadOnlyDictionary<string, object> routeValues);
+        public RouteData(Type pageType, IReadOnlyDictionary<string, object?> routeValues);
-        public IReadOnlyDictionary<string, object> RouteValues { get; }
+        public IReadOnlyDictionary<string, object?> RouteValues { get; }
     }
 }
```

