# Microsoft.AspNetCore.Http

``` diff
 namespace Microsoft.AspNetCore.Http {
-    public abstract class ConnectionInfo
+    [DebuggerDisplayAttribute("{DebuggerToString(),nq}")]
+    [DebuggerTypeProxyAttribute(typeof(ConnectionInfo.ConnectionInfoDebugView))]
+    public abstract class ConnectionInfo
-    public sealed class DefaultHttpContext : HttpContext
+    [DebuggerDisplayAttribute("{DebuggerToString(),nq}")]
+    public sealed class DefaultHttpContext : HttpContext
-    public class Endpoint
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public class Endpoint
-    [AttributeUsageAttribute(64, Inherited=false, AllowMultiple=false)]
-    public sealed class EndpointDescriptionAttribute : Attribute, IEndpointDescriptionMetadata {
+    [AttributeUsageAttribute(64, Inherited=false, AllowMultiple=false)]
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public sealed class EndpointDescriptionAttribute : Attribute, IEndpointDescriptionMetadata {
+        public override string ToString();
     }
-    public sealed class EndpointMetadataCollection : IEnumerable, IEnumerable<object>, IReadOnlyCollection<object>, IReadOnlyList<object>
+    [DebuggerDisplayAttribute("Count = {Count}")]
+    [DebuggerTypeProxyAttribute(typeof(EndpointMetadataCollection.EndpointMetadataCollectionDebugView))]
+    public sealed class EndpointMetadataCollection : IEnumerable, IEnumerable<object>, IReadOnlyCollection<object>, IReadOnlyList<object>
-    [AttributeUsageAttribute(64, Inherited=false, AllowMultiple=false)]
-    public sealed class EndpointSummaryAttribute : Attribute, IEndpointSummaryMetadata {
+    [AttributeUsageAttribute(64, Inherited=false, AllowMultiple=false)]
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public sealed class EndpointSummaryAttribute : Attribute, IEndpointSummaryMetadata {
+        public override string ToString();
     }
-    public readonly struct FragmentString : IEquatable<FragmentString>
+    [DebuggerDisplayAttribute("{Value}")]
+    public readonly struct FragmentString : IEquatable<FragmentString>
-    public class HeaderDictionary : ICollection<KeyValuePair<string, StringValues>>, IDictionary<string, StringValues>, IEnumerable, IEnumerable<KeyValuePair<string, StringValues>>, IHeaderDictionary
+    [DebuggerDisplayAttribute("Count = {Count}")]
+    [DebuggerTypeProxyAttribute(typeof(HeaderDictionary.HeaderDictionaryDebugView))]
+    public class HeaderDictionary : ICollection<KeyValuePair<string, StringValues>>, IDictionary<string, StringValues>, IEnumerable, IEnumerable<KeyValuePair<string, StringValues>>, IHeaderDictionary
-    public readonly struct HostString : IEquatable<HostString>
+    [DebuggerDisplayAttribute("{Value}")]
+    public readonly struct HostString : IEquatable<HostString>
-    public abstract class HttpContext
+    [DebuggerDisplayAttribute("{DebuggerToString(),nq}")]
+    [DebuggerTypeProxyAttribute(typeof(HttpContext.HttpContextDebugView))]
+    public abstract class HttpContext
-    public abstract class HttpRequest
+    [DebuggerDisplayAttribute("{DebuggerToString(),nq}")]
+    [DebuggerTypeProxyAttribute(typeof(HttpRequest.HttpRequestDebugView))]
+    public abstract class HttpRequest
-    public abstract class HttpResponse
+    [DebuggerDisplayAttribute("{DebuggerToString(),nq}")]
+    [DebuggerTypeProxyAttribute(typeof(HttpResponse.HttpResponseDebugView))]
+    public abstract class HttpResponse
-    [TypeConverterAttribute(typeof(PathStringConverter))]
-    public readonly struct PathString : IEquatable<PathString>
+    [DebuggerDisplayAttribute("{Value}")]
+    [TypeConverterAttribute(typeof(PathStringConverter))]
+    public readonly struct PathString : IEquatable<PathString>
-    public class QueryCollection : IEnumerable, IEnumerable<KeyValuePair<string, StringValues>>, IQueryCollection
+    [DebuggerDisplayAttribute("Count = {Count}")]
+    [DebuggerTypeProxyAttribute(typeof(QueryCollection.QueryCollectionDebugView))]
+    public class QueryCollection : IEnumerable, IEnumerable<KeyValuePair<string, StringValues>>, IQueryCollection
-    public readonly struct QueryString : IEquatable<QueryString>
+    [DebuggerDisplayAttribute("{Value}")]
+    public readonly struct QueryString : IEquatable<QueryString>
-    [AttributeUsageAttribute(4164, Inherited=false, AllowMultiple=false)]
-    public sealed class TagsAttribute : Attribute, ITagsMetadata {
+    [AttributeUsageAttribute(4164, Inherited=false, AllowMultiple=false)]
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public sealed class TagsAttribute : Attribute, ITagsMetadata {
+        public override string ToString();
     }
-    public abstract class WebSocketManager
+    [DebuggerDisplayAttribute("{DebuggerToString(),nq}")]
+    [DebuggerTypeProxyAttribute(typeof(WebSocketManager.WebSocketManagerDebugView))]
+    public abstract class WebSocketManager
 }
```

