# Microsoft.AspNetCore.Identity

``` diff
 namespace Microsoft.AspNetCore.Identity {
     public class SecurityStampValidator<TUser> : ISecurityStampValidator where TUser : class {
-        public SecurityStampValidator(IOptions<SecurityStampValidatorOptions> options, SignInManager<TUser> signInManager, ISystemClock clock, ILoggerFactory logger);
+        [ObsoleteAttribute("ISystemClock is obsolete, use TimeProvider on SecurityStampValidatorOptions instead.")]
+        public SecurityStampValidator(IOptions<SecurityStampValidatorOptions> options, SignInManager<TUser> signInManager, ISystemClock clock, ILoggerFactory logger);
+        public SecurityStampValidator(IOptions<SecurityStampValidatorOptions> options, SignInManager<TUser> signInManager, ILoggerFactory logger);
-        public ISystemClock Clock { get; }
+        [ObsoleteAttribute("ISystemClock is obsolete, use TimeProvider instead.")]
+        public ISystemClock Clock { get; }
+        public TimeProvider TimeProvider { get; }
     }
     public class SecurityStampValidatorOptions {
+        public TimeProvider TimeProvider { get; set; }
     }
     public class TwoFactorSecurityStampValidator<TUser> : SecurityStampValidator<TUser>, ISecurityStampValidator, ITwoFactorSecurityStampValidator where TUser : class {
-        public TwoFactorSecurityStampValidator(IOptions<SecurityStampValidatorOptions> options, SignInManager<TUser> signInManager, ISystemClock clock, ILoggerFactory logger);
+        [ObsoleteAttribute("ISystemClock is obsolete, use TimeProvider on SecurityStampValidatorOptions instead.")]
+        public TwoFactorSecurityStampValidator(IOptions<SecurityStampValidatorOptions> options, SignInManager<TUser> signInManager, ISystemClock clock, ILoggerFactory logger);
+        public TwoFactorSecurityStampValidator(IOptions<SecurityStampValidatorOptions> options, SignInManager<TUser> signInManager, ILoggerFactory logger);
     }
 }
```

