# Microsoft.AspNetCore.Routing

``` diff
 namespace Microsoft.AspNetCore.Routing {
-    public sealed class DataTokensMetadata : IDataTokensMetadata {
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public sealed class DataTokensMetadata : IDataTokensMetadata {
+        public override string ToString();
     }
     public class EndpointNameMetadata : IEndpointNameMetadata {
+        public override string ToString();
     }
-    [AttributeUsageAttribute(4164, AllowMultiple=false, Inherited=true)]
-    public sealed class ExcludeFromDescriptionAttribute : Attribute, IExcludeFromDescriptionMetadata {
+    [AttributeUsageAttribute(4164, AllowMultiple=false, Inherited=true)]
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public sealed class ExcludeFromDescriptionAttribute : Attribute, IExcludeFromDescriptionMetadata {
+        public override string ToString();
     }
-    [AttributeUsageAttribute(68, AllowMultiple=false, Inherited=false)]
-    [DebuggerDisplayAttribute("{DebuggerToString(),nq}")]
-    public sealed class HostAttribute : Attribute, IHostMetadata {
+    [AttributeUsageAttribute(68, AllowMultiple=false, Inherited=false)]
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public sealed class HostAttribute : Attribute, IHostMetadata {
+        public override string ToString();
     }
-    [DebuggerDisplayAttribute("{DebuggerToString(),nq}")]
-    public sealed class HttpMethodMetadata : IHttpMethodMetadata {
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public sealed class HttpMethodMetadata : IHttpMethodMetadata {
+        public override string ToString();
     }
     [EditorBrowsableAttribute(1)]
     public static class RouteHandlerServices {
-        public static RouteHandlerBuilder Map(IEndpointRouteBuilder endpoints, string pattern, Delegate handler, IEnumerable<string> httpMethods, Func<MethodInfo, RequestDelegateFactoryOptions?, RequestDelegateMetadataResult> populateMetadata, Func<Delegate, RequestDelegateFactoryOptions, RequestDelegateMetadataResult?, RequestDelegateResult> createRequestDelegate);
+        public static RouteHandlerBuilder Map(IEndpointRouteBuilder endpoints, string pattern, Delegate handler, IEnumerable<string>? httpMethods, Func<MethodInfo, RequestDelegateFactoryOptions?, RequestDelegateMetadataResult> populateMetadata, Func<Delegate, RequestDelegateFactoryOptions, RequestDelegateMetadataResult?, RequestDelegateResult> createRequestDelegate);
     }
-    [DebuggerDisplayAttribute("{DebuggerToString(),nq}")]
-    public sealed class RouteNameMetadata : IRouteNameMetadata {
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public sealed class RouteNameMetadata : IRouteNameMetadata {
+        public override string ToString();
     }
-    public class RouteValueDictionary : ICollection<KeyValuePair<string, object?>>, IDictionary<string, object?>, IEnumerable, IEnumerable<KeyValuePair<string, object?>>, IReadOnlyCollection<KeyValuePair<string, object?>>, IReadOnlyDictionary<string, object?>
+    [DebuggerDisplayAttribute("Count = {Count}")]
+    [DebuggerTypeProxyAttribute(typeof(RouteValueDictionary.RouteValueDictionaryDebugView))]
+    public class RouteValueDictionary : ICollection<KeyValuePair<string, object?>>, IDictionary<string, object?>, IEnumerable, IEnumerable<KeyValuePair<string, object?>>, IReadOnlyCollection<KeyValuePair<string, object?>>, IReadOnlyDictionary<string, object?>
-    public sealed class SuppressLinkGenerationMetadata : ISuppressLinkGenerationMetadata {
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public sealed class SuppressLinkGenerationMetadata : ISuppressLinkGenerationMetadata {
+        public override string ToString();
     }
-    public sealed class SuppressMatchingMetadata : ISuppressMatchingMetadata {
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public sealed class SuppressMatchingMetadata : ISuppressMatchingMetadata {
+        public override string ToString();
     }
 }
```

