# System.Runtime.InteropServices.Marshalling

``` diff
 namespace System.Runtime.InteropServices.Marshalling {
+    [CLSCompliantAttribute(false)]
+    [CustomMarshallerAttribute(typeof(CustomMarshallerAttribute.GenericPlaceholder), MarshalMode.Default, typeof(ComInterfaceMarshaller<>))]
+    [UnsupportedOSPlatformAttribute("android")]
+    [UnsupportedOSPlatformAttribute("browser")]
+    [UnsupportedOSPlatformAttribute("ios")]
+    [UnsupportedOSPlatformAttribute("tvos")]
+    public static class ComInterfaceMarshaller<T> {
+        public unsafe static T? ConvertToManaged(void* unmanaged);
+        public unsafe static void* ConvertToUnmanaged(T? managed);
+    }
     [AttributeUsageAttribute(AttributeTargets.Interface)]
     public class GeneratedComInterfaceAttribute : Attribute {
+        public StringMarshalling StringMarshalling { get; set; }
+        public Type StringMarshallingCustomType { get; set; }
     }
-    [AttributeUsageAttribute(AttributeTargets.Class | AttributeTargets.Delegate | AttributeTargets.Enum | AttributeTargets.Struct)]
-    public sealed class NativeMarshallingAttribute : Attribute
+    [AttributeUsageAttribute(AttributeTargets.Class | AttributeTargets.Delegate | AttributeTargets.Enum | AttributeTargets.Interface | AttributeTargets.Struct)]
+    public sealed class NativeMarshallingAttribute : Attribute
+    [CustomMarshallerAttribute(typeof(CustomMarshallerAttribute.GenericPlaceholder), MarshalMode.ManagedToUnmanagedIn, typeof(SafeHandleMarshaller<>.ManagedToUnmanagedIn))]
+    [CustomMarshallerAttribute(typeof(CustomMarshallerAttribute.GenericPlaceholder), MarshalMode.ManagedToUnmanagedOut, typeof(SafeHandleMarshaller<>.ManagedToUnmanagedOut))]
+    [CustomMarshallerAttribute(typeof(CustomMarshallerAttribute.GenericPlaceholder), MarshalMode.ManagedToUnmanagedRef, typeof(SafeHandleMarshaller<>.ManagedToUnmanagedRef))]
+    public static class SafeHandleMarshaller<T> where T : SafeHandle {
+        public struct ManagedToUnmanagedIn {
+            public void Free();
+            public void FromManaged(T handle);
+            public IntPtr ToUnmanaged();
+        }
+        public struct ManagedToUnmanagedOut {
+            public ManagedToUnmanagedOut();
+            public void Free();
+            public void FromUnmanaged(IntPtr value);
+            public T ToManaged();
+        }
+        public struct ManagedToUnmanagedRef {
+            public ManagedToUnmanagedRef();
+            public void Free();
+            public void FromManaged(T handle);
+            public void FromUnmanaged(IntPtr value);
+            public void OnInvoked();
+            public T ToManagedFinally();
+            public IntPtr ToUnmanaged();
+        }
+    }
+    [CLSCompliantAttribute(false)]
+    [CustomMarshallerAttribute(typeof(CustomMarshallerAttribute.GenericPlaceholder), MarshalMode.Default, typeof(UniqueComInterfaceMarshaller<>))]
+    [UnsupportedOSPlatformAttribute("android")]
+    [UnsupportedOSPlatformAttribute("browser")]
+    [UnsupportedOSPlatformAttribute("ios")]
+    [UnsupportedOSPlatformAttribute("tvos")]
+    public static class UniqueComInterfaceMarshaller<T> {
+        public unsafe static T? ConvertToManaged(void* unmanaged);
+        public unsafe static void* ConvertToUnmanaged(T? managed);
+    }
 }
```

