# System.Runtime.Intrinsics.X86

``` diff
 namespace System.Runtime.Intrinsics.X86 {
     [CLSCompliantAttribute(false)]
     public abstract class Avx512BW : Avx512F {
+        public static Vector512<short> PermuteVar32x16x2(Vector512<short> lower, Vector512<short> indices, Vector512<short> upper);
+        public static Vector512<ushort> PermuteVar32x16x2(Vector512<ushort> lower, Vector512<ushort> indices, Vector512<ushort> upper);
+        public static Vector512<ushort> SumAbsoluteDifferencesInBlock32(Vector512<byte> left, Vector512<byte> right, [ConstantExpectedAttribute] byte control);
         public new abstract class VL : Avx512F.VL {
+            public static Vector256<short> PermuteVar16x16x2(Vector256<short> lower, Vector256<short> indices, Vector256<short> upper);
+            public static Vector256<ushort> PermuteVar16x16x2(Vector256<ushort> lower, Vector256<ushort> indices, Vector256<ushort> upper);
+            public static Vector128<short> PermuteVar8x16x2(Vector128<short> lower, Vector128<short> indices, Vector128<short> upper);
+            public static Vector128<ushort> PermuteVar8x16x2(Vector128<ushort> lower, Vector128<ushort> indices, Vector128<ushort> upper);
+            public static Vector128<ushort> SumAbsoluteDifferencesInBlock32(Vector128<byte> left, Vector128<byte> right, [ConstantExpectedAttribute] byte control);
+            public static Vector256<ushort> SumAbsoluteDifferencesInBlock32(Vector256<byte> left, Vector256<byte> right, [ConstantExpectedAttribute] byte control);
         }
     }
     [CLSCompliantAttribute(false)]
     public abstract class Avx512CD : Avx512F {
+        public static Vector512<int> DetectConflicts(Vector512<int> value);
+        public static Vector512<long> DetectConflicts(Vector512<long> value);
+        public static Vector512<uint> DetectConflicts(Vector512<uint> value);
+        public static Vector512<ulong> DetectConflicts(Vector512<ulong> value);
+        public static Vector512<int> LeadingZeroCount(Vector512<int> value);
+        public static Vector512<long> LeadingZeroCount(Vector512<long> value);
+        public static Vector512<uint> LeadingZeroCount(Vector512<uint> value);
+        public static Vector512<ulong> LeadingZeroCount(Vector512<ulong> value);
         public new abstract class VL : Avx512F.VL {
+            public static Vector128<int> DetectConflicts(Vector128<int> value);
+            public static Vector128<long> DetectConflicts(Vector128<long> value);
+            public static Vector128<uint> DetectConflicts(Vector128<uint> value);
+            public static Vector128<ulong> DetectConflicts(Vector128<ulong> value);
+            public static Vector256<int> DetectConflicts(Vector256<int> value);
+            public static Vector256<long> DetectConflicts(Vector256<long> value);
+            public static Vector256<uint> DetectConflicts(Vector256<uint> value);
+            public static Vector256<ulong> DetectConflicts(Vector256<ulong> value);
+            public static Vector128<int> LeadingZeroCount(Vector128<int> value);
+            public static Vector128<long> LeadingZeroCount(Vector128<long> value);
+            public static Vector128<uint> LeadingZeroCount(Vector128<uint> value);
+            public static Vector128<ulong> LeadingZeroCount(Vector128<ulong> value);
+            public static Vector256<int> LeadingZeroCount(Vector256<int> value);
+            public static Vector256<long> LeadingZeroCount(Vector256<long> value);
+            public static Vector256<uint> LeadingZeroCount(Vector256<uint> value);
+            public static Vector256<ulong> LeadingZeroCount(Vector256<ulong> value);
         }
     }
     [CLSCompliantAttribute(false)]
     public abstract class Avx512DQ : Avx512F {
+        public static Vector512<double> Range(Vector512<double> left, Vector512<double> right, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+        public static Vector512<float> Range(Vector512<float> left, Vector512<float> right, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+        public static Vector128<double> RangeScalar(Vector128<double> left, Vector128<double> right, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+        public static Vector128<float> RangeScalar(Vector128<float> left, Vector128<float> right, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+        public static Vector512<double> Reduce(Vector512<double> value, [ConstantExpectedAttribute] byte control);
+        public static Vector512<float> Reduce(Vector512<float> value, [ConstantExpectedAttribute] byte control);
+        public static Vector128<double> ReduceScalar(Vector128<double> value, [ConstantExpectedAttribute] byte control);
+        public static Vector128<double> ReduceScalar(Vector128<double> upper, Vector128<double> value, [ConstantExpectedAttribute] byte control);
+        public static Vector128<float> ReduceScalar(Vector128<float> value, [ConstantExpectedAttribute] byte control);
+        public static Vector128<float> ReduceScalar(Vector128<float> upper, Vector128<float> value, [ConstantExpectedAttribute] byte control);
         public new abstract class VL : Avx512F.VL {
+            public static Vector128<double> Range(Vector128<double> left, Vector128<double> right, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+            public static Vector128<float> Range(Vector128<float> left, Vector128<float> right, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+            public static Vector256<double> Range(Vector256<double> left, Vector256<double> right, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+            public static Vector256<float> Range(Vector256<float> left, Vector256<float> right, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+            public static Vector128<double> Reduce(Vector128<double> value, [ConstantExpectedAttribute] byte control);
+            public static Vector128<float> Reduce(Vector128<float> value, [ConstantExpectedAttribute] byte control);
+            public static Vector256<double> Reduce(Vector256<double> value, [ConstantExpectedAttribute] byte control);
+            public static Vector256<float> Reduce(Vector256<float> value, [ConstantExpectedAttribute] byte control);
         }
     }
     [CLSCompliantAttribute(false)]
     public abstract class Avx512F : Avx2 {
+        public static Vector512<int> AlignRight32(Vector512<int> left, Vector512<int> right, [ConstantExpectedAttribute] byte mask);
+        public static Vector512<uint> AlignRight32(Vector512<uint> left, Vector512<uint> right, [ConstantExpectedAttribute] byte mask);
+        public static Vector512<long> AlignRight64(Vector512<long> left, Vector512<long> right, [ConstantExpectedAttribute] byte mask);
+        public static Vector512<ulong> AlignRight64(Vector512<ulong> left, Vector512<ulong> right, [ConstantExpectedAttribute] byte mask);
+        public static Vector512<double> Fixup(Vector512<double> left, Vector512<double> right, Vector512<long> table, [ConstantExpectedAttribute] byte control);
+        public static Vector512<float> Fixup(Vector512<float> left, Vector512<float> right, Vector512<int> table, [ConstantExpectedAttribute] byte control);
+        public static Vector128<double> FixupScalar(Vector128<double> left, Vector128<double> right, Vector128<long> table, [ConstantExpectedAttribute] byte control);
+        public static Vector128<float> FixupScalar(Vector128<float> left, Vector128<float> right, Vector128<int> table, [ConstantExpectedAttribute] byte control);
+        public static Vector512<double> GetExponent(Vector512<double> value);
+        public static Vector512<float> GetExponent(Vector512<float> value);
+        public static Vector128<double> GetExponentScalar(Vector128<double> value);
+        public static Vector128<double> GetExponentScalar(Vector128<double> upper, Vector128<double> value);
+        public static Vector128<float> GetExponentScalar(Vector128<float> value);
+        public static Vector128<float> GetExponentScalar(Vector128<float> upper, Vector128<float> value);
+        public static Vector512<double> GetMantissa(Vector512<double> value, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+        public static Vector512<float> GetMantissa(Vector512<float> value, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+        public static Vector128<double> GetMantissaScalar(Vector128<double> value, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+        public static Vector128<double> GetMantissaScalar(Vector128<double> upper, Vector128<double> value, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+        public static Vector128<float> GetMantissaScalar(Vector128<float> value, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+        public static Vector128<float> GetMantissaScalar(Vector128<float> upper, Vector128<float> value, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+        public static Vector512<int> PermuteVar16x32x2(Vector512<int> lower, Vector512<int> indices, Vector512<int> upper);
+        public static Vector512<float> PermuteVar16x32x2(Vector512<float> lower, Vector512<int> indices, Vector512<float> upper);
+        public static Vector512<uint> PermuteVar16x32x2(Vector512<uint> lower, Vector512<uint> indices, Vector512<uint> upper);
+        public static Vector512<double> PermuteVar8x64x2(Vector512<double> lower, Vector512<long> indices, Vector512<double> upper);
+        public static Vector512<long> PermuteVar8x64x2(Vector512<long> lower, Vector512<long> indices, Vector512<long> upper);
+        public static Vector512<ulong> PermuteVar8x64x2(Vector512<ulong> lower, Vector512<ulong> indices, Vector512<ulong> upper);
+        public static Vector512<double> Reciprocal14(Vector512<double> value);
+        public static Vector512<float> Reciprocal14(Vector512<float> value);
+        public static Vector128<double> Reciprocal14Scalar(Vector128<double> value);
+        public static Vector128<double> Reciprocal14Scalar(Vector128<double> upper, Vector128<double> value);
+        public static Vector128<float> Reciprocal14Scalar(Vector128<float> value);
+        public static Vector128<float> Reciprocal14Scalar(Vector128<float> upper, Vector128<float> value);
+        public static Vector512<double> ReciprocalSqrt14(Vector512<double> value);
+        public static Vector512<float> ReciprocalSqrt14(Vector512<float> value);
+        public static Vector128<double> ReciprocalSqrt14Scalar(Vector128<double> value);
+        public static Vector128<double> ReciprocalSqrt14Scalar(Vector128<double> upper, Vector128<double> value);
+        public static Vector128<float> ReciprocalSqrt14Scalar(Vector128<float> value);
+        public static Vector128<float> ReciprocalSqrt14Scalar(Vector128<float> upper, Vector128<float> value);
+        public static Vector512<int> RotateLeft(Vector512<int> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<long> RotateLeft(Vector512<long> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<uint> RotateLeft(Vector512<uint> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<ulong> RotateLeft(Vector512<ulong> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<int> RotateLeftVariable(Vector512<int> value, Vector512<uint> count);
+        public static Vector512<long> RotateLeftVariable(Vector512<long> value, Vector512<ulong> count);
+        public static Vector512<uint> RotateLeftVariable(Vector512<uint> value, Vector512<uint> count);
+        public static Vector512<ulong> RotateLeftVariable(Vector512<ulong> value, Vector512<ulong> count);
+        public static Vector512<int> RotateRight(Vector512<int> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<long> RotateRight(Vector512<long> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<uint> RotateRight(Vector512<uint> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<ulong> RotateRight(Vector512<ulong> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<int> RotateRightVariable(Vector512<int> value, Vector512<uint> count);
+        public static Vector512<long> RotateRightVariable(Vector512<long> value, Vector512<ulong> count);
+        public static Vector512<uint> RotateRightVariable(Vector512<uint> value, Vector512<uint> count);
+        public static Vector512<ulong> RotateRightVariable(Vector512<ulong> value, Vector512<ulong> count);
+        public static Vector512<double> RoundScale(Vector512<double> value, [ConstantExpectedAttribute] byte control);
+        public static Vector512<float> RoundScale(Vector512<float> value, [ConstantExpectedAttribute] byte control);
+        public static Vector128<double> RoundScaleScalar(Vector128<double> value, [ConstantExpectedAttribute] byte control);
+        public static Vector128<double> RoundScaleScalar(Vector128<double> upper, Vector128<double> value, [ConstantExpectedAttribute] byte control);
+        public static Vector128<float> RoundScaleScalar(Vector128<float> value, [ConstantExpectedAttribute] byte control);
+        public static Vector128<float> RoundScaleScalar(Vector128<float> upper, Vector128<float> value, [ConstantExpectedAttribute] byte control);
+        public static Vector512<double> Scale(Vector512<double> left, Vector512<double> right);
+        public static Vector512<float> Scale(Vector512<float> left, Vector512<float> right);
+        public static Vector128<double> ScaleScalar(Vector128<double> left, Vector128<double> right);
+        public static Vector128<float> ScaleScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector512<double> Shuffle4x128(Vector512<double> left, Vector512<double> right, [ConstantExpectedAttribute] byte control);
+        public static Vector512<int> Shuffle4x128(Vector512<int> left, Vector512<int> right, [ConstantExpectedAttribute] byte control);
+        public static Vector512<long> Shuffle4x128(Vector512<long> left, Vector512<long> right, [ConstantExpectedAttribute] byte control);
+        public static Vector512<float> Shuffle4x128(Vector512<float> left, Vector512<float> right, [ConstantExpectedAttribute] byte control);
+        public static Vector512<uint> Shuffle4x128(Vector512<uint> left, Vector512<uint> right, [ConstantExpectedAttribute] byte control);
+        public static Vector512<ulong> Shuffle4x128(Vector512<ulong> left, Vector512<ulong> right, [ConstantExpectedAttribute] byte control);
+        public static Vector512<byte> TernaryLogic(Vector512<byte> a, Vector512<byte> b, Vector512<byte> c, [ConstantExpectedAttribute] byte control);
+        public static Vector512<double> TernaryLogic(Vector512<double> a, Vector512<double> b, Vector512<double> c, [ConstantExpectedAttribute] byte control);
+        public static Vector512<short> TernaryLogic(Vector512<short> a, Vector512<short> b, Vector512<short> c, [ConstantExpectedAttribute] byte control);
+        public static Vector512<int> TernaryLogic(Vector512<int> a, Vector512<int> b, Vector512<int> c, [ConstantExpectedAttribute] byte control);
+        public static Vector512<long> TernaryLogic(Vector512<long> a, Vector512<long> b, Vector512<long> c, [ConstantExpectedAttribute] byte control);
+        public static Vector512<sbyte> TernaryLogic(Vector512<sbyte> a, Vector512<sbyte> b, Vector512<sbyte> c, [ConstantExpectedAttribute] byte control);
+        public static Vector512<float> TernaryLogic(Vector512<float> a, Vector512<float> b, Vector512<float> c, [ConstantExpectedAttribute] byte control);
+        public static Vector512<ushort> TernaryLogic(Vector512<ushort> a, Vector512<ushort> b, Vector512<ushort> c, [ConstantExpectedAttribute] byte control);
+        public static Vector512<uint> TernaryLogic(Vector512<uint> a, Vector512<uint> b, Vector512<uint> c, [ConstantExpectedAttribute] byte control);
+        public static Vector512<ulong> TernaryLogic(Vector512<ulong> a, Vector512<ulong> b, Vector512<ulong> c, [ConstantExpectedAttribute] byte control);
         public abstract class VL {
+            public static Vector128<int> AlignRight32(Vector128<int> left, Vector128<int> right, [ConstantExpectedAttribute] byte mask);
+            public static Vector128<uint> AlignRight32(Vector128<uint> left, Vector128<uint> right, [ConstantExpectedAttribute] byte mask);
+            public static Vector256<int> AlignRight32(Vector256<int> left, Vector256<int> right, [ConstantExpectedAttribute] byte mask);
+            public static Vector256<uint> AlignRight32(Vector256<uint> left, Vector256<uint> right, [ConstantExpectedAttribute] byte mask);
+            public static Vector128<long> AlignRight64(Vector128<long> left, Vector128<long> right, [ConstantExpectedAttribute] byte mask);
+            public static Vector128<ulong> AlignRight64(Vector128<ulong> left, Vector128<ulong> right, [ConstantExpectedAttribute] byte mask);
+            public static Vector256<long> AlignRight64(Vector256<long> left, Vector256<long> right, [ConstantExpectedAttribute] byte mask);
+            public static Vector256<ulong> AlignRight64(Vector256<ulong> left, Vector256<ulong> right, [ConstantExpectedAttribute] byte mask);
+            public static Vector128<double> Fixup(Vector128<double> left, Vector128<double> right, Vector128<long> table, [ConstantExpectedAttribute] byte control);
+            public static Vector128<float> Fixup(Vector128<float> left, Vector128<float> right, Vector128<int> table, [ConstantExpectedAttribute] byte control);
+            public static Vector256<double> Fixup(Vector256<double> left, Vector256<double> right, Vector256<long> table, [ConstantExpectedAttribute] byte control);
+            public static Vector256<float> Fixup(Vector256<float> left, Vector256<float> right, Vector256<int> table, [ConstantExpectedAttribute] byte control);
+            public static Vector128<double> GetExponent(Vector128<double> value);
+            public static Vector128<float> GetExponent(Vector128<float> value);
+            public static Vector256<double> GetExponent(Vector256<double> value);
+            public static Vector256<float> GetExponent(Vector256<float> value);
+            public static Vector128<double> GetMantissa(Vector128<double> value, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+            public static Vector128<float> GetMantissa(Vector128<float> value, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+            public static Vector256<double> GetMantissa(Vector256<double> value, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+            public static Vector256<float> GetMantissa(Vector256<float> value, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+            public static Vector128<double> PermuteVar2x64x2(Vector128<double> lower, Vector128<long> indices, Vector128<double> upper);
+            public static Vector128<long> PermuteVar2x64x2(Vector128<long> lower, Vector128<long> indices, Vector128<long> upper);
+            public static Vector128<ulong> PermuteVar2x64x2(Vector128<ulong> lower, Vector128<ulong> indices, Vector128<ulong> upper);
+            public static Vector128<int> PermuteVar4x32x2(Vector128<int> lower, Vector128<int> indices, Vector128<int> upper);
+            public static Vector128<float> PermuteVar4x32x2(Vector128<float> lower, Vector128<int> indices, Vector128<float> upper);
+            public static Vector128<uint> PermuteVar4x32x2(Vector128<uint> lower, Vector128<uint> indices, Vector128<uint> upper);
+            public static Vector256<double> PermuteVar4x64x2(Vector256<double> lower, Vector256<long> indices, Vector256<double> upper);
+            public static Vector256<long> PermuteVar4x64x2(Vector256<long> lower, Vector256<long> indices, Vector256<long> upper);
+            public static Vector256<ulong> PermuteVar4x64x2(Vector256<ulong> lower, Vector256<ulong> indices, Vector256<ulong> upper);
+            public static Vector256<int> PermuteVar8x32x2(Vector256<int> lower, Vector256<int> indices, Vector256<int> upper);
+            public static Vector256<float> PermuteVar8x32x2(Vector256<float> lower, Vector256<int> indices, Vector256<float> upper);
+            public static Vector256<uint> PermuteVar8x32x2(Vector256<uint> lower, Vector256<uint> indices, Vector256<uint> upper);
+            public static Vector128<double> Reciprocal14(Vector128<double> value);
+            public static Vector128<float> Reciprocal14(Vector128<float> value);
+            public static Vector256<double> Reciprocal14(Vector256<double> value);
+            public static Vector256<float> Reciprocal14(Vector256<float> value);
+            public static Vector128<double> ReciprocalSqrt14(Vector128<double> value);
+            public static Vector128<float> ReciprocalSqrt14(Vector128<float> value);
+            public static Vector256<double> ReciprocalSqrt14(Vector256<double> value);
+            public static Vector256<float> ReciprocalSqrt14(Vector256<float> value);
+            public static Vector128<int> RotateLeft(Vector128<int> value, [ConstantExpectedAttribute] byte count);
+            public static Vector128<long> RotateLeft(Vector128<long> value, [ConstantExpectedAttribute] byte count);
+            public static Vector128<uint> RotateLeft(Vector128<uint> value, [ConstantExpectedAttribute] byte count);
+            public static Vector128<ulong> RotateLeft(Vector128<ulong> value, [ConstantExpectedAttribute] byte count);
+            public static Vector256<int> RotateLeft(Vector256<int> value, [ConstantExpectedAttribute] byte count);
+            public static Vector256<long> RotateLeft(Vector256<long> value, [ConstantExpectedAttribute] byte count);
+            public static Vector256<uint> RotateLeft(Vector256<uint> value, [ConstantExpectedAttribute] byte count);
+            public static Vector256<ulong> RotateLeft(Vector256<ulong> value, [ConstantExpectedAttribute] byte count);
+            public static Vector128<int> RotateLeftVariable(Vector128<int> value, Vector128<uint> count);
+            public static Vector128<long> RotateLeftVariable(Vector128<long> value, Vector128<ulong> count);
+            public static Vector128<uint> RotateLeftVariable(Vector128<uint> value, Vector128<uint> count);
+            public static Vector128<ulong> RotateLeftVariable(Vector128<ulong> value, Vector128<ulong> count);
+            public static Vector256<int> RotateLeftVariable(Vector256<int> value, Vector256<uint> count);
+            public static Vector256<long> RotateLeftVariable(Vector256<long> value, Vector256<ulong> count);
+            public static Vector256<uint> RotateLeftVariable(Vector256<uint> value, Vector256<uint> count);
+            public static Vector256<ulong> RotateLeftVariable(Vector256<ulong> value, Vector256<ulong> count);
+            public static Vector128<int> RotateRight(Vector128<int> value, [ConstantExpectedAttribute] byte count);
+            public static Vector128<long> RotateRight(Vector128<long> value, [ConstantExpectedAttribute] byte count);
+            public static Vector128<uint> RotateRight(Vector128<uint> value, [ConstantExpectedAttribute] byte count);
+            public static Vector128<ulong> RotateRight(Vector128<ulong> value, [ConstantExpectedAttribute] byte count);
+            public static Vector256<int> RotateRight(Vector256<int> value, [ConstantExpectedAttribute] byte count);
+            public static Vector256<long> RotateRight(Vector256<long> value, [ConstantExpectedAttribute] byte count);
+            public static Vector256<uint> RotateRight(Vector256<uint> value, [ConstantExpectedAttribute] byte count);
+            public static Vector256<ulong> RotateRight(Vector256<ulong> value, [ConstantExpectedAttribute] byte count);
+            public static Vector128<int> RotateRightVariable(Vector128<int> value, Vector128<uint> count);
+            public static Vector128<long> RotateRightVariable(Vector128<long> value, Vector128<ulong> count);
+            public static Vector128<uint> RotateRightVariable(Vector128<uint> value, Vector128<uint> count);
+            public static Vector128<ulong> RotateRightVariable(Vector128<ulong> value, Vector128<ulong> count);
+            public static Vector256<int> RotateRightVariable(Vector256<int> value, Vector256<uint> count);
+            public static Vector256<long> RotateRightVariable(Vector256<long> value, Vector256<ulong> count);
+            public static Vector256<uint> RotateRightVariable(Vector256<uint> value, Vector256<uint> count);
+            public static Vector256<ulong> RotateRightVariable(Vector256<ulong> value, Vector256<ulong> count);
+            public static Vector128<double> RoundScale(Vector128<double> value, [ConstantExpectedAttribute] byte control);
+            public static Vector128<float> RoundScale(Vector128<float> value, [ConstantExpectedAttribute] byte control);
+            public static Vector256<double> RoundScale(Vector256<double> value, [ConstantExpectedAttribute] byte control);
+            public static Vector256<float> RoundScale(Vector256<float> value, [ConstantExpectedAttribute] byte control);
+            public static Vector128<double> Scale(Vector128<double> left, Vector128<double> right);
+            public static Vector128<float> Scale(Vector128<float> left, Vector128<float> right);
+            public static Vector256<double> Scale(Vector256<double> left, Vector256<double> right);
+            public static Vector256<float> Scale(Vector256<float> left, Vector256<float> right);
+            public static Vector256<double> Shuffle2x128(Vector256<double> left, Vector256<double> right, [ConstantExpectedAttribute] byte control);
+            public static Vector256<int> Shuffle2x128(Vector256<int> left, Vector256<int> right, [ConstantExpectedAttribute] byte control);
+            public static Vector256<long> Shuffle2x128(Vector256<long> left, Vector256<long> right, [ConstantExpectedAttribute] byte control);
+            public static Vector256<float> Shuffle2x128(Vector256<float> left, Vector256<float> right, [ConstantExpectedAttribute] byte control);
+            public static Vector256<uint> Shuffle2x128(Vector256<uint> left, Vector256<uint> right, [ConstantExpectedAttribute] byte control);
+            public static Vector256<ulong> Shuffle2x128(Vector256<ulong> left, Vector256<ulong> right, [ConstantExpectedAttribute] byte control);
+            public static Vector128<byte> TernaryLogic(Vector128<byte> a, Vector128<byte> b, Vector128<byte> c, [ConstantExpectedAttribute] byte control);
+            public static Vector128<double> TernaryLogic(Vector128<double> a, Vector128<double> b, Vector128<double> c, [ConstantExpectedAttribute] byte control);
+            public static Vector128<short> TernaryLogic(Vector128<short> a, Vector128<short> b, Vector128<short> c, [ConstantExpectedAttribute] byte control);
+            public static Vector128<int> TernaryLogic(Vector128<int> a, Vector128<int> b, Vector128<int> c, [ConstantExpectedAttribute] byte control);
+            public static Vector128<long> TernaryLogic(Vector128<long> a, Vector128<long> b, Vector128<long> c, [ConstantExpectedAttribute] byte control);
+            public static Vector128<sbyte> TernaryLogic(Vector128<sbyte> a, Vector128<sbyte> b, Vector128<sbyte> c, [ConstantExpectedAttribute] byte control);
+            public static Vector128<float> TernaryLogic(Vector128<float> a, Vector128<float> b, Vector128<float> c, [ConstantExpectedAttribute] byte control);
+            public static Vector128<ushort> TernaryLogic(Vector128<ushort> a, Vector128<ushort> b, Vector128<ushort> c, [ConstantExpectedAttribute] byte control);
+            public static Vector128<uint> TernaryLogic(Vector128<uint> a, Vector128<uint> b, Vector128<uint> c, [ConstantExpectedAttribute] byte control);
+            public static Vector128<ulong> TernaryLogic(Vector128<ulong> a, Vector128<ulong> b, Vector128<ulong> c, [ConstantExpectedAttribute] byte control);
+            public static Vector256<byte> TernaryLogic(Vector256<byte> a, Vector256<byte> b, Vector256<byte> c, [ConstantExpectedAttribute] byte control);
+            public static Vector256<double> TernaryLogic(Vector256<double> a, Vector256<double> b, Vector256<double> c, [ConstantExpectedAttribute] byte control);
+            public static Vector256<short> TernaryLogic(Vector256<short> a, Vector256<short> b, Vector256<short> c, [ConstantExpectedAttribute] byte control);
+            public static Vector256<int> TernaryLogic(Vector256<int> a, Vector256<int> b, Vector256<int> c, [ConstantExpectedAttribute] byte control);
+            public static Vector256<long> TernaryLogic(Vector256<long> a, Vector256<long> b, Vector256<long> c, [ConstantExpectedAttribute] byte control);
+            public static Vector256<sbyte> TernaryLogic(Vector256<sbyte> a, Vector256<sbyte> b, Vector256<sbyte> c, [ConstantExpectedAttribute] byte control);
+            public static Vector256<float> TernaryLogic(Vector256<float> a, Vector256<float> b, Vector256<float> c, [ConstantExpectedAttribute] byte control);
+            public static Vector256<ushort> TernaryLogic(Vector256<ushort> a, Vector256<ushort> b, Vector256<ushort> c, [ConstantExpectedAttribute] byte control);
+            public static Vector256<uint> TernaryLogic(Vector256<uint> a, Vector256<uint> b, Vector256<uint> c, [ConstantExpectedAttribute] byte control);
+            public static Vector256<ulong> TernaryLogic(Vector256<ulong> a, Vector256<ulong> b, Vector256<ulong> c, [ConstantExpectedAttribute] byte control);
         }
     }
     [CLSCompliantAttribute(false)]
     public abstract class Avx512Vbmi : Avx512BW {
+        public static Vector512<byte> PermuteVar64x8x2(Vector512<byte> lower, Vector512<byte> indices, Vector512<byte> upper);
+        public static Vector512<sbyte> PermuteVar64x8x2(Vector512<sbyte> lower, Vector512<sbyte> indices, Vector512<sbyte> upper);
         public new abstract class VL : Avx512BW.VL {
+            public static Vector128<byte> PermuteVar16x8x2(Vector128<byte> lower, Vector128<byte> indices, Vector128<byte> upper);
+            public static Vector128<sbyte> PermuteVar16x8x2(Vector128<sbyte> lower, Vector128<sbyte> indices, Vector128<sbyte> upper);
+            public static Vector256<byte> PermuteVar32x8x2(Vector256<byte> lower, Vector256<byte> indices, Vector256<byte> upper);
+            public static Vector256<sbyte> PermuteVar32x8x2(Vector256<sbyte> lower, Vector256<sbyte> indices, Vector256<sbyte> upper);
         }
     }
 }
```

