# System.Security.Cryptography

``` diff
 namespace System.Security.Cryptography {
     [UnsupportedOSPlatformAttribute("browser")]
     [UnsupportedOSPlatformAttribute("ios")]
     [UnsupportedOSPlatformAttribute("tvos")]
     public sealed class AesGcm : IDisposable {
-        public AesGcm(byte[] key);
+        [ObsoleteAttribute("AesGcm should indicate the required tag size for encryption and decryption. Use a constructor that accepts the tag size.", DiagnosticId="SYSLIB0053", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public AesGcm(byte[] key);
+        public AesGcm(byte[] key, int tagSizeInBytes);
-        public AesGcm(ReadOnlySpan<byte> key);
+        [ObsoleteAttribute("AesGcm should indicate the required tag size for encryption and decryption. Use a constructor that accepts the tag size.", DiagnosticId="SYSLIB0053", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public AesGcm(ReadOnlySpan<byte> key);
+        public AesGcm(ReadOnlySpan<byte> key, int tagSizeInBytes);
+        public int? TagSizeInBytes { get; }
     }
 }
```

