# System.Windows.Forms

``` diff
 namespace System.Windows.Forms {
     public class AutoCompleteStringCollection : ICollection, IEnumerable, IList {
         bool System.Collections.IList.IsFixedSize { get; }
         bool System.Collections.IList.IsReadOnly { get; }
-        object System.Collections.IList.this[int index] { get; set; }
+        object? System.Collections.IList.this[int index] { get; set; }
-        public event CollectionChangeEventHandler CollectionChanged;
+        public event CollectionChangeEventHandler? CollectionChanged;
-        int IList.Add(object value);
+        int IList.Add(object? value);
-        bool IList.Contains(object value);
+        bool IList.Contains(object? value);
-        int IList.IndexOf(object value);
+        int IList.IndexOf(object? value);
-        void IList.Insert(int index, object value);
+        void IList.Insert(int index, object? value);
-        void IList.Remove(object value);
+        void IList.Remove(object? value);
     }
     public abstract class BindingManagerBase {
-        public abstract object Current { get; }
+        public abstract object? Current { get; }
     }
     [DefaultPropertyAttribute("Text")]
     [DesignTimeVisibleAttribute(false)]
     [ToolboxItemAttribute(false)]
     [TypeConverterAttribute(typeof(ListViewItemConverter))]
     public class ListViewItem : ICloneable, IKeyboardToolTip, ISerializable {
-        public ListViewItem(ListViewItem.ListViewSubItem[] subItems, int imageIndex, ListViewGroup group);
+        public ListViewItem(ListViewItem.ListViewSubItem[] subItems, int imageIndex, ListViewGroup? group);
-        public ListViewItem(ListViewItem.ListViewSubItem[] subItems, string imageKey);
+        public ListViewItem(ListViewItem.ListViewSubItem[] subItems, string? imageKey);
-        public ListViewItem(string[] items);
+        public ListViewItem(string[]? items);
-        public ListViewItem(string[] items, int imageIndex);
+        public ListViewItem(string[]? items, int imageIndex);
-        public ListViewItem(string[] items, int imageIndex, Color foreColor, Color backColor, Font font);
+        public ListViewItem(string[]? items, int imageIndex, Color foreColor, Color backColor, Font font);
-        public ListViewItem(string[] items, int imageIndex, Color foreColor, Color backColor, Font font, ListViewGroup group);
+        public ListViewItem(string[]? items, int imageIndex, Color foreColor, Color backColor, Font font, ListViewGroup group);
-        public ListViewItem(string[] items, int imageIndex, ListViewGroup group);
+        public ListViewItem(string[]? items, int imageIndex, ListViewGroup group);
-        public ListViewItem(string[] items, string imageKey);
+        public ListViewItem(string[]? items, string imageKey);
-        public ListViewItem(string[] items, string imageKey, Color foreColor, Color backColor, Font font);
+        public ListViewItem(string[]? items, string imageKey, Color foreColor, Color backColor, Font font);
-        public ListViewItem(string[] items, string imageKey, Color foreColor, Color backColor, Font font, ListViewGroup group);
+        public ListViewItem(string[]? items, string imageKey, Color foreColor, Color backColor, Font font, ListViewGroup group);
-        public ListViewItem(string[] items, string imageKey, ListViewGroup group);
+        public ListViewItem(string[]? items, string imageKey, ListViewGroup group);
-        public ListViewItem(string[] items, ListViewGroup group);
+        public ListViewItem(string[]? items, ListViewGroup group);
-        [DesignerSerializationVisibilityAttribute(0)]
-        [LocalizableAttribute(true)]
-        [SRCategoryAttribute("CatAppearance")]
-        public Font Font { get; set; }
+        [DesignerSerializationVisibilityAttribute(0)]
+        [LocalizableAttribute(true)]
+        [SRCategoryAttribute("CatAppearance")]
+        [AllowNullAttribute]
+        public Font Font { get; set; }
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [LocalizableAttribute(true)]
-        public string Name { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [LocalizableAttribute(true)]
+        [AllowNullAttribute]
+        public string Name { get; set; }
         [DefaultPropertyAttribute("Text")]
         [DesignTimeVisibleAttribute(false)]
         [ToolboxItemAttribute(false)]
         [TypeConverterAttribute(typeof(ListViewSubItemConverter))]
         public class ListViewSubItem {
-            [LocalizableAttribute(true)]
-            public Font Font { get; set; }
+            [LocalizableAttribute(true)]
+            [AllowNullAttribute]
+            public Font Font { get; set; }
         }
     }
     public class PropertyManager : BindingManagerBase {
-        public override object Current { get; }
+        public override object? Current { get; }
-        protected internal override string GetListName(ArrayList listAccessors);
+        protected internal override string GetListName(ArrayList? listAccessors);
     }
     [DefaultEventAttribute("SelectedIndexChanged")]
     [DefaultPropertyAttribute("TabPages")]
     [DesignerAttribute("System.Windows.Forms.Design.TabControlDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [SRDescriptionAttribute("DescriptionTabControl")]
     public class TabControl : Control {
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public override Image BackgroundImage { get; set; }
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public override Image? BackgroundImage { get; set; }
-        [DefaultValueAttribute(null)]
-        [RefreshPropertiesAttribute(2)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("TabBaseImageListDescr")]
-        public ImageList ImageList { get; set; }
+        [DefaultValueAttribute(null)]
+        [RefreshPropertiesAttribute(2)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("TabBaseImageListDescr")]
+        public ImageList? ImageList { get; set; }
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [SRCategoryAttribute("CatAppearance")]
-        [SRDescriptionAttribute("TabControlSelectedTabDescr")]
-        public TabPage SelectedTab { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [SRCategoryAttribute("CatAppearance")]
+        [SRDescriptionAttribute("TabControlSelectedTabDescr")]
+        public TabPage? SelectedTab { get; set; }
-        [BindableAttribute(false)]
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public override string Text { get; set; }
+        [BindableAttribute(false)]
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler BackColorChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? BackColorChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler BackgroundImageChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? BackgroundImageChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler BackgroundImageLayoutChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? BackgroundImageLayoutChanged;
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("TabControlDeselectedEventDescr")]
-        public event TabControlEventHandler Deselected;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("TabControlDeselectedEventDescr")]
+        public event TabControlEventHandler? Deselected;
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("TabControlDeselectingEventDescr")]
-        public event TabControlCancelEventHandler Deselecting;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("TabControlDeselectingEventDescr")]
+        public event TabControlCancelEventHandler? Deselecting;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("drawItemEventDescr")]
-        public event DrawItemEventHandler DrawItem;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("drawItemEventDescr")]
+        public event DrawItemEventHandler? DrawItem;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler ForeColorChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? ForeColorChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event PaintEventHandler Paint;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event PaintEventHandler? Paint;
-        [SRCategoryAttribute("CatPropertyChanged")]
-        [SRDescriptionAttribute("ControlOnRightToLeftLayoutChangedDescr")]
-        public event EventHandler RightToLeftLayoutChanged;
+        [SRCategoryAttribute("CatPropertyChanged")]
+        [SRDescriptionAttribute("ControlOnRightToLeftLayoutChangedDescr")]
+        public event EventHandler? RightToLeftLayoutChanged;
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("TabControlSelectedEventDescr")]
-        public event TabControlEventHandler Selected;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("TabControlSelectedEventDescr")]
+        public event TabControlEventHandler? Selected;
-        [SRCategoryAttribute("CatBehavior")]
-        [SRDescriptionAttribute("selectedIndexChangedEventDescr")]
-        public event EventHandler SelectedIndexChanged;
+        [SRCategoryAttribute("CatBehavior")]
+        [SRDescriptionAttribute("selectedIndexChangedEventDescr")]
+        public event EventHandler? SelectedIndexChanged;
-        [SRCategoryAttribute("CatAction")]
-        [SRDescriptionAttribute("TabControlSelectingEventDescr")]
-        public event TabControlCancelEventHandler Selecting;
+        [SRCategoryAttribute("CatAction")]
+        [SRDescriptionAttribute("TabControlSelectingEventDescr")]
+        public event TabControlCancelEventHandler? Selecting;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler TextChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? TextChanged;
     }
+    public class TaskDialogLinkClickedEventArgs : EventArgs {
+        public TaskDialogLinkClickedEventArgs(string linkHref);
+        public string LinkHref { get; }
+    }
     public class TaskDialogPage {
+        public bool EnableLinks { get; set; }
+        public event EventHandler<TaskDialogLinkClickedEventArgs>? LinkClicked;
+        protected internal void OnLinkClicked(TaskDialogLinkClickedEventArgs e);
     }
     [EditorAttribute("System.Windows.Forms.Design.ToolStripCollectionEditor, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor))]
     [ListBindableAttribute(false)]
     public class ToolStripItemCollection : ArrangedElementCollection, ICollection, IEnumerable, IList {
-        bool System.Collections.IList.IsFixedSize { get; }
+        bool IList.IsFixedSize { get; }
-        object System.Collections.IList.this[int index] { get; set; }
+        object? IList.this[int index] { get; set; }
-        public virtual ToolStripItem this[string key] { get; }
+        public virtual ToolStripItem? this[string? key] { get; }
-        public ToolStripItem Add(Image image);
+        public ToolStripItem Add(Image? image);
-        public ToolStripItem Add(string text);
+        public ToolStripItem Add(string? text);
-        public ToolStripItem Add(string text, Image image);
+        public ToolStripItem Add(string? text, Image? image);
-        public ToolStripItem Add(string text, Image image, EventHandler onClick);
+        public ToolStripItem Add(string? text, Image? image, EventHandler? onClick);
-        public virtual bool ContainsKey(string key);
+        public virtual bool ContainsKey(string? key);
-        public virtual int IndexOfKey(string key);
+        public virtual int IndexOfKey(string? key);
-        public virtual void RemoveByKey(string key);
+        public virtual void RemoveByKey(string? key);
-        int IList.Add(object value);
+        int IList.Add(object? value);
-        bool IList.Contains(object value);
+        bool IList.Contains(object? value);
-        int IList.IndexOf(object value);
+        int IList.IndexOf(object? value);
-        void IList.Insert(int index, object value);
+        void IList.Insert(int index, object? value);
-        void IList.Remove(object value);
+        void IList.Remove(object? value);
     }
     [DesignerAttribute("System.Windows.Forms.Design.ToolStripPanelDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [ToolboxBitmapAttribute(typeof(ToolStripPanel), "ToolStripPanel_standalone")]
     public class ToolStripPanel : ContainerControl, IArrangedElement, IComponent, IDisposable {
         [ListBindableAttribute(false)]
         public class ToolStripPanelRowCollection : ArrangedElementCollection, ICollection, IEnumerable, IList {
-            bool System.Collections.IList.IsFixedSize { get; }
+            bool IList.IsFixedSize { get; }
-            bool System.Collections.IList.IsReadOnly { get; }
+            bool IList.IsReadOnly { get; }
-            object System.Collections.IList.this[int index] { get; set; }
+            object? IList.this[int index] { get; set; }
-            int IList.Add(object value);
+            int IList.Add(object? value);
-            bool IList.Contains(object value);
+            bool IList.Contains(object? value);
-            int IList.IndexOf(object value);
+            int IList.IndexOf(object? value);
-            void IList.Insert(int index, object value);
+            void IList.Insert(int index, object? value);
-            void IList.Remove(object value);
+            void IList.Remove(object? value);
         }
     }
     [DefaultEventAttribute("Popup")]
     [ProvidePropertyAttribute("ToolTip", typeof(Control))]
     [SRDescriptionAttribute("DescriptionToolTip")]
     [ToolboxItemFilterAttribute("System.Windows.Forms")]
     public class ToolTip : Component, IExtenderProvider, IHandle, IHandle<HWND> {
-        public void SetToolTip(Control control, string caption);
+        public void SetToolTip(Control control, string? caption);
-        public void Show(string text, IWin32Window window);
+        public void Show(string? text, IWin32Window window);
-        public void Show(string text, IWin32Window window, Point point);
+        public void Show(string? text, IWin32Window window, Point point);
-        public void Show(string text, IWin32Window window, Point point, int duration);
+        public void Show(string? text, IWin32Window window, Point point, int duration);
-        public void Show(string text, IWin32Window window, int duration);
+        public void Show(string? text, IWin32Window window, int duration);
-        public void Show(string text, IWin32Window window, int x, int y);
+        public void Show(string? text, IWin32Window window, int x, int y);
-        public void Show(string text, IWin32Window window, int x, int y, int duration);
+        public void Show(string? text, IWin32Window window, int x, int y, int duration);
     }
 }
```

