# Microsoft.AspNetCore.Builder

``` diff
 namespace Microsoft.AspNetCore.Builder {
-    public class ApplicationBuilder : IApplicationBuilder
+    [DebuggerDisplayAttribute("Middleware = {MiddlewareCount}")]
+    [DebuggerTypeProxyAttribute(typeof(ApplicationBuilder.ApplicationBuilderDebugView))]
+    public class ApplicationBuilder : IApplicationBuilder
-    public sealed class WebApplication : IApplicationBuilder, IAsyncDisposable, IDisposable, IEndpointRouteBuilder, IHost
+    [DebuggerDisplayAttribute("{DebuggerToString(),nq}")]
+    [DebuggerTypeProxyAttribute(typeof(WebApplication.WebApplicationDebugView))]
+    public sealed class WebApplication : IApplicationBuilder, IAsyncDisposable, IDisposable, IEndpointRouteBuilder, IHost
-    public sealed class WebApplicationBuilder {
+    public sealed class WebApplicationBuilder : IHostApplicationBuilder {
+        IConfigurationManager IHostApplicationBuilder.Configuration { get; }
+        IHostEnvironment IHostApplicationBuilder.Environment { get; }
+        IDictionary<object, object> IHostApplicationBuilder.Properties { get; }
+        void IHostApplicationBuilder.ConfigureContainer<TContainerBuilder>(IServiceProviderFactory<TContainerBuilder> factory, Action<TContainerBuilder> configure);
     }
 }
```

