# Microsoft.AspNetCore.Components.Binding

``` diff
+namespace Microsoft.AspNetCore.Components.Binding {
+    public sealed class CascadingFormModelBindingProvider : CascadingModelBindingProvider {
+        public CascadingFormModelBindingProvider(IFormValueSupplier formValueSupplier);
+        protected internal override bool AreValuesFixed { get; }
+        protected internal override bool CanSupplyValue(ModelBindingContext? bindingContext, in CascadingParameterInfo parameterInfo);
+        protected internal override object? GetCurrentValue(ModelBindingContext? bindingContext, in CascadingParameterInfo parameterInfo);
+        protected internal override bool SupportsCascadingParameterAttributeType(Type attributeType);
+        protected internal override bool SupportsParameterType(Type type);
+    }
+    public abstract class CascadingModelBindingProvider {
+        protected CascadingModelBindingProvider();
+        protected internal abstract bool AreValuesFixed { get; }
+        protected internal abstract bool CanSupplyValue(ModelBindingContext? bindingContext, in CascadingParameterInfo parameterInfo);
+        protected internal abstract object? GetCurrentValue(ModelBindingContext? bindingContext, in CascadingParameterInfo parameterInfo);
+        protected internal virtual void Subscribe(ComponentState subscriber);
+        protected internal abstract bool SupportsCascadingParameterAttributeType(Type attributeType);
+        protected internal abstract bool SupportsParameterType(Type parameterType);
+        protected internal virtual void Unsubscribe(ComponentState subscriber);
+    }
+    public sealed class CascadingQueryModelBindingProvider : CascadingModelBindingProvider, IDisposable {
+        public CascadingQueryModelBindingProvider(NavigationManager navigationManager);
+        protected internal override bool AreValuesFixed { get; }
+        protected internal override bool CanSupplyValue(ModelBindingContext? bindingContext, in CascadingParameterInfo parameterInfo);
+        protected internal override object? GetCurrentValue(ModelBindingContext? bindingContext, in CascadingParameterInfo parameterInfo);
+        protected internal override void Subscribe(ComponentState subscriber);
+        protected internal override bool SupportsCascadingParameterAttributeType(Type attributeType);
+        protected internal override bool SupportsParameterType(Type type);
+        void IDisposable.Dispose();
+        protected internal override void Unsubscribe(ComponentState subscriber);
+    }
+    public class FormValueSupplierContext {
+        public FormValueSupplierContext(string formName, Type valueType, string parameterName);
+        public string FormName { get; }
+        public Action<string, object>? MapErrorToContainer { get; set; }
+        public Action<string, FormattableString, string?>? OnError { get; set; }
+        public string ParameterName { get; }
+        public object? Result { get; }
+        public Type ValueType { get; }
+        public void SetResult(object? result);
+    }
+    public interface IFormValueSupplier {
+        void Bind(FormValueSupplierContext context);
+        bool CanBind(Type valueType, string? formName = null);
+    }
+}
```

