# Microsoft.AspNetCore.Components.RenderTree

``` diff
 namespace Microsoft.AspNetCore.Components.RenderTree {
+    [FlagsAttribute]
+    public enum ComponentFrameFlags : byte {
+        HasCallerSpecifiedRenderMode = (byte)1,
+    }
     public abstract class Renderer : IAsyncDisposable, IDisposable {
-        protected internal virtual IComponent ResolveComponentForRenderMode(Type componentType, int? parentComponentId, IComponentActivator componentActivator, IComponentRenderMode componentTypeRenderMode);
+        protected internal virtual IComponent ResolveComponentForRenderMode(Type componentType, int? parentComponentId, IComponentActivator componentActivator, IComponentRenderMode renderMode);
     }
     public struct RenderTreeFrame {
+        public ComponentFrameFlags ComponentFrameFlags { get; }
+        public IComponentRenderMode ComponentRenderMode { get; }
     }
     public enum RenderTreeFrameType : short {
+        ComponentRenderMode = (short)9,
     }
 }
```

