# Microsoft.AspNetCore.Components

``` diff
 namespace Microsoft.AspNetCore.Components {
+    public class BindingError {
+        public string? AttemptedValue { get; }
+        public object Container { get; internal set; }
+        public IReadOnlyList<FormattableString> ErrorMessages { get; }
+        public string Name { get; }
+        public string Path { get; }
+    }
-    [AttributeUsageAttribute(128, AllowMultiple=false, Inherited=true)]
-    public sealed class CascadingParameterAttribute : Attribute {
+    [AttributeUsageAttribute(128, AllowMultiple=false, Inherited=true)]
+    public sealed class CascadingParameterAttribute : CascadingParameterAttributeBase {
-        public string Name { get; set; }
+        public override string Name { get; set; }
     }
+    public abstract class CascadingParameterAttributeBase : Attribute {
+        protected CascadingParameterAttributeBase();
+        public abstract string Name { get; set; }
+    }
+    public readonly struct CascadingParameterInfo {
+        public CascadingParameterAttributeBase Attribute { get; }
+        public string PropertyName { get; }
+        public Type PropertyType { get; }
+    }
     public sealed class ModelBindingContext {
+        public IEnumerable<BindingError> GetAllErrors();
+        public IEnumerable<BindingError> GetAllErrors(string formName);
+        public string? GetAttemptedValue(string key);
+        public string? GetAttemptedValue(string formName, string key);
+        public BindingError? GetErrors(string key);
+        public BindingError? GetErrors(string formName, string key);
     }
+    [AttributeUsageAttribute(128, AllowMultiple=false, Inherited=true)]
+    public sealed class SupplyParameterFromFormAttribute : CascadingParameterAttributeBase {
+        public SupplyParameterFromFormAttribute();
+        public override string Name { get; set; }
+    }
-    [AttributeUsageAttribute(128, AllowMultiple=false, Inherited=true)]
-    public sealed class SupplyParameterFromQueryAttribute : Attribute {
+    [AttributeUsageAttribute(128, AllowMultiple=false, Inherited=true)]
+    public sealed class SupplyParameterFromQueryAttribute : CascadingParameterAttributeBase {
-        public string Name { get; set; }
+        public override string Name { get; set; }
     }
 }
```

