# Microsoft.Extensions.Logging

``` diff
 namespace Microsoft.Extensions.Logging {
     [UnsupportedOSPlatformAttribute("browser")]
     public static class ConsoleLoggerExtensions {
+        [EditorBrowsableAttribute(1)]
+        [ObsoleteAttribute("This method is retained only for compatibility. The recommended alternative is AddConsole(this ILoggingBuilder builder).", true)]
+        public static ILoggerFactory AddConsole(this ILoggerFactory factory);
+        [EditorBrowsableAttribute(1)]
+        [ObsoleteAttribute("This method is retained only for compatibility. The recommended alternative is AddConsole(this ILoggingBuilder builder).", true)]
+        public static ILoggerFactory AddConsole(this ILoggerFactory factory, IConfiguration configuration);
+        [EditorBrowsableAttribute(1)]
+        [ObsoleteAttribute("This method is retained only for compatibility. The recommended alternative is AddConsole(this ILoggingBuilder builder).", true)]
+        public static ILoggerFactory AddConsole(this ILoggerFactory factory, IConsoleLoggerSettings settings);
+        [EditorBrowsableAttribute(1)]
+        [ObsoleteAttribute("This method is retained only for compatibility. The recommended alternative is AddConsole(this ILoggingBuilder builder).", true)]
+        public static ILoggerFactory AddConsole(this ILoggerFactory factory, LogLevel minLevel);
+        [EditorBrowsableAttribute(1)]
+        [ObsoleteAttribute("This method is retained only for compatibility. The recommended alternative is AddConsole(this ILoggingBuilder builder).", true)]
+        public static ILoggerFactory AddConsole(this ILoggerFactory factory, LogLevel minLevel, bool includeScopes);
+        [EditorBrowsableAttribute(1)]
+        [ObsoleteAttribute("This method is retained only for compatibility. The recommended alternative is AddConsole(this ILoggingBuilder builder).", true)]
+        public static ILoggerFactory AddConsole(this ILoggerFactory factory, bool includeScopes);
+        [EditorBrowsableAttribute(1)]
+        [ObsoleteAttribute("This method is retained only for compatibility. The recommended alternative is AddConsole(this ILoggingBuilder builder).", true)]
+        public static ILoggerFactory AddConsole(this ILoggerFactory factory, Func<string, LogLevel, bool> filter);
+        [EditorBrowsableAttribute(1)]
+        [ObsoleteAttribute("This method is retained only for compatibility. The recommended alternative is AddConsole(this ILoggingBuilder builder).", true)]
+        public static ILoggerFactory AddConsole(this ILoggerFactory factory, Func<string, LogLevel, bool> filter, bool includeScopes);
     }
     public static class DebugLoggerFactoryExtensions {
+        [EditorBrowsableAttribute(1)]
+        [ObsoleteAttribute("This method is retained only for compatibility. The recommended alternative is AddDebug(this ILoggingBuilder builder).", true)]
+        public static ILoggerFactory AddDebug(this ILoggerFactory factory);
+        [EditorBrowsableAttribute(1)]
+        [ObsoleteAttribute("This method is retained only for compatibility. The recommended alternative is AddDebug(this ILoggingBuilder builder).", true)]
+        public static ILoggerFactory AddDebug(this ILoggerFactory factory, LogLevel minLevel);
+        [EditorBrowsableAttribute(1)]
+        [ObsoleteAttribute("This method is retained only for compatibility. The recommended alternative is AddDebug(this ILoggingBuilder builder).", true)]
+        public static ILoggerFactory AddDebug(this ILoggerFactory factory, Func<string, LogLevel, bool> filter);
     }
     public static class EventLoggerFactoryExtensions {
+        [EditorBrowsableAttribute(1)]
+        [ObsoleteAttribute("This method is retained only for compatibility. The recommended alternative is AddEventLog(this ILoggingBuilder builder).", true)]
+        public static ILoggerFactory AddEventLog(this ILoggerFactory factory);
+        [EditorBrowsableAttribute(1)]
+        [ObsoleteAttribute("This method is retained only for compatibility. The recommended alternative is AddEventLog(this ILoggingBuilder builder).", true)]
+        public static ILoggerFactory AddEventLog(this ILoggerFactory factory, EventLogSettings settings);
+        [EditorBrowsableAttribute(1)]
+        [ObsoleteAttribute("This method is retained only for compatibility. The recommended alternative is AddEventLog(this ILoggingBuilder builder).", true)]
+        public static ILoggerFactory AddEventLog(this ILoggerFactory factory, LogLevel minLevel);
     }
     public static class EventSourceLoggerFactoryExtensions {
+        [EditorBrowsableAttribute(1)]
+        [ObsoleteAttribute("This method is retained only for compatibility. The recommended alternative is AddEventSourceLogger(this ILoggingBuilder builder).", true)]
+        public static ILoggerFactory AddEventSourceLogger(this ILoggerFactory factory);
     }
     [AttributeUsageAttribute(64)]
     public sealed class LoggerMessageAttribute : Attribute {
+        public LoggerMessageAttribute(LogLevel level);
+        public LoggerMessageAttribute(LogLevel level, string message);
+        public LoggerMessageAttribute(string message);
     }
     public static class TraceSourceFactoryExtensions {
+        [EditorBrowsableAttribute(1)]
+        [ObsoleteAttribute("This method is retained only for compatibility. The recommended alternative is AddTraceSource(this ILoggingBuilder builder).", true)]
+        public static ILoggerFactory AddTraceSource(this ILoggerFactory factory, SourceSwitch sourceSwitch);
+        [EditorBrowsableAttribute(1)]
+        [ObsoleteAttribute("This method is retained only for compatibility. The recommended alternative is AddTraceSource(this ILoggingBuilder builder).", true)]
+        public static ILoggerFactory AddTraceSource(this ILoggerFactory factory, SourceSwitch sourceSwitch, TraceListener listener);
+        [EditorBrowsableAttribute(1)]
+        [ObsoleteAttribute("This method is retained only for compatibility. The recommended alternative is AddTraceSource(this ILoggingBuilder builder).", true)]
+        public static ILoggerFactory AddTraceSource(this ILoggerFactory factory, string switchName);
+        [EditorBrowsableAttribute(1)]
+        [ObsoleteAttribute("This method is retained only for compatibility. The recommended alternative is AddTraceSource(this ILoggingBuilder builder).", true)]
+        public static ILoggerFactory AddTraceSource(this ILoggerFactory factory, string switchName, TraceListener listener);
     }
 }
```

