# System.Numerics

``` diff
 namespace System.Numerics {
     public static class Vector {
-        public static Vector<T> Abs<T>(Vector<T> value) where T : struct;
+        public static Vector<T> Abs<T>(Vector<T> value);
-        public static Vector<T> Add<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> Add<T>(Vector<T> left, Vector<T> right);
-        public static Vector<T> AndNot<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> AndNot<T>(Vector<T> left, Vector<T> right);
-        public static Vector<TTo> As<TFrom, TTo>(this Vector<TFrom> vector) where TFrom : struct where TTo : struct;
+        public static Vector<TTo> As<TFrom, TTo>(this Vector<TFrom> vector);
-        public static Vector<byte> AsVectorByte<T>(Vector<T> value) where T : struct;
+        public static Vector<byte> AsVectorByte<T>(Vector<T> value);
-        public static Vector<double> AsVectorDouble<T>(Vector<T> value) where T : struct;
+        public static Vector<double> AsVectorDouble<T>(Vector<T> value);
-        public static Vector<short> AsVectorInt16<T>(Vector<T> value) where T : struct;
+        public static Vector<short> AsVectorInt16<T>(Vector<T> value);
-        public static Vector<int> AsVectorInt32<T>(Vector<T> value) where T : struct;
+        public static Vector<int> AsVectorInt32<T>(Vector<T> value);
-        public static Vector<long> AsVectorInt64<T>(Vector<T> value) where T : struct;
+        public static Vector<long> AsVectorInt64<T>(Vector<T> value);
-        public static Vector<IntPtr> AsVectorNInt<T>(Vector<T> value) where T : struct;
+        public static Vector<IntPtr> AsVectorNInt<T>(Vector<T> value);
-        [CLSCompliantAttribute(false)]
-        public static Vector<UIntPtr> AsVectorNUInt<T>(Vector<T> value) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector<UIntPtr> AsVectorNUInt<T>(Vector<T> value);
-        [CLSCompliantAttribute(false)]
-        public static Vector<sbyte> AsVectorSByte<T>(Vector<T> value) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector<sbyte> AsVectorSByte<T>(Vector<T> value);
-        public static Vector<float> AsVectorSingle<T>(Vector<T> value) where T : struct;
+        public static Vector<float> AsVectorSingle<T>(Vector<T> value);
-        [CLSCompliantAttribute(false)]
-        public static Vector<ushort> AsVectorUInt16<T>(Vector<T> value) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector<ushort> AsVectorUInt16<T>(Vector<T> value);
-        [CLSCompliantAttribute(false)]
-        public static Vector<uint> AsVectorUInt32<T>(Vector<T> value) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector<uint> AsVectorUInt32<T>(Vector<T> value);
-        [CLSCompliantAttribute(false)]
-        public static Vector<ulong> AsVectorUInt64<T>(Vector<T> value) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector<ulong> AsVectorUInt64<T>(Vector<T> value);
-        public static Vector<T> BitwiseAnd<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> BitwiseAnd<T>(Vector<T> left, Vector<T> right);
-        public static Vector<T> BitwiseOr<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> BitwiseOr<T>(Vector<T> left, Vector<T> right);
-        public static Vector<T> ConditionalSelect<T>(Vector<T> condition, Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> ConditionalSelect<T>(Vector<T> condition, Vector<T> left, Vector<T> right);
-        public static Vector<T> Divide<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> Divide<T>(Vector<T> left, Vector<T> right);
-        public static Vector<T> Divide<T>(Vector<T> left, T right) where T : struct;
+        public static Vector<T> Divide<T>(Vector<T> left, T right);
-        public static T Dot<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static T Dot<T>(Vector<T> left, Vector<T> right);
-        public static Vector<T> Equals<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> Equals<T>(Vector<T> left, Vector<T> right);
-        public static bool EqualsAll<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static bool EqualsAll<T>(Vector<T> left, Vector<T> right);
-        public static bool EqualsAny<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static bool EqualsAny<T>(Vector<T> left, Vector<T> right);
-        public static T GetElement<T>(this Vector<T> vector, int index) where T : struct;
+        public static T GetElement<T>(this Vector<T> vector, int index);
-        public static Vector<T> GreaterThan<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> GreaterThan<T>(Vector<T> left, Vector<T> right);
-        public static bool GreaterThanAll<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static bool GreaterThanAll<T>(Vector<T> left, Vector<T> right);
-        public static bool GreaterThanAny<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static bool GreaterThanAny<T>(Vector<T> left, Vector<T> right);
-        public static Vector<T> GreaterThanOrEqual<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> GreaterThanOrEqual<T>(Vector<T> left, Vector<T> right);
-        public static bool GreaterThanOrEqualAll<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static bool GreaterThanOrEqualAll<T>(Vector<T> left, Vector<T> right);
-        public static bool GreaterThanOrEqualAny<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static bool GreaterThanOrEqualAny<T>(Vector<T> left, Vector<T> right);
-        public static Vector<T> LessThan<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> LessThan<T>(Vector<T> left, Vector<T> right);
-        public static bool LessThanAll<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static bool LessThanAll<T>(Vector<T> left, Vector<T> right);
-        public static bool LessThanAny<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static bool LessThanAny<T>(Vector<T> left, Vector<T> right);
-        public static Vector<T> LessThanOrEqual<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> LessThanOrEqual<T>(Vector<T> left, Vector<T> right);
-        public static bool LessThanOrEqualAll<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static bool LessThanOrEqualAll<T>(Vector<T> left, Vector<T> right);
-        public static bool LessThanOrEqualAny<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static bool LessThanOrEqualAny<T>(Vector<T> left, Vector<T> right);
-        [CLSCompliantAttribute(false)]
-        public unsafe static Vector<T> Load<T>(T* source) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector<T> Load<T>(T* source);
-        [CLSCompliantAttribute(false)]
-        public unsafe static Vector<T> LoadAligned<T>(T* source) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector<T> LoadAligned<T>(T* source);
-        [CLSCompliantAttribute(false)]
-        public unsafe static Vector<T> LoadAlignedNonTemporal<T>(T* source) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector<T> LoadAlignedNonTemporal<T>(T* source);
-        public static Vector<T> LoadUnsafe<T>(ref T source) where T : struct;
+        public static Vector<T> LoadUnsafe<T>(ref T source);
-        [CLSCompliantAttribute(false)]
-        public static Vector<T> LoadUnsafe<T>(ref T source, UIntPtr elementOffset) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector<T> LoadUnsafe<T>(ref T source, UIntPtr elementOffset);
-        public static Vector<T> Max<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> Max<T>(Vector<T> left, Vector<T> right);
-        public static Vector<T> Min<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> Min<T>(Vector<T> left, Vector<T> right);
-        public static Vector<T> Multiply<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> Multiply<T>(Vector<T> left, Vector<T> right);
-        public static Vector<T> Multiply<T>(Vector<T> left, T right) where T : struct;
+        public static Vector<T> Multiply<T>(Vector<T> left, T right);
-        public static Vector<T> Multiply<T>(T left, Vector<T> right) where T : struct;
+        public static Vector<T> Multiply<T>(T left, Vector<T> right);
-        public static Vector<T> Negate<T>(Vector<T> value) where T : struct;
+        public static Vector<T> Negate<T>(Vector<T> value);
-        public static Vector<T> OnesComplement<T>(Vector<T> value) where T : struct;
+        public static Vector<T> OnesComplement<T>(Vector<T> value);
-        public static Vector<T> SquareRoot<T>(Vector<T> value) where T : struct;
+        public static Vector<T> SquareRoot<T>(Vector<T> value);
-        [CLSCompliantAttribute(false)]
-        public unsafe static void Store<T>(this Vector<T> source, T* destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static void Store<T>(this Vector<T> source, T* destination);
-        [CLSCompliantAttribute(false)]
-        public unsafe static void StoreAligned<T>(this Vector<T> source, T* destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static void StoreAligned<T>(this Vector<T> source, T* destination);
-        [CLSCompliantAttribute(false)]
-        public unsafe static void StoreAlignedNonTemporal<T>(this Vector<T> source, T* destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static void StoreAlignedNonTemporal<T>(this Vector<T> source, T* destination);
-        public static void StoreUnsafe<T>(this Vector<T> source, ref T destination) where T : struct;
+        public static void StoreUnsafe<T>(this Vector<T> source, ref T destination);
-        [CLSCompliantAttribute(false)]
-        public static void StoreUnsafe<T>(this Vector<T> source, ref T destination, UIntPtr elementOffset) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static void StoreUnsafe<T>(this Vector<T> source, ref T destination, UIntPtr elementOffset);
-        public static Vector<T> Subtract<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> Subtract<T>(Vector<T> left, Vector<T> right);
-        public static T Sum<T>(Vector<T> value) where T : struct;
+        public static T Sum<T>(Vector<T> value);
-        public static T ToScalar<T>(this Vector<T> vector) where T : struct;
+        public static T ToScalar<T>(this Vector<T> vector);
-        public static Vector<T> WithElement<T>(this Vector<T> vector, int index, T value) where T : struct;
+        public static Vector<T> WithElement<T>(this Vector<T> vector, int index, T value);
-        public static Vector<T> Xor<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> Xor<T>(Vector<T> left, Vector<T> right);
     }
-    public readonly struct Vector<T> : IEquatable<Vector<T>>, IFormattable where T : struct
+    public readonly struct Vector<T> : IEquatable<Vector<T>>, IFormattable
 }
```

