# System.Runtime.InteropServices.Marshalling

``` diff
 namespace System.Runtime.InteropServices.Marshalling {
     [CLSCompliantAttribute(false)]
     [CustomMarshallerAttribute(typeof(CustomMarshallerAttribute.GenericPlaceholder), MarshalMode.Default, typeof(ComInterfaceMarshaller<>))]
     [UnsupportedOSPlatformAttribute("android")]
     [UnsupportedOSPlatformAttribute("browser")]
     [UnsupportedOSPlatformAttribute("ios")]
     [UnsupportedOSPlatformAttribute("tvos")]
     public static class ComInterfaceMarshaller<T> {
+        public unsafe static void Free(void* unmanaged);
     }
+    [FlagsAttribute]
+    public enum ComInterfaceOptions {
+        ComObjectWrapper = 2,
+        ManagedObjectWrapper = 1,
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        None = 0,
+    }
     [AttributeUsageAttribute(AttributeTargets.Interface)]
     public class GeneratedComInterfaceAttribute : Attribute {
+        public ComInterfaceOptions Options { get; set; }
     }
     [CLSCompliantAttribute(false)]
     [CustomMarshallerAttribute(typeof(CustomMarshallerAttribute.GenericPlaceholder), MarshalMode.Default, typeof(UniqueComInterfaceMarshaller<>))]
     [UnsupportedOSPlatformAttribute("android")]
     [UnsupportedOSPlatformAttribute("browser")]
     [UnsupportedOSPlatformAttribute("ios")]
     [UnsupportedOSPlatformAttribute("tvos")]
     public static class UniqueComInterfaceMarshaller<T> {
+        public unsafe static void Free(void* unmanaged);
     }
 }
```

