# System.Runtime.Intrinsics.Wasm

``` diff
 namespace System.Runtime.Intrinsics.Wasm {
     [CLSCompliantAttribute(false)]
     public abstract class PackedSimd {
+        public unsafe static Vector128<byte> LoadScalarAndInsert(byte* address, Vector128<byte> vector, [ConstantExpectedAttribute(Max=(byte)15)] byte index);
+        public unsafe static Vector128<double> LoadScalarAndInsert(double* address, Vector128<double> vector, [ConstantExpectedAttribute(Max=(byte)1)] byte index);
+        public unsafe static Vector128<short> LoadScalarAndInsert(short* address, Vector128<short> vector, [ConstantExpectedAttribute(Max=(byte)7)] byte index);
+        public unsafe static Vector128<int> LoadScalarAndInsert(int* address, Vector128<int> vector, [ConstantExpectedAttribute(Max=(byte)3)] byte index);
+        public unsafe static Vector128<long> LoadScalarAndInsert(long* address, Vector128<long> vector, [ConstantExpectedAttribute(Max=(byte)1)] byte index);
+        public unsafe static Vector128<IntPtr> LoadScalarAndInsert(IntPtr* address, Vector128<IntPtr> vector, [ConstantExpectedAttribute(Max=(byte)3)] byte index);
+        public unsafe static Vector128<sbyte> LoadScalarAndInsert(sbyte* address, Vector128<sbyte> vector, [ConstantExpectedAttribute(Max=(byte)15)] byte index);
+        public unsafe static Vector128<float> LoadScalarAndInsert(float* address, Vector128<float> vector, [ConstantExpectedAttribute(Max=(byte)3)] byte index);
+        public unsafe static Vector128<ushort> LoadScalarAndInsert(ushort* address, Vector128<ushort> vector, [ConstantExpectedAttribute(Max=(byte)7)] byte index);
+        public unsafe static Vector128<uint> LoadScalarAndInsert(uint* address, Vector128<uint> vector, [ConstantExpectedAttribute(Max=(byte)3)] byte index);
+        public unsafe static Vector128<ulong> LoadScalarAndInsert(ulong* address, Vector128<ulong> vector, [ConstantExpectedAttribute(Max=(byte)1)] byte index);
+        public unsafe static Vector128<UIntPtr> LoadScalarAndInsert(UIntPtr* address, Vector128<UIntPtr> vector, [ConstantExpectedAttribute(Max=(byte)3)] byte index);
+        public unsafe static Vector128<byte> LoadScalarAndSplatVector128(byte* address);
+        public unsafe static Vector128<double> LoadScalarAndSplatVector128(double* address);
+        public unsafe static Vector128<short> LoadScalarAndSplatVector128(short* address);
+        public unsafe static Vector128<int> LoadScalarAndSplatVector128(int* address);
+        public unsafe static Vector128<long> LoadScalarAndSplatVector128(long* address);
+        public unsafe static Vector128<IntPtr> LoadScalarAndSplatVector128(IntPtr* address);
+        public unsafe static Vector128<sbyte> LoadScalarAndSplatVector128(sbyte* address);
+        public unsafe static Vector128<float> LoadScalarAndSplatVector128(float* address);
+        public unsafe static Vector128<ushort> LoadScalarAndSplatVector128(ushort* address);
+        public unsafe static Vector128<uint> LoadScalarAndSplatVector128(uint* address);
+        public unsafe static Vector128<ulong> LoadScalarAndSplatVector128(ulong* address);
+        public unsafe static Vector128<UIntPtr> LoadScalarAndSplatVector128(UIntPtr* address);
+        public unsafe static Vector128<double> LoadScalarVector128(double* address);
+        public unsafe static Vector128<int> LoadScalarVector128(int* address);
+        public unsafe static Vector128<long> LoadScalarVector128(long* address);
+        public unsafe static Vector128<IntPtr> LoadScalarVector128(IntPtr* address);
+        public unsafe static Vector128<float> LoadScalarVector128(float* address);
+        public unsafe static Vector128<uint> LoadScalarVector128(uint* address);
+        public unsafe static Vector128<ulong> LoadScalarVector128(ulong* address);
+        public unsafe static Vector128<UIntPtr> LoadScalarVector128(UIntPtr* address);
+        public unsafe static Vector128<byte> LoadVector128(byte* address);
+        public unsafe static Vector128<double> LoadVector128(double* address);
+        public unsafe static Vector128<short> LoadVector128(short* address);
+        public unsafe static Vector128<int> LoadVector128(int* address);
+        public unsafe static Vector128<long> LoadVector128(long* address);
+        public unsafe static Vector128<IntPtr> LoadVector128(IntPtr* address);
+        public unsafe static Vector128<sbyte> LoadVector128(sbyte* address);
+        public unsafe static Vector128<float> LoadVector128(float* address);
+        public unsafe static Vector128<ushort> LoadVector128(ushort* address);
+        public unsafe static Vector128<uint> LoadVector128(uint* address);
+        public unsafe static Vector128<ulong> LoadVector128(ulong* address);
+        public unsafe static Vector128<UIntPtr> LoadVector128(UIntPtr* address);
+        public unsafe static Vector128<ushort> LoadWideningVector128(byte* address);
+        public unsafe static Vector128<int> LoadWideningVector128(short* address);
+        public unsafe static Vector128<long> LoadWideningVector128(int* address);
+        public unsafe static Vector128<short> LoadWideningVector128(sbyte* address);
+        public unsafe static Vector128<uint> LoadWideningVector128(ushort* address);
+        public unsafe static Vector128<ulong> LoadWideningVector128(uint* address);
+        public unsafe static void Store(byte* address, Vector128<byte> source);
+        public unsafe static void Store(double* address, Vector128<double> source);
+        public unsafe static void Store(short* address, Vector128<short> source);
+        public unsafe static void Store(int* address, Vector128<int> source);
+        public unsafe static void Store(long* address, Vector128<long> source);
+        public unsafe static void Store(IntPtr* address, Vector128<IntPtr> source);
+        public unsafe static void Store(sbyte* address, Vector128<sbyte> source);
+        public unsafe static void Store(float* address, Vector128<float> source);
+        public unsafe static void Store(ushort* address, Vector128<ushort> source);
+        public unsafe static void Store(uint* address, Vector128<uint> source);
+        public unsafe static void Store(ulong* address, Vector128<ulong> source);
+        public unsafe static void Store(UIntPtr* address, Vector128<UIntPtr> source);
+        public unsafe static void StoreSelectedScalar(byte* address, Vector128<byte> source, [ConstantExpectedAttribute(Max=(byte)15)] byte index);
+        public unsafe static void StoreSelectedScalar(double* address, Vector128<double> source, [ConstantExpectedAttribute(Max=(byte)1)] byte index);
+        public unsafe static void StoreSelectedScalar(short* address, Vector128<short> source, [ConstantExpectedAttribute(Max=(byte)7)] byte index);
+        public unsafe static void StoreSelectedScalar(int* address, Vector128<int> source, [ConstantExpectedAttribute(Max=(byte)3)] byte index);
+        public unsafe static void StoreSelectedScalar(long* address, Vector128<long> source, [ConstantExpectedAttribute(Max=(byte)1)] byte index);
+        public unsafe static void StoreSelectedScalar(IntPtr* address, Vector128<IntPtr> source, [ConstantExpectedAttribute(Max=(byte)3)] byte index);
+        public unsafe static void StoreSelectedScalar(sbyte* address, Vector128<sbyte> source, [ConstantExpectedAttribute(Max=(byte)15)] byte index);
+        public unsafe static void StoreSelectedScalar(float* address, Vector128<float> source, [ConstantExpectedAttribute(Max=(byte)3)] byte index);
+        public unsafe static void StoreSelectedScalar(ushort* address, Vector128<ushort> source, [ConstantExpectedAttribute(Max=(byte)7)] byte index);
+        public unsafe static void StoreSelectedScalar(uint* address, Vector128<uint> source, [ConstantExpectedAttribute(Max=(byte)3)] byte index);
+        public unsafe static void StoreSelectedScalar(ulong* address, Vector128<ulong> source, [ConstantExpectedAttribute(Max=(byte)1)] byte index);
+        public unsafe static void StoreSelectedScalar(UIntPtr* address, Vector128<UIntPtr> source, [ConstantExpectedAttribute(Max=(byte)3)] byte index);
     }
 }
```

