# System.Runtime.Intrinsics

``` diff
 namespace System.Runtime.Intrinsics {
     public static class Vector128 {
-        public static Vector128<T> Abs<T>(Vector128<T> vector) where T : struct;
+        public static Vector128<T> Abs<T>(Vector128<T> vector);
-        public static Vector128<T> Add<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> Add<T>(Vector128<T> left, Vector128<T> right);
-        public static Vector128<T> AndNot<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> AndNot<T>(Vector128<T> left, Vector128<T> right);
-        public static Vector128<TTo> As<TFrom, TTo>(this Vector128<TFrom> vector) where TFrom : struct where TTo : struct;
+        public static Vector128<TTo> As<TFrom, TTo>(this Vector128<TFrom> vector);
-        public static Vector128<byte> AsByte<T>(this Vector128<T> vector) where T : struct;
+        public static Vector128<byte> AsByte<T>(this Vector128<T> vector);
-        public static Vector128<double> AsDouble<T>(this Vector128<T> vector) where T : struct;
+        public static Vector128<double> AsDouble<T>(this Vector128<T> vector);
-        public static Vector128<short> AsInt16<T>(this Vector128<T> vector) where T : struct;
+        public static Vector128<short> AsInt16<T>(this Vector128<T> vector);
-        public static Vector128<int> AsInt32<T>(this Vector128<T> vector) where T : struct;
+        public static Vector128<int> AsInt32<T>(this Vector128<T> vector);
-        public static Vector128<long> AsInt64<T>(this Vector128<T> vector) where T : struct;
+        public static Vector128<long> AsInt64<T>(this Vector128<T> vector);
-        public static Vector128<IntPtr> AsNInt<T>(this Vector128<T> vector) where T : struct;
+        public static Vector128<IntPtr> AsNInt<T>(this Vector128<T> vector);
-        [CLSCompliantAttribute(false)]
-        public static Vector128<UIntPtr> AsNUInt<T>(this Vector128<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector128<UIntPtr> AsNUInt<T>(this Vector128<T> vector);
-        [CLSCompliantAttribute(false)]
-        public static Vector128<sbyte> AsSByte<T>(this Vector128<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector128<sbyte> AsSByte<T>(this Vector128<T> vector);
-        public static Vector128<float> AsSingle<T>(this Vector128<T> vector) where T : struct;
+        public static Vector128<float> AsSingle<T>(this Vector128<T> vector);
-        [CLSCompliantAttribute(false)]
-        public static Vector128<ushort> AsUInt16<T>(this Vector128<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector128<ushort> AsUInt16<T>(this Vector128<T> vector);
-        [CLSCompliantAttribute(false)]
-        public static Vector128<uint> AsUInt32<T>(this Vector128<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector128<uint> AsUInt32<T>(this Vector128<T> vector);
-        [CLSCompliantAttribute(false)]
-        public static Vector128<ulong> AsUInt64<T>(this Vector128<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector128<ulong> AsUInt64<T>(this Vector128<T> vector);
-        public static Vector128<T> AsVector128<T>(this Vector<T> value) where T : struct;
+        public static Vector128<T> AsVector128<T>(this Vector<T> value);
-        public static Vector<T> AsVector<T>(this Vector128<T> value) where T : struct;
+        public static Vector<T> AsVector<T>(this Vector128<T> value);
-        public static Vector128<T> BitwiseAnd<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> BitwiseAnd<T>(Vector128<T> left, Vector128<T> right);
-        public static Vector128<T> BitwiseOr<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> BitwiseOr<T>(Vector128<T> left, Vector128<T> right);
-        public static Vector128<T> ConditionalSelect<T>(Vector128<T> condition, Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> ConditionalSelect<T>(Vector128<T> condition, Vector128<T> left, Vector128<T> right);
-        public static void CopyTo<T>(this Vector128<T> vector, Span<T> destination) where T : struct;
+        public static void CopyTo<T>(this Vector128<T> vector, Span<T> destination);
-        public static void CopyTo<T>(this Vector128<T> vector, T[] destination) where T : struct;
+        public static void CopyTo<T>(this Vector128<T> vector, T[] destination);
-        public static void CopyTo<T>(this Vector128<T> vector, T[] destination, int startIndex) where T : struct;
+        public static void CopyTo<T>(this Vector128<T> vector, T[] destination, int startIndex);
-        public static Vector128<T> Create<T>(ReadOnlySpan<T> values) where T : struct;
+        public static Vector128<T> Create<T>(ReadOnlySpan<T> values);
-        public static Vector128<T> Create<T>(Vector64<T> lower, Vector64<T> upper) where T : struct;
+        public static Vector128<T> Create<T>(Vector64<T> lower, Vector64<T> upper);
-        public static Vector128<T> Create<T>(T value) where T : struct;
+        public static Vector128<T> Create<T>(T value);
-        public static Vector128<T> Create<T>(T[] values) where T : struct;
+        public static Vector128<T> Create<T>(T[] values);
-        public static Vector128<T> Create<T>(T[] values, int index) where T : struct;
+        public static Vector128<T> Create<T>(T[] values, int index);
-        public static Vector128<T> CreateScalar<T>(T value) where T : struct;
+        public static Vector128<T> CreateScalar<T>(T value);
-        public static Vector128<T> CreateScalarUnsafe<T>(T value) where T : struct;
+        public static Vector128<T> CreateScalarUnsafe<T>(T value);
-        public static Vector128<T> Divide<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> Divide<T>(Vector128<T> left, Vector128<T> right);
-        public static Vector128<T> Divide<T>(Vector128<T> left, T right) where T : struct;
+        public static Vector128<T> Divide<T>(Vector128<T> left, T right);
-        public static T Dot<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static T Dot<T>(Vector128<T> left, Vector128<T> right);
-        public static Vector128<T> Equals<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> Equals<T>(Vector128<T> left, Vector128<T> right);
-        public static bool EqualsAll<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool EqualsAll<T>(Vector128<T> left, Vector128<T> right);
-        public static bool EqualsAny<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool EqualsAny<T>(Vector128<T> left, Vector128<T> right);
-        [CLSCompliantAttribute(false)]
-        public static uint ExtractMostSignificantBits<T>(this Vector128<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static uint ExtractMostSignificantBits<T>(this Vector128<T> vector);
-        public static T GetElement<T>(this Vector128<T> vector, int index) where T : struct;
+        public static T GetElement<T>(this Vector128<T> vector, int index);
-        public static Vector64<T> GetLower<T>(this Vector128<T> vector) where T : struct;
+        public static Vector64<T> GetLower<T>(this Vector128<T> vector);
-        public static Vector64<T> GetUpper<T>(this Vector128<T> vector) where T : struct;
+        public static Vector64<T> GetUpper<T>(this Vector128<T> vector);
-        public static Vector128<T> GreaterThan<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> GreaterThan<T>(Vector128<T> left, Vector128<T> right);
-        public static bool GreaterThanAll<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool GreaterThanAll<T>(Vector128<T> left, Vector128<T> right);
-        public static bool GreaterThanAny<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool GreaterThanAny<T>(Vector128<T> left, Vector128<T> right);
-        public static Vector128<T> GreaterThanOrEqual<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> GreaterThanOrEqual<T>(Vector128<T> left, Vector128<T> right);
-        public static bool GreaterThanOrEqualAll<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool GreaterThanOrEqualAll<T>(Vector128<T> left, Vector128<T> right);
-        public static bool GreaterThanOrEqualAny<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool GreaterThanOrEqualAny<T>(Vector128<T> left, Vector128<T> right);
-        public static Vector128<T> LessThan<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> LessThan<T>(Vector128<T> left, Vector128<T> right);
-        public static bool LessThanAll<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool LessThanAll<T>(Vector128<T> left, Vector128<T> right);
-        public static bool LessThanAny<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool LessThanAny<T>(Vector128<T> left, Vector128<T> right);
-        public static Vector128<T> LessThanOrEqual<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> LessThanOrEqual<T>(Vector128<T> left, Vector128<T> right);
-        public static bool LessThanOrEqualAll<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool LessThanOrEqualAll<T>(Vector128<T> left, Vector128<T> right);
-        public static bool LessThanOrEqualAny<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static bool LessThanOrEqualAny<T>(Vector128<T> left, Vector128<T> right);
-        [CLSCompliantAttribute(false)]
-        public unsafe static Vector128<T> Load<T>(T* source) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector128<T> Load<T>(T* source);
-        [CLSCompliantAttribute(false)]
-        public unsafe static Vector128<T> LoadAligned<T>(T* source) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector128<T> LoadAligned<T>(T* source);
-        [CLSCompliantAttribute(false)]
-        public unsafe static Vector128<T> LoadAlignedNonTemporal<T>(T* source) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector128<T> LoadAlignedNonTemporal<T>(T* source);
-        public static Vector128<T> LoadUnsafe<T>(ref T source) where T : struct;
+        public static Vector128<T> LoadUnsafe<T>(ref T source);
-        [CLSCompliantAttribute(false)]
-        public static Vector128<T> LoadUnsafe<T>(ref T source, UIntPtr elementOffset) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector128<T> LoadUnsafe<T>(ref T source, UIntPtr elementOffset);
-        public static Vector128<T> Max<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> Max<T>(Vector128<T> left, Vector128<T> right);
-        public static Vector128<T> Min<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> Min<T>(Vector128<T> left, Vector128<T> right);
-        public static Vector128<T> Multiply<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> Multiply<T>(Vector128<T> left, Vector128<T> right);
-        public static Vector128<T> Multiply<T>(Vector128<T> left, T right) where T : struct;
+        public static Vector128<T> Multiply<T>(Vector128<T> left, T right);
-        public static Vector128<T> Multiply<T>(T left, Vector128<T> right) where T : struct;
+        public static Vector128<T> Multiply<T>(T left, Vector128<T> right);
-        public static Vector128<T> Negate<T>(Vector128<T> vector) where T : struct;
+        public static Vector128<T> Negate<T>(Vector128<T> vector);
-        public static Vector128<T> OnesComplement<T>(Vector128<T> vector) where T : struct;
+        public static Vector128<T> OnesComplement<T>(Vector128<T> vector);
-        public static Vector128<T> Sqrt<T>(Vector128<T> vector) where T : struct;
+        public static Vector128<T> Sqrt<T>(Vector128<T> vector);
-        [CLSCompliantAttribute(false)]
-        public unsafe static void Store<T>(this Vector128<T> source, T* destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static void Store<T>(this Vector128<T> source, T* destination);
-        [CLSCompliantAttribute(false)]
-        public unsafe static void StoreAligned<T>(this Vector128<T> source, T* destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static void StoreAligned<T>(this Vector128<T> source, T* destination);
-        [CLSCompliantAttribute(false)]
-        public unsafe static void StoreAlignedNonTemporal<T>(this Vector128<T> source, T* destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static void StoreAlignedNonTemporal<T>(this Vector128<T> source, T* destination);
-        public static void StoreUnsafe<T>(this Vector128<T> source, ref T destination) where T : struct;
+        public static void StoreUnsafe<T>(this Vector128<T> source, ref T destination);
-        [CLSCompliantAttribute(false)]
-        public static void StoreUnsafe<T>(this Vector128<T> source, ref T destination, UIntPtr elementOffset) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static void StoreUnsafe<T>(this Vector128<T> source, ref T destination, UIntPtr elementOffset);
-        public static Vector128<T> Subtract<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> Subtract<T>(Vector128<T> left, Vector128<T> right);
-        public static T Sum<T>(Vector128<T> vector) where T : struct;
+        public static T Sum<T>(Vector128<T> vector);
-        public static T ToScalar<T>(this Vector128<T> vector) where T : struct;
+        public static T ToScalar<T>(this Vector128<T> vector);
-        public static Vector256<T> ToVector256<T>(this Vector128<T> vector) where T : struct;
+        public static Vector256<T> ToVector256<T>(this Vector128<T> vector);
-        public static Vector256<T> ToVector256Unsafe<T>(this Vector128<T> vector) where T : struct;
+        public static Vector256<T> ToVector256Unsafe<T>(this Vector128<T> vector);
-        public static bool TryCopyTo<T>(this Vector128<T> vector, Span<T> destination) where T : struct;
+        public static bool TryCopyTo<T>(this Vector128<T> vector, Span<T> destination);
-        public static Vector128<T> WithElement<T>(this Vector128<T> vector, int index, T value) where T : struct;
+        public static Vector128<T> WithElement<T>(this Vector128<T> vector, int index, T value);
-        public static Vector128<T> WithLower<T>(this Vector128<T> vector, Vector64<T> value) where T : struct;
+        public static Vector128<T> WithLower<T>(this Vector128<T> vector, Vector64<T> value);
-        public static Vector128<T> WithUpper<T>(this Vector128<T> vector, Vector64<T> value) where T : struct;
+        public static Vector128<T> WithUpper<T>(this Vector128<T> vector, Vector64<T> value);
-        public static Vector128<T> Xor<T>(Vector128<T> left, Vector128<T> right) where T : struct;
+        public static Vector128<T> Xor<T>(Vector128<T> left, Vector128<T> right);
     }
-    public readonly struct Vector128<T> : IEquatable<Vector128<T>> where T : struct
+    public readonly struct Vector128<T> : IEquatable<Vector128<T>>
     public static class Vector256 {
-        public static Vector256<T> Abs<T>(Vector256<T> vector) where T : struct;
+        public static Vector256<T> Abs<T>(Vector256<T> vector);
-        public static Vector256<T> Add<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> Add<T>(Vector256<T> left, Vector256<T> right);
-        public static Vector256<T> AndNot<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> AndNot<T>(Vector256<T> left, Vector256<T> right);
-        public static Vector256<TTo> As<TFrom, TTo>(this Vector256<TFrom> vector) where TFrom : struct where TTo : struct;
+        public static Vector256<TTo> As<TFrom, TTo>(this Vector256<TFrom> vector);
-        public static Vector256<byte> AsByte<T>(this Vector256<T> vector) where T : struct;
+        public static Vector256<byte> AsByte<T>(this Vector256<T> vector);
-        public static Vector256<double> AsDouble<T>(this Vector256<T> vector) where T : struct;
+        public static Vector256<double> AsDouble<T>(this Vector256<T> vector);
-        public static Vector256<short> AsInt16<T>(this Vector256<T> vector) where T : struct;
+        public static Vector256<short> AsInt16<T>(this Vector256<T> vector);
-        public static Vector256<int> AsInt32<T>(this Vector256<T> vector) where T : struct;
+        public static Vector256<int> AsInt32<T>(this Vector256<T> vector);
-        public static Vector256<long> AsInt64<T>(this Vector256<T> vector) where T : struct;
+        public static Vector256<long> AsInt64<T>(this Vector256<T> vector);
-        public static Vector256<IntPtr> AsNInt<T>(this Vector256<T> vector) where T : struct;
+        public static Vector256<IntPtr> AsNInt<T>(this Vector256<T> vector);
-        [CLSCompliantAttribute(false)]
-        public static Vector256<UIntPtr> AsNUInt<T>(this Vector256<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector256<UIntPtr> AsNUInt<T>(this Vector256<T> vector);
-        [CLSCompliantAttribute(false)]
-        public static Vector256<sbyte> AsSByte<T>(this Vector256<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector256<sbyte> AsSByte<T>(this Vector256<T> vector);
-        public static Vector256<float> AsSingle<T>(this Vector256<T> vector) where T : struct;
+        public static Vector256<float> AsSingle<T>(this Vector256<T> vector);
-        [CLSCompliantAttribute(false)]
-        public static Vector256<ushort> AsUInt16<T>(this Vector256<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector256<ushort> AsUInt16<T>(this Vector256<T> vector);
-        [CLSCompliantAttribute(false)]
-        public static Vector256<uint> AsUInt32<T>(this Vector256<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector256<uint> AsUInt32<T>(this Vector256<T> vector);
-        [CLSCompliantAttribute(false)]
-        public static Vector256<ulong> AsUInt64<T>(this Vector256<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector256<ulong> AsUInt64<T>(this Vector256<T> vector);
-        public static Vector256<T> AsVector256<T>(this Vector<T> value) where T : struct;
+        public static Vector256<T> AsVector256<T>(this Vector<T> value);
-        public static Vector<T> AsVector<T>(this Vector256<T> value) where T : struct;
+        public static Vector<T> AsVector<T>(this Vector256<T> value);
-        public static Vector256<T> BitwiseAnd<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> BitwiseAnd<T>(Vector256<T> left, Vector256<T> right);
-        public static Vector256<T> BitwiseOr<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> BitwiseOr<T>(Vector256<T> left, Vector256<T> right);
-        public static Vector256<T> ConditionalSelect<T>(Vector256<T> condition, Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> ConditionalSelect<T>(Vector256<T> condition, Vector256<T> left, Vector256<T> right);
-        public static void CopyTo<T>(this Vector256<T> vector, Span<T> destination) where T : struct;
+        public static void CopyTo<T>(this Vector256<T> vector, Span<T> destination);
-        public static void CopyTo<T>(this Vector256<T> vector, T[] destination) where T : struct;
+        public static void CopyTo<T>(this Vector256<T> vector, T[] destination);
-        public static void CopyTo<T>(this Vector256<T> vector, T[] destination, int startIndex) where T : struct;
+        public static void CopyTo<T>(this Vector256<T> vector, T[] destination, int startIndex);
-        public static Vector256<T> Create<T>(ReadOnlySpan<T> values) where T : struct;
+        public static Vector256<T> Create<T>(ReadOnlySpan<T> values);
-        public static Vector256<T> Create<T>(Vector128<T> lower, Vector128<T> upper) where T : struct;
+        public static Vector256<T> Create<T>(Vector128<T> lower, Vector128<T> upper);
-        public static Vector256<T> Create<T>(T value) where T : struct;
+        public static Vector256<T> Create<T>(T value);
-        public static Vector256<T> Create<T>(T[] values) where T : struct;
+        public static Vector256<T> Create<T>(T[] values);
-        public static Vector256<T> Create<T>(T[] values, int index) where T : struct;
+        public static Vector256<T> Create<T>(T[] values, int index);
-        public static Vector256<T> CreateScalar<T>(T value) where T : struct;
+        public static Vector256<T> CreateScalar<T>(T value);
-        public static Vector256<T> CreateScalarUnsafe<T>(T value) where T : struct;
+        public static Vector256<T> CreateScalarUnsafe<T>(T value);
-        public static Vector256<T> Divide<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> Divide<T>(Vector256<T> left, Vector256<T> right);
-        public static Vector256<T> Divide<T>(Vector256<T> left, T right) where T : struct;
+        public static Vector256<T> Divide<T>(Vector256<T> left, T right);
-        public static T Dot<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static T Dot<T>(Vector256<T> left, Vector256<T> right);
-        public static Vector256<T> Equals<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> Equals<T>(Vector256<T> left, Vector256<T> right);
-        public static bool EqualsAll<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool EqualsAll<T>(Vector256<T> left, Vector256<T> right);
-        public static bool EqualsAny<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool EqualsAny<T>(Vector256<T> left, Vector256<T> right);
-        [CLSCompliantAttribute(false)]
-        public static uint ExtractMostSignificantBits<T>(this Vector256<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static uint ExtractMostSignificantBits<T>(this Vector256<T> vector);
-        public static T GetElement<T>(this Vector256<T> vector, int index) where T : struct;
+        public static T GetElement<T>(this Vector256<T> vector, int index);
-        public static Vector128<T> GetLower<T>(this Vector256<T> vector) where T : struct;
+        public static Vector128<T> GetLower<T>(this Vector256<T> vector);
-        public static Vector128<T> GetUpper<T>(this Vector256<T> vector) where T : struct;
+        public static Vector128<T> GetUpper<T>(this Vector256<T> vector);
-        public static Vector256<T> GreaterThan<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> GreaterThan<T>(Vector256<T> left, Vector256<T> right);
-        public static bool GreaterThanAll<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool GreaterThanAll<T>(Vector256<T> left, Vector256<T> right);
-        public static bool GreaterThanAny<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool GreaterThanAny<T>(Vector256<T> left, Vector256<T> right);
-        public static Vector256<T> GreaterThanOrEqual<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> GreaterThanOrEqual<T>(Vector256<T> left, Vector256<T> right);
-        public static bool GreaterThanOrEqualAll<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool GreaterThanOrEqualAll<T>(Vector256<T> left, Vector256<T> right);
-        public static bool GreaterThanOrEqualAny<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool GreaterThanOrEqualAny<T>(Vector256<T> left, Vector256<T> right);
-        public static Vector256<T> LessThan<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> LessThan<T>(Vector256<T> left, Vector256<T> right);
-        public static bool LessThanAll<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool LessThanAll<T>(Vector256<T> left, Vector256<T> right);
-        public static bool LessThanAny<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool LessThanAny<T>(Vector256<T> left, Vector256<T> right);
-        public static Vector256<T> LessThanOrEqual<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> LessThanOrEqual<T>(Vector256<T> left, Vector256<T> right);
-        public static bool LessThanOrEqualAll<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool LessThanOrEqualAll<T>(Vector256<T> left, Vector256<T> right);
-        public static bool LessThanOrEqualAny<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static bool LessThanOrEqualAny<T>(Vector256<T> left, Vector256<T> right);
-        [CLSCompliantAttribute(false)]
-        public unsafe static Vector256<T> Load<T>(T* source) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector256<T> Load<T>(T* source);
-        [CLSCompliantAttribute(false)]
-        public unsafe static Vector256<T> LoadAligned<T>(T* source) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector256<T> LoadAligned<T>(T* source);
-        [CLSCompliantAttribute(false)]
-        public unsafe static Vector256<T> LoadAlignedNonTemporal<T>(T* source) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector256<T> LoadAlignedNonTemporal<T>(T* source);
-        public static Vector256<T> LoadUnsafe<T>(ref T source) where T : struct;
+        public static Vector256<T> LoadUnsafe<T>(ref T source);
-        [CLSCompliantAttribute(false)]
-        public static Vector256<T> LoadUnsafe<T>(ref T source, UIntPtr elementOffset) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector256<T> LoadUnsafe<T>(ref T source, UIntPtr elementOffset);
-        public static Vector256<T> Max<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> Max<T>(Vector256<T> left, Vector256<T> right);
-        public static Vector256<T> Min<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> Min<T>(Vector256<T> left, Vector256<T> right);
-        public static Vector256<T> Multiply<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> Multiply<T>(Vector256<T> left, Vector256<T> right);
-        public static Vector256<T> Multiply<T>(Vector256<T> left, T right) where T : struct;
+        public static Vector256<T> Multiply<T>(Vector256<T> left, T right);
-        public static Vector256<T> Multiply<T>(T left, Vector256<T> right) where T : struct;
+        public static Vector256<T> Multiply<T>(T left, Vector256<T> right);
-        public static Vector256<T> Negate<T>(Vector256<T> vector) where T : struct;
+        public static Vector256<T> Negate<T>(Vector256<T> vector);
-        public static Vector256<T> OnesComplement<T>(Vector256<T> vector) where T : struct;
+        public static Vector256<T> OnesComplement<T>(Vector256<T> vector);
-        public static Vector256<T> Sqrt<T>(Vector256<T> vector) where T : struct;
+        public static Vector256<T> Sqrt<T>(Vector256<T> vector);
-        [CLSCompliantAttribute(false)]
-        public unsafe static void Store<T>(this Vector256<T> source, T* destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static void Store<T>(this Vector256<T> source, T* destination);
-        [CLSCompliantAttribute(false)]
-        public unsafe static void StoreAligned<T>(this Vector256<T> source, T* destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static void StoreAligned<T>(this Vector256<T> source, T* destination);
-        [CLSCompliantAttribute(false)]
-        public unsafe static void StoreAlignedNonTemporal<T>(this Vector256<T> source, T* destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static void StoreAlignedNonTemporal<T>(this Vector256<T> source, T* destination);
-        public static void StoreUnsafe<T>(this Vector256<T> source, ref T destination) where T : struct;
+        public static void StoreUnsafe<T>(this Vector256<T> source, ref T destination);
-        [CLSCompliantAttribute(false)]
-        public static void StoreUnsafe<T>(this Vector256<T> source, ref T destination, UIntPtr elementOffset) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static void StoreUnsafe<T>(this Vector256<T> source, ref T destination, UIntPtr elementOffset);
-        public static Vector256<T> Subtract<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> Subtract<T>(Vector256<T> left, Vector256<T> right);
-        public static T Sum<T>(Vector256<T> vector) where T : struct;
+        public static T Sum<T>(Vector256<T> vector);
-        public static T ToScalar<T>(this Vector256<T> vector) where T : struct;
+        public static T ToScalar<T>(this Vector256<T> vector);
-        public static Vector512<T> ToVector512<T>(this Vector256<T> vector) where T : struct;
+        public static Vector512<T> ToVector512<T>(this Vector256<T> vector);
-        public static Vector512<T> ToVector512Unsafe<T>(this Vector256<T> vector) where T : struct;
+        public static Vector512<T> ToVector512Unsafe<T>(this Vector256<T> vector);
-        public static bool TryCopyTo<T>(this Vector256<T> vector, Span<T> destination) where T : struct;
+        public static bool TryCopyTo<T>(this Vector256<T> vector, Span<T> destination);
-        public static Vector256<T> WithElement<T>(this Vector256<T> vector, int index, T value) where T : struct;
+        public static Vector256<T> WithElement<T>(this Vector256<T> vector, int index, T value);
-        public static Vector256<T> WithLower<T>(this Vector256<T> vector, Vector128<T> value) where T : struct;
+        public static Vector256<T> WithLower<T>(this Vector256<T> vector, Vector128<T> value);
-        public static Vector256<T> WithUpper<T>(this Vector256<T> vector, Vector128<T> value) where T : struct;
+        public static Vector256<T> WithUpper<T>(this Vector256<T> vector, Vector128<T> value);
-        public static Vector256<T> Xor<T>(Vector256<T> left, Vector256<T> right) where T : struct;
+        public static Vector256<T> Xor<T>(Vector256<T> left, Vector256<T> right);
     }
-    public readonly struct Vector256<T> : IEquatable<Vector256<T>> where T : struct
+    public readonly struct Vector256<T> : IEquatable<Vector256<T>>
     public static class Vector512 {
-        public static Vector512<T> Abs<T>(Vector512<T> vector) where T : struct;
+        public static Vector512<T> Abs<T>(Vector512<T> vector);
-        public static Vector512<T> Add<T>(Vector512<T> left, Vector512<T> right) where T : struct;
+        public static Vector512<T> Add<T>(Vector512<T> left, Vector512<T> right);
-        public static Vector512<T> AndNot<T>(Vector512<T> left, Vector512<T> right) where T : struct;
+        public static Vector512<T> AndNot<T>(Vector512<T> left, Vector512<T> right);
-        public static Vector512<TTo> As<TFrom, TTo>(this Vector512<TFrom> vector) where TFrom : struct where TTo : struct;
+        public static Vector512<TTo> As<TFrom, TTo>(this Vector512<TFrom> vector);
-        public static Vector512<byte> AsByte<T>(this Vector512<T> vector) where T : struct;
+        public static Vector512<byte> AsByte<T>(this Vector512<T> vector);
-        public static Vector512<double> AsDouble<T>(this Vector512<T> vector) where T : struct;
+        public static Vector512<double> AsDouble<T>(this Vector512<T> vector);
-        public static Vector512<short> AsInt16<T>(this Vector512<T> vector) where T : struct;
+        public static Vector512<short> AsInt16<T>(this Vector512<T> vector);
-        public static Vector512<int> AsInt32<T>(this Vector512<T> vector) where T : struct;
+        public static Vector512<int> AsInt32<T>(this Vector512<T> vector);
-        public static Vector512<long> AsInt64<T>(this Vector512<T> vector) where T : struct;
+        public static Vector512<long> AsInt64<T>(this Vector512<T> vector);
-        public static Vector512<IntPtr> AsNInt<T>(this Vector512<T> vector) where T : struct;
+        public static Vector512<IntPtr> AsNInt<T>(this Vector512<T> vector);
-        [CLSCompliantAttribute(false)]
-        public static Vector512<UIntPtr> AsNUInt<T>(this Vector512<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector512<UIntPtr> AsNUInt<T>(this Vector512<T> vector);
-        [CLSCompliantAttribute(false)]
-        public static Vector512<sbyte> AsSByte<T>(this Vector512<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector512<sbyte> AsSByte<T>(this Vector512<T> vector);
-        public static Vector512<float> AsSingle<T>(this Vector512<T> vector) where T : struct;
+        public static Vector512<float> AsSingle<T>(this Vector512<T> vector);
-        [CLSCompliantAttribute(false)]
-        public static Vector512<ushort> AsUInt16<T>(this Vector512<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector512<ushort> AsUInt16<T>(this Vector512<T> vector);
-        [CLSCompliantAttribute(false)]
-        public static Vector512<uint> AsUInt32<T>(this Vector512<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector512<uint> AsUInt32<T>(this Vector512<T> vector);
-        [CLSCompliantAttribute(false)]
-        public static Vector512<ulong> AsUInt64<T>(this Vector512<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector512<ulong> AsUInt64<T>(this Vector512<T> vector);
-        public static Vector512<T> AsVector512<T>(this Vector<T> value) where T : struct;
+        public static Vector512<T> AsVector512<T>(this Vector<T> value);
-        public static Vector<T> AsVector<T>(this Vector512<T> value) where T : struct;
+        public static Vector<T> AsVector<T>(this Vector512<T> value);
-        public static Vector512<T> BitwiseAnd<T>(Vector512<T> left, Vector512<T> right) where T : struct;
+        public static Vector512<T> BitwiseAnd<T>(Vector512<T> left, Vector512<T> right);
-        public static Vector512<T> BitwiseOr<T>(Vector512<T> left, Vector512<T> right) where T : struct;
+        public static Vector512<T> BitwiseOr<T>(Vector512<T> left, Vector512<T> right);
-        public static Vector512<T> ConditionalSelect<T>(Vector512<T> condition, Vector512<T> left, Vector512<T> right) where T : struct;
+        public static Vector512<T> ConditionalSelect<T>(Vector512<T> condition, Vector512<T> left, Vector512<T> right);
-        public static void CopyTo<T>(this Vector512<T> vector, Span<T> destination) where T : struct;
+        public static void CopyTo<T>(this Vector512<T> vector, Span<T> destination);
-        public static void CopyTo<T>(this Vector512<T> vector, T[] destination) where T : struct;
+        public static void CopyTo<T>(this Vector512<T> vector, T[] destination);
-        public static void CopyTo<T>(this Vector512<T> vector, T[] destination, int startIndex) where T : struct;
+        public static void CopyTo<T>(this Vector512<T> vector, T[] destination, int startIndex);
-        public static Vector512<T> Create<T>(ReadOnlySpan<T> values) where T : struct;
+        public static Vector512<T> Create<T>(ReadOnlySpan<T> values);
-        public static Vector512<T> Create<T>(Vector256<T> lower, Vector256<T> upper) where T : struct;
+        public static Vector512<T> Create<T>(Vector256<T> lower, Vector256<T> upper);
-        public static Vector512<T> Create<T>(T value) where T : struct;
+        public static Vector512<T> Create<T>(T value);
-        public static Vector512<T> Create<T>(T[] values) where T : struct;
+        public static Vector512<T> Create<T>(T[] values);
-        public static Vector512<T> Create<T>(T[] values, int index) where T : struct;
+        public static Vector512<T> Create<T>(T[] values, int index);
-        public static Vector512<T> CreateScalar<T>(T value) where T : struct;
+        public static Vector512<T> CreateScalar<T>(T value);
-        public static Vector512<T> CreateScalarUnsafe<T>(T value) where T : struct;
+        public static Vector512<T> CreateScalarUnsafe<T>(T value);
-        public static Vector512<T> Divide<T>(Vector512<T> left, Vector512<T> right) where T : struct;
+        public static Vector512<T> Divide<T>(Vector512<T> left, Vector512<T> right);
-        public static Vector512<T> Divide<T>(Vector512<T> left, T right) where T : struct;
+        public static Vector512<T> Divide<T>(Vector512<T> left, T right);
-        public static T Dot<T>(Vector512<T> left, Vector512<T> right) where T : struct;
+        public static T Dot<T>(Vector512<T> left, Vector512<T> right);
-        public static Vector512<T> Equals<T>(Vector512<T> left, Vector512<T> right) where T : struct;
+        public static Vector512<T> Equals<T>(Vector512<T> left, Vector512<T> right);
-        public static bool EqualsAll<T>(Vector512<T> left, Vector512<T> right) where T : struct;
+        public static bool EqualsAll<T>(Vector512<T> left, Vector512<T> right);
-        public static bool EqualsAny<T>(Vector512<T> left, Vector512<T> right) where T : struct;
+        public static bool EqualsAny<T>(Vector512<T> left, Vector512<T> right);
-        [CLSCompliantAttribute(false)]
-        public static ulong ExtractMostSignificantBits<T>(this Vector512<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static ulong ExtractMostSignificantBits<T>(this Vector512<T> vector);
-        public static T GetElement<T>(this Vector512<T> vector, int index) where T : struct;
+        public static T GetElement<T>(this Vector512<T> vector, int index);
-        public static Vector256<T> GetLower<T>(this Vector512<T> vector) where T : struct;
+        public static Vector256<T> GetLower<T>(this Vector512<T> vector);
-        public static Vector256<T> GetUpper<T>(this Vector512<T> vector) where T : struct;
+        public static Vector256<T> GetUpper<T>(this Vector512<T> vector);
-        public static Vector512<T> GreaterThan<T>(Vector512<T> left, Vector512<T> right) where T : struct;
+        public static Vector512<T> GreaterThan<T>(Vector512<T> left, Vector512<T> right);
-        public static bool GreaterThanAll<T>(Vector512<T> left, Vector512<T> right) where T : struct;
+        public static bool GreaterThanAll<T>(Vector512<T> left, Vector512<T> right);
-        public static bool GreaterThanAny<T>(Vector512<T> left, Vector512<T> right) where T : struct;
+        public static bool GreaterThanAny<T>(Vector512<T> left, Vector512<T> right);
-        public static Vector512<T> GreaterThanOrEqual<T>(Vector512<T> left, Vector512<T> right) where T : struct;
+        public static Vector512<T> GreaterThanOrEqual<T>(Vector512<T> left, Vector512<T> right);
-        public static bool GreaterThanOrEqualAll<T>(Vector512<T> left, Vector512<T> right) where T : struct;
+        public static bool GreaterThanOrEqualAll<T>(Vector512<T> left, Vector512<T> right);
-        public static bool GreaterThanOrEqualAny<T>(Vector512<T> left, Vector512<T> right) where T : struct;
+        public static bool GreaterThanOrEqualAny<T>(Vector512<T> left, Vector512<T> right);
-        public static Vector512<T> LessThan<T>(Vector512<T> left, Vector512<T> right) where T : struct;
+        public static Vector512<T> LessThan<T>(Vector512<T> left, Vector512<T> right);
-        public static bool LessThanAll<T>(Vector512<T> left, Vector512<T> right) where T : struct;
+        public static bool LessThanAll<T>(Vector512<T> left, Vector512<T> right);
-        public static bool LessThanAny<T>(Vector512<T> left, Vector512<T> right) where T : struct;
+        public static bool LessThanAny<T>(Vector512<T> left, Vector512<T> right);
-        public static Vector512<T> LessThanOrEqual<T>(Vector512<T> left, Vector512<T> right) where T : struct;
+        public static Vector512<T> LessThanOrEqual<T>(Vector512<T> left, Vector512<T> right);
-        public static bool LessThanOrEqualAll<T>(Vector512<T> left, Vector512<T> right) where T : struct;
+        public static bool LessThanOrEqualAll<T>(Vector512<T> left, Vector512<T> right);
-        public static bool LessThanOrEqualAny<T>(Vector512<T> left, Vector512<T> right) where T : struct;
+        public static bool LessThanOrEqualAny<T>(Vector512<T> left, Vector512<T> right);
-        [CLSCompliantAttribute(false)]
-        public unsafe static Vector512<T> Load<T>(T* source) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector512<T> Load<T>(T* source);
-        [CLSCompliantAttribute(false)]
-        public unsafe static Vector512<T> LoadAligned<T>(T* source) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector512<T> LoadAligned<T>(T* source);
-        [CLSCompliantAttribute(false)]
-        public unsafe static Vector512<T> LoadAlignedNonTemporal<T>(T* source) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector512<T> LoadAlignedNonTemporal<T>(T* source);
-        public static Vector512<T> LoadUnsafe<T>(ref T source) where T : struct;
+        public static Vector512<T> LoadUnsafe<T>(ref T source);
-        [CLSCompliantAttribute(false)]
-        public static Vector512<T> LoadUnsafe<T>(ref T source, UIntPtr elementOffset) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector512<T> LoadUnsafe<T>(ref T source, UIntPtr elementOffset);
-        public static Vector512<T> Max<T>(Vector512<T> left, Vector512<T> right) where T : struct;
+        public static Vector512<T> Max<T>(Vector512<T> left, Vector512<T> right);
-        public static Vector512<T> Min<T>(Vector512<T> left, Vector512<T> right) where T : struct;
+        public static Vector512<T> Min<T>(Vector512<T> left, Vector512<T> right);
-        public static Vector512<T> Multiply<T>(Vector512<T> left, Vector512<T> right) where T : struct;
+        public static Vector512<T> Multiply<T>(Vector512<T> left, Vector512<T> right);
-        public static Vector512<T> Multiply<T>(Vector512<T> left, T right) where T : struct;
+        public static Vector512<T> Multiply<T>(Vector512<T> left, T right);
-        public static Vector512<T> Multiply<T>(T left, Vector512<T> right) where T : struct;
+        public static Vector512<T> Multiply<T>(T left, Vector512<T> right);
-        public static Vector512<T> Negate<T>(Vector512<T> vector) where T : struct;
+        public static Vector512<T> Negate<T>(Vector512<T> vector);
-        public static Vector512<T> OnesComplement<T>(Vector512<T> vector) where T : struct;
+        public static Vector512<T> OnesComplement<T>(Vector512<T> vector);
-        public static Vector512<T> Sqrt<T>(Vector512<T> vector) where T : struct;
+        public static Vector512<T> Sqrt<T>(Vector512<T> vector);
-        [CLSCompliantAttribute(false)]
-        public unsafe static void Store<T>(this Vector512<T> source, T* destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static void Store<T>(this Vector512<T> source, T* destination);
-        [CLSCompliantAttribute(false)]
-        public unsafe static void StoreAligned<T>(this Vector512<T> source, T* destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static void StoreAligned<T>(this Vector512<T> source, T* destination);
-        [CLSCompliantAttribute(false)]
-        public unsafe static void StoreAlignedNonTemporal<T>(this Vector512<T> source, T* destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static void StoreAlignedNonTemporal<T>(this Vector512<T> source, T* destination);
-        public static void StoreUnsafe<T>(this Vector512<T> source, ref T destination) where T : struct;
+        public static void StoreUnsafe<T>(this Vector512<T> source, ref T destination);
-        [CLSCompliantAttribute(false)]
-        public static void StoreUnsafe<T>(this Vector512<T> source, ref T destination, UIntPtr elementOffset) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static void StoreUnsafe<T>(this Vector512<T> source, ref T destination, UIntPtr elementOffset);
-        public static Vector512<T> Subtract<T>(Vector512<T> left, Vector512<T> right) where T : struct;
+        public static Vector512<T> Subtract<T>(Vector512<T> left, Vector512<T> right);
-        public static T Sum<T>(Vector512<T> vector) where T : struct;
+        public static T Sum<T>(Vector512<T> vector);
-        public static T ToScalar<T>(this Vector512<T> vector) where T : struct;
+        public static T ToScalar<T>(this Vector512<T> vector);
-        public static bool TryCopyTo<T>(this Vector512<T> vector, Span<T> destination) where T : struct;
+        public static bool TryCopyTo<T>(this Vector512<T> vector, Span<T> destination);
-        public static Vector512<T> WithElement<T>(this Vector512<T> vector, int index, T value) where T : struct;
+        public static Vector512<T> WithElement<T>(this Vector512<T> vector, int index, T value);
-        public static Vector512<T> WithLower<T>(this Vector512<T> vector, Vector256<T> value) where T : struct;
+        public static Vector512<T> WithLower<T>(this Vector512<T> vector, Vector256<T> value);
-        public static Vector512<T> WithUpper<T>(this Vector512<T> vector, Vector256<T> value) where T : struct;
+        public static Vector512<T> WithUpper<T>(this Vector512<T> vector, Vector256<T> value);
-        public static Vector512<T> Xor<T>(Vector512<T> left, Vector512<T> right) where T : struct;
+        public static Vector512<T> Xor<T>(Vector512<T> left, Vector512<T> right);
     }
-    public readonly struct Vector512<T> : IEquatable<Vector512<T>> where T : struct
+    public readonly struct Vector512<T> : IEquatable<Vector512<T>>
     public static class Vector64 {
-        public static Vector64<T> Abs<T>(Vector64<T> vector) where T : struct;
+        public static Vector64<T> Abs<T>(Vector64<T> vector);
-        public static Vector64<T> Add<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> Add<T>(Vector64<T> left, Vector64<T> right);
-        public static Vector64<T> AndNot<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> AndNot<T>(Vector64<T> left, Vector64<T> right);
-        public static Vector64<TTo> As<TFrom, TTo>(this Vector64<TFrom> vector) where TFrom : struct where TTo : struct;
+        public static Vector64<TTo> As<TFrom, TTo>(this Vector64<TFrom> vector);
-        public static Vector64<byte> AsByte<T>(this Vector64<T> vector) where T : struct;
+        public static Vector64<byte> AsByte<T>(this Vector64<T> vector);
-        public static Vector64<double> AsDouble<T>(this Vector64<T> vector) where T : struct;
+        public static Vector64<double> AsDouble<T>(this Vector64<T> vector);
-        public static Vector64<short> AsInt16<T>(this Vector64<T> vector) where T : struct;
+        public static Vector64<short> AsInt16<T>(this Vector64<T> vector);
-        public static Vector64<int> AsInt32<T>(this Vector64<T> vector) where T : struct;
+        public static Vector64<int> AsInt32<T>(this Vector64<T> vector);
-        public static Vector64<long> AsInt64<T>(this Vector64<T> vector) where T : struct;
+        public static Vector64<long> AsInt64<T>(this Vector64<T> vector);
-        public static Vector64<IntPtr> AsNInt<T>(this Vector64<T> vector) where T : struct;
+        public static Vector64<IntPtr> AsNInt<T>(this Vector64<T> vector);
-        [CLSCompliantAttribute(false)]
-        public static Vector64<UIntPtr> AsNUInt<T>(this Vector64<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector64<UIntPtr> AsNUInt<T>(this Vector64<T> vector);
-        [CLSCompliantAttribute(false)]
-        public static Vector64<sbyte> AsSByte<T>(this Vector64<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector64<sbyte> AsSByte<T>(this Vector64<T> vector);
-        public static Vector64<float> AsSingle<T>(this Vector64<T> vector) where T : struct;
+        public static Vector64<float> AsSingle<T>(this Vector64<T> vector);
-        [CLSCompliantAttribute(false)]
-        public static Vector64<ushort> AsUInt16<T>(this Vector64<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector64<ushort> AsUInt16<T>(this Vector64<T> vector);
-        [CLSCompliantAttribute(false)]
-        public static Vector64<uint> AsUInt32<T>(this Vector64<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector64<uint> AsUInt32<T>(this Vector64<T> vector);
-        [CLSCompliantAttribute(false)]
-        public static Vector64<ulong> AsUInt64<T>(this Vector64<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector64<ulong> AsUInt64<T>(this Vector64<T> vector);
-        public static Vector64<T> BitwiseAnd<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> BitwiseAnd<T>(Vector64<T> left, Vector64<T> right);
-        public static Vector64<T> BitwiseOr<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> BitwiseOr<T>(Vector64<T> left, Vector64<T> right);
-        public static Vector64<T> ConditionalSelect<T>(Vector64<T> condition, Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> ConditionalSelect<T>(Vector64<T> condition, Vector64<T> left, Vector64<T> right);
-        public static void CopyTo<T>(this Vector64<T> vector, Span<T> destination) where T : struct;
+        public static void CopyTo<T>(this Vector64<T> vector, Span<T> destination);
-        public static void CopyTo<T>(this Vector64<T> vector, T[] destination) where T : struct;
+        public static void CopyTo<T>(this Vector64<T> vector, T[] destination);
-        public static void CopyTo<T>(this Vector64<T> vector, T[] destination, int startIndex) where T : struct;
+        public static void CopyTo<T>(this Vector64<T> vector, T[] destination, int startIndex);
-        public static Vector64<T> Create<T>(ReadOnlySpan<T> values) where T : struct;
+        public static Vector64<T> Create<T>(ReadOnlySpan<T> values);
-        public static Vector64<T> Create<T>(T value) where T : struct;
+        public static Vector64<T> Create<T>(T value);
-        public static Vector64<T> Create<T>(T[] values) where T : struct;
+        public static Vector64<T> Create<T>(T[] values);
-        public static Vector64<T> Create<T>(T[] values, int index) where T : struct;
+        public static Vector64<T> Create<T>(T[] values, int index);
-        public static Vector64<T> CreateScalar<T>(T value) where T : struct;
+        public static Vector64<T> CreateScalar<T>(T value);
-        public static Vector64<T> CreateScalarUnsafe<T>(T value) where T : struct;
+        public static Vector64<T> CreateScalarUnsafe<T>(T value);
-        public static Vector64<T> Divide<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> Divide<T>(Vector64<T> left, Vector64<T> right);
-        public static Vector64<T> Divide<T>(Vector64<T> left, T right) where T : struct;
+        public static Vector64<T> Divide<T>(Vector64<T> left, T right);
-        public static T Dot<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static T Dot<T>(Vector64<T> left, Vector64<T> right);
-        public static Vector64<T> Equals<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> Equals<T>(Vector64<T> left, Vector64<T> right);
-        public static bool EqualsAll<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool EqualsAll<T>(Vector64<T> left, Vector64<T> right);
-        public static bool EqualsAny<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool EqualsAny<T>(Vector64<T> left, Vector64<T> right);
-        [CLSCompliantAttribute(false)]
-        public static uint ExtractMostSignificantBits<T>(this Vector64<T> vector) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static uint ExtractMostSignificantBits<T>(this Vector64<T> vector);
-        public static T GetElement<T>(this Vector64<T> vector, int index) where T : struct;
+        public static T GetElement<T>(this Vector64<T> vector, int index);
-        public static Vector64<T> GreaterThan<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> GreaterThan<T>(Vector64<T> left, Vector64<T> right);
-        public static bool GreaterThanAll<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool GreaterThanAll<T>(Vector64<T> left, Vector64<T> right);
-        public static bool GreaterThanAny<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool GreaterThanAny<T>(Vector64<T> left, Vector64<T> right);
-        public static Vector64<T> GreaterThanOrEqual<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> GreaterThanOrEqual<T>(Vector64<T> left, Vector64<T> right);
-        public static bool GreaterThanOrEqualAll<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool GreaterThanOrEqualAll<T>(Vector64<T> left, Vector64<T> right);
-        public static bool GreaterThanOrEqualAny<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool GreaterThanOrEqualAny<T>(Vector64<T> left, Vector64<T> right);
-        public static Vector64<T> LessThan<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> LessThan<T>(Vector64<T> left, Vector64<T> right);
-        public static bool LessThanAll<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool LessThanAll<T>(Vector64<T> left, Vector64<T> right);
-        public static bool LessThanAny<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool LessThanAny<T>(Vector64<T> left, Vector64<T> right);
-        public static Vector64<T> LessThanOrEqual<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> LessThanOrEqual<T>(Vector64<T> left, Vector64<T> right);
-        public static bool LessThanOrEqualAll<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool LessThanOrEqualAll<T>(Vector64<T> left, Vector64<T> right);
-        public static bool LessThanOrEqualAny<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static bool LessThanOrEqualAny<T>(Vector64<T> left, Vector64<T> right);
-        [CLSCompliantAttribute(false)]
-        public unsafe static Vector64<T> Load<T>(T* source) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector64<T> Load<T>(T* source);
-        [CLSCompliantAttribute(false)]
-        public unsafe static Vector64<T> LoadAligned<T>(T* source) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector64<T> LoadAligned<T>(T* source);
-        [CLSCompliantAttribute(false)]
-        public unsafe static Vector64<T> LoadAlignedNonTemporal<T>(T* source) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector64<T> LoadAlignedNonTemporal<T>(T* source);
-        public static Vector64<T> LoadUnsafe<T>(ref T source) where T : struct;
+        public static Vector64<T> LoadUnsafe<T>(ref T source);
-        [CLSCompliantAttribute(false)]
-        public static Vector64<T> LoadUnsafe<T>(ref T source, UIntPtr elementOffset) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector64<T> LoadUnsafe<T>(ref T source, UIntPtr elementOffset);
-        public static Vector64<T> Max<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> Max<T>(Vector64<T> left, Vector64<T> right);
-        public static Vector64<T> Min<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> Min<T>(Vector64<T> left, Vector64<T> right);
-        public static Vector64<T> Multiply<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> Multiply<T>(Vector64<T> left, Vector64<T> right);
-        public static Vector64<T> Multiply<T>(Vector64<T> left, T right) where T : struct;
+        public static Vector64<T> Multiply<T>(Vector64<T> left, T right);
-        public static Vector64<T> Multiply<T>(T left, Vector64<T> right) where T : struct;
+        public static Vector64<T> Multiply<T>(T left, Vector64<T> right);
-        public static Vector64<T> Negate<T>(Vector64<T> vector) where T : struct;
+        public static Vector64<T> Negate<T>(Vector64<T> vector);
-        public static Vector64<T> OnesComplement<T>(Vector64<T> vector) where T : struct;
+        public static Vector64<T> OnesComplement<T>(Vector64<T> vector);
-        public static Vector64<T> Sqrt<T>(Vector64<T> vector) where T : struct;
+        public static Vector64<T> Sqrt<T>(Vector64<T> vector);
-        [CLSCompliantAttribute(false)]
-        public unsafe static void Store<T>(this Vector64<T> source, T* destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static void Store<T>(this Vector64<T> source, T* destination);
-        [CLSCompliantAttribute(false)]
-        public unsafe static void StoreAligned<T>(this Vector64<T> source, T* destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static void StoreAligned<T>(this Vector64<T> source, T* destination);
-        [CLSCompliantAttribute(false)]
-        public unsafe static void StoreAlignedNonTemporal<T>(this Vector64<T> source, T* destination) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public unsafe static void StoreAlignedNonTemporal<T>(this Vector64<T> source, T* destination);
-        public static void StoreUnsafe<T>(this Vector64<T> source, ref T destination) where T : struct;
+        public static void StoreUnsafe<T>(this Vector64<T> source, ref T destination);
-        [CLSCompliantAttribute(false)]
-        public static void StoreUnsafe<T>(this Vector64<T> source, ref T destination, UIntPtr elementOffset) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static void StoreUnsafe<T>(this Vector64<T> source, ref T destination, UIntPtr elementOffset);
-        public static Vector64<T> Subtract<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> Subtract<T>(Vector64<T> left, Vector64<T> right);
-        public static T Sum<T>(Vector64<T> vector) where T : struct;
+        public static T Sum<T>(Vector64<T> vector);
-        public static T ToScalar<T>(this Vector64<T> vector) where T : struct;
+        public static T ToScalar<T>(this Vector64<T> vector);
-        public static Vector128<T> ToVector128<T>(this Vector64<T> vector) where T : struct;
+        public static Vector128<T> ToVector128<T>(this Vector64<T> vector);
-        public static Vector128<T> ToVector128Unsafe<T>(this Vector64<T> vector) where T : struct;
+        public static Vector128<T> ToVector128Unsafe<T>(this Vector64<T> vector);
-        public static bool TryCopyTo<T>(this Vector64<T> vector, Span<T> destination) where T : struct;
+        public static bool TryCopyTo<T>(this Vector64<T> vector, Span<T> destination);
-        public static Vector64<T> WithElement<T>(this Vector64<T> vector, int index, T value) where T : struct;
+        public static Vector64<T> WithElement<T>(this Vector64<T> vector, int index, T value);
-        public static Vector64<T> Xor<T>(Vector64<T> left, Vector64<T> right) where T : struct;
+        public static Vector64<T> Xor<T>(Vector64<T> left, Vector64<T> right);
     }
-    public readonly struct Vector64<T> : IEquatable<Vector64<T>> where T : struct
+    public readonly struct Vector64<T> : IEquatable<Vector64<T>>
 }
```

