# System.Text.Json.Serialization

``` diff
 namespace System.Text.Json.Serialization {
     public abstract class JsonConverter {
+        public abstract Type Type { get; }
     }
     public abstract class JsonConverter<T> : JsonConverter {
+        public sealed override Type Type { get; }
     }
     public abstract class JsonConverterFactory : JsonConverter {
+        public sealed override Type Type { get; }
     }
+    public class JsonStringEnumConverter<TEnum> : JsonConverterFactory where TEnum : struct {
+        public JsonStringEnumConverter();
+        public JsonStringEnumConverter(JsonNamingPolicy? namingPolicy = null, bool allowIntegerValues = true);
+        public sealed override bool CanConvert(Type typeToConvert);
+        public sealed override JsonConverter CreateConverter(Type typeToConvert, JsonSerializerOptions options);
+    }
 }
```

