# System.ComponentModel.Design

``` diff
 namespace System.ComponentModel.Design {
     public class DesignSurface : IDisposable, IServiceProvider {
-        public DesignSurface(IServiceProvider parentProvider);
+        public DesignSurface(IServiceProvider? parentProvider);
-        public DesignSurface(IServiceProvider parentProvider, Type rootComponentType);
+        public DesignSurface(IServiceProvider? parentProvider, Type rootComponentType);
-        public event EventHandler Disposed;
+        public event EventHandler? Disposed;
-        public event EventHandler Flushed;
+        public event EventHandler? Flushed;
-        public event LoadedEventHandler Loaded;
+        public event LoadedEventHandler? Loaded;
-        public event EventHandler Loading;
+        public event EventHandler? Loading;
-        public event EventHandler Unloaded;
+        public event EventHandler? Unloaded;
-        public event EventHandler Unloading;
+        public event EventHandler? Unloading;
-        public event EventHandler ViewActivated;
+        public event EventHandler? ViewActivated;
-        [ObsoleteAttribute("CreateComponent has been replaced by CreateInstance and will be removed after Beta2")]
-        protected internal virtual IComponent CreateComponent(Type componentType);
+        [ObsoleteAttribute("CreateComponent has been replaced by CreateInstance and will be removed after Beta2")]
+        protected internal virtual IComponent? CreateComponent(Type componentType);
-        protected internal virtual IDesigner CreateDesigner(IComponent component, bool rootDesigner);
+        protected internal virtual IDesigner? CreateDesigner(IComponent component, bool rootDesigner);
-        protected internal virtual object CreateInstance(Type type);
+        protected internal virtual object? CreateInstance(Type type);
-        public INestedContainer CreateNestedContainer(IComponent owningComponent, string containerName);
+        public INestedContainer CreateNestedContainer(IComponent owningComponent, string? containerName);
-        public object GetService(Type serviceType);
+        public object? GetService(Type serviceType);
     }
     public sealed class DesignSurfaceCollection : ICollection, IEnumerable {
-        int System.Collections.ICollection.Count { get; }
+        int ICollection.Count { get; }
-        bool System.Collections.ICollection.IsSynchronized { get; }
+        bool ICollection.IsSynchronized { get; }
-        object System.Collections.ICollection.SyncRoot { get; }
+        object ICollection.SyncRoot { get; }
     }
     public class DesignSurfaceManager : IDisposable, IServiceProvider {
-        public object GetService(Type serviceType);
+        public object? GetService(Type serviceType);
     }
 }
```

