# System.Windows.Forms

``` diff
 namespace System.Windows.Forms {
     [DefaultEventAttribute("Opening")]
     [SRDescriptionAttribute("DescriptionContextMenuStrip")]
     public class ContextMenuStrip : ToolStripDropDownMenu {
+        protected override void OnClosed(ToolStripDropDownClosedEventArgs e);
+        protected override void OnOpened(EventArgs e);
     }
     [DefaultPropertyAttribute("Text")]
     [DesignTimeVisibleAttribute(false)]
     [ToolboxItemAttribute(false)]
     [TypeConverterAttribute(typeof(ListViewItemConverter))]
     public class ListViewItem : ICloneable, IKeyboardToolTip, ISerializable {
-        public ListViewItem(ListViewItem.ListViewSubItem[] subItems, string imageKey, ListViewGroup group);
+        public ListViewItem(ListViewItem.ListViewSubItem[] subItems, string? imageKey, ListViewGroup? group);
-        public ListViewItem(string text);
+        public ListViewItem(string? text);
-        public ListViewItem(string text, int imageIndex);
+        public ListViewItem(string? text, int imageIndex);
-        public ListViewItem(string text, int imageIndex, ListViewGroup group);
+        public ListViewItem(string? text, int imageIndex, ListViewGroup? group);
-        public ListViewItem(string text, string imageKey);
+        public ListViewItem(string? text, string? imageKey);
-        public ListViewItem(string text, string imageKey, ListViewGroup group);
+        public ListViewItem(string? text, string? imageKey, ListViewGroup? group);
-        public ListViewItem(string text, ListViewGroup group);
+        public ListViewItem(string? text, ListViewGroup? group);
-        public ListViewItem(string[]? items, int imageIndex, Color foreColor, Color backColor, Font font);
+        public ListViewItem(string[]? items, int imageIndex, Color foreColor, Color backColor, Font? font);
-        public ListViewItem(string[]? items, int imageIndex, Color foreColor, Color backColor, Font font, ListViewGroup group);
+        public ListViewItem(string[]? items, int imageIndex, Color foreColor, Color backColor, Font? font, ListViewGroup? group);
-        public ListViewItem(string[]? items, int imageIndex, ListViewGroup group);
+        public ListViewItem(string[]? items, int imageIndex, ListViewGroup? group);
-        public ListViewItem(string[]? items, string imageKey);
+        public ListViewItem(string[]? items, string? imageKey);
-        public ListViewItem(string[]? items, string imageKey, Color foreColor, Color backColor, Font font);
+        public ListViewItem(string[]? items, string? imageKey, Color foreColor, Color backColor, Font? font);
-        public ListViewItem(string[]? items, string imageKey, Color foreColor, Color backColor, Font font, ListViewGroup group);
+        public ListViewItem(string[]? items, string? imageKey, Color foreColor, Color backColor, Font? font, ListViewGroup? group);
-        public ListViewItem(string[]? items, string imageKey, ListViewGroup group);
+        public ListViewItem(string[]? items, string? imageKey, ListViewGroup? group);
-        public ListViewItem(string[]? items, ListViewGroup group);
+        public ListViewItem(string[]? items, ListViewGroup? group);
-        public ListViewItem(ListViewGroup group);
+        public ListViewItem(ListViewGroup? group);
-        [DefaultValueAttribute(null)]
-        [LocalizableAttribute(true)]
-        [SRCategoryAttribute("CatBehavior")]
-        public ListViewGroup Group { get; set; }
+        [DefaultValueAttribute(null)]
+        [LocalizableAttribute(true)]
+        [SRCategoryAttribute("CatBehavior")]
+        public ListViewGroup? Group { get; set; }
-        [BrowsableAttribute(false)]
-        public ImageList ImageList { get; }
+        [BrowsableAttribute(false)]
+        public ImageList? ImageList { get; }
-        [BrowsableAttribute(false)]
-        public ListView ListView { get; }
+        [BrowsableAttribute(false)]
+        public ListView? ListView { get; }
-        [BindableAttribute(true)]
-        [DefaultValueAttribute(null)]
-        [LocalizableAttribute(false)]
-        [SRCategoryAttribute("CatData")]
-        [SRDescriptionAttribute("ControlTagDescr")]
-        [TypeConverterAttribute(typeof(StringConverter))]
-        public object Tag { get; set; }
+        [BindableAttribute(true)]
+        [DefaultValueAttribute(null)]
+        [LocalizableAttribute(false)]
+        [SRCategoryAttribute("CatData")]
+        [SRDescriptionAttribute("ControlTagDescr")]
+        [TypeConverterAttribute(typeof(StringConverter))]
+        public object? Tag { get; set; }
-        [DesignerSerializationVisibilityAttribute(0)]
-        [LocalizableAttribute(true)]
-        [SRCategoryAttribute("CatAppearance")]
-        public string Text { get; set; }
+        [DesignerSerializationVisibilityAttribute(0)]
+        [LocalizableAttribute(true)]
+        [SRCategoryAttribute("CatAppearance")]
+        [AllowNullAttribute]
+        public string Text { get; set; }
-        [DefaultValueAttribute("")]
-        [SRCategoryAttribute("CatAppearance")]
-        public string ToolTipText { get; set; }
+        [DefaultValueAttribute("")]
+        [SRCategoryAttribute("CatAppearance")]
+        [AllowNullAttribute]
+        public string ToolTipText { get; set; }
-        public ListViewItem FindNearestItem(SearchDirectionHint searchDirection);
+        public ListViewItem? FindNearestItem(SearchDirectionHint searchDirection);
-        public ListViewItem.ListViewSubItem GetSubItemAt(int x, int y);
+        public ListViewItem.ListViewSubItem? GetSubItemAt(int x, int y);
         [DefaultPropertyAttribute("Text")]
         [DesignTimeVisibleAttribute(false)]
         [ToolboxItemAttribute(false)]
         [TypeConverterAttribute(typeof(ListViewSubItemConverter))]
         public class ListViewSubItem {
-            public ListViewSubItem(ListViewItem owner, string? text);
+            public ListViewSubItem(ListViewItem owner, string text);
-            public ListViewSubItem(ListViewItem owner, string? text, Color foreColor, Color backColor, Font font);
+            public ListViewSubItem(ListViewItem owner, string text, Color foreColor, Color backColor, Font font);
-            [BindableAttribute(true)]
-            [DefaultValueAttribute(null)]
-            [LocalizableAttribute(false)]
-            [SRCategoryAttribute("CatData")]
-            [SRDescriptionAttribute("ControlTagDescr")]
-            [TypeConverterAttribute(typeof(StringConverter))]
-            public object? Tag { get; set; }
+            [BindableAttribute(true)]
+            [DefaultValueAttribute(null)]
+            [LocalizableAttribute(false)]
+            [SRCategoryAttribute("CatData")]
+            [SRDescriptionAttribute("ControlTagDescr")]
+            [TypeConverterAttribute(typeof(StringConverter))]
+            public object Tag { get; set; }
         }
     }
 }
```

