# Microsoft.AspNetCore.Components.Forms.Mapping

``` diff
+namespace Microsoft.AspNetCore.Components.Forms.Mapping {
+    public class FormMappingError {
+        public string? AttemptedValue { get; }
+        public object Container { get; internal set; }
+        public IReadOnlyList<FormattableString> ErrorMessages { get; }
+        public string Name { get; }
+        public string Path { get; }
+    }
+    public class FormValueMappingContext {
+        public FormValueMappingContext(string acceptMappingScopeName, string? acceptFormName, Type valueType, string parameterName);
+        public string? AcceptFormName { get; }
+        public string AcceptMappingScopeName { get; }
+        public Action<string, object>? MapErrorToContainer { get; set; }
+        public Action<string, FormattableString, string?>? OnError { get; set; }
+        public string ParameterName { get; }
+        public object? Result { get; }
+        public Type ValueType { get; }
+        public void SetResult(object? result);
+    }
+    public interface IFormValueMapper {
+        bool CanMap(Type valueType, string scopeName, string? formName);
+        void Map(FormValueMappingContext context);
+    }
+    public static class SupplyParameterFromFormServiceCollectionExtensions {
+        public static IServiceCollection AddSupplyValueFromFormProvider(this IServiceCollection serviceCollection);
+    }
+}
```

