# Microsoft.AspNetCore.Components.Forms

``` diff
 namespace Microsoft.AspNetCore.Components.Forms {
+    public class AntiforgeryRequestToken {
+        public AntiforgeryRequestToken(string value, string formFieldName);
+        public string FormFieldName { get; }
+        public string Value { get; }
+    }
+    public abstract class AntiforgeryStateProvider {
+        protected AntiforgeryStateProvider();
+        public abstract AntiforgeryRequestToken? GetAntiforgeryToken();
+    }
+    public class AntiforgeryToken : IComponent {
+        public AntiforgeryToken();
+        void Microsoft.AspNetCore.Components.IComponent.Attach(RenderHandle renderHandle);
+        Task Microsoft.AspNetCore.Components.IComponent.SetParametersAsync(ParameterView parameters);
+    }
     public class EditForm : ComponentBase {
-        public ModelBindingContext BindingContext { get; set; }

-        public string FormHandlerName { get; set; }

+        public string FormName { get; set; }
     }
+    public abstract class Editor<T> : ComponentBase, ICascadingValueSupplier {
+        protected Editor();
+        public T Value { get; set; }
+        public EventCallback<T> ValueChanged { get; set; }
+        public Expression<Func<T>> ValueExpression { get; set; }
+        protected string NameFor(LambdaExpression expression);
+        protected override void OnParametersSet();
+    }
-    public abstract class FormDataProvider {
 {
-        protected FormDataProvider();

-        public abstract IReadOnlyDictionary<string, StringValues> Entries { get; }

-        public bool IsFormDataAvailable { get; }

-        public abstract string? Name { get; }

-    }
+    public sealed class FormMappingContext {
+        public string MappingScopeName { get; }
+        public IEnumerable<FormMappingError> GetAllErrors();
+        public IEnumerable<FormMappingError> GetAllErrors(string formName);
+        public string? GetAttemptedValue(string key);
+        public string? GetAttemptedValue(string formName, string key);
+        public FormMappingError? GetErrors(string key);
+        public FormMappingError? GetErrors(string formName, string key);
+    }
+    public sealed class FormMappingScope : ICascadingValueSupplier, IComponent {
+        public FormMappingScope();
+        public RenderFragment<FormMappingContext> ChildContent { get; set; }
+        public string Name { get; set; }
+        void IComponent.Attach(RenderHandle renderHandle);
+        Task IComponent.SetParametersAsync(ParameterView parameters);
+    }
-    public interface IHostEnvironmentFormDataProvider {
 {
-        void SetFormData(string name, IReadOnlyDictionary<string, StringValues> formData);

-    }
 }
```

