# Microsoft.AspNetCore.Components.RenderTree

``` diff
 namespace Microsoft.AspNetCore.Components.RenderTree {
+    public readonly struct NamedEventChange {
+        public NamedEventChange(NamedEventChangeType changeType, int componentId, int frameIndex, string eventType, string assignedName);
+        public string AssignedName { get; }
+        public NamedEventChangeType ChangeType { get; }
+        public int ComponentId { get; }
+        public string EventType { get; }
+        public int FrameIndex { get; }
+    }
+    public enum NamedEventChangeType {
+        Added = 0,
+        Removed = 1,
+    }
     public readonly struct RenderBatch {
+        public ArrayRange<NamedEventChange>? NamedEventChanges { get; }
     }
     public abstract class Renderer : IAsyncDisposable, IDisposable {
-        public virtual Task DispatchEventAsync(ulong eventHandlerId, EventFieldInfo? fieldInfo, EventArgs eventArgs, bool quiesce);
+        public virtual Task DispatchEventAsync(ulong eventHandlerId, EventFieldInfo? fieldInfo, EventArgs eventArgs, bool waitForQuiescence);
-        protected internal virtual bool ShouldTrackNamedEventHandlers();

-        protected internal virtual void TrackNamedEventId(ulong eventHandlerId, int componentId, string eventHandlerName);

     }
     public struct RenderTreeFrame {
+        public string NamedEventAssignedName { get; }
+        public string NamedEventType { get; }
     }
     public enum RenderTreeFrameType : short {
+        NamedEvent = (short)10,
     }
     public abstract class WebRenderer : Renderer {
+        protected virtual int GetWebRendererId();
+        protected virtual void UpdateRootComponents(string operationsJson);
-        public Task WaitUntilAttachedAsync();

     }
 }
```

