# Microsoft.Extensions.DependencyInjection.Extensions

``` diff
 namespace Microsoft.Extensions.DependencyInjection.Extensions {
     public static class ServiceCollectionDescriptorExtensions {
+        public static IServiceCollection RemoveAllKeyed(this IServiceCollection collection, Type serviceType, object? serviceKey);
+        public static IServiceCollection RemoveAllKeyed<T>(this IServiceCollection collection, object? serviceKey);
+        public static void TryAddKeyedScoped(this IServiceCollection collection, Type service, object? serviceKey);
+        public static void TryAddKeyedScoped(this IServiceCollection collection, Type service, object? serviceKey, Func<IServiceProvider, object, object> implementationFactory);
+        public static void TryAddKeyedScoped(this IServiceCollection collection, Type service, object? serviceKey, Type implementationType);
+        public static void TryAddKeyedScoped<TService, TImplementation>(this IServiceCollection collection, object? serviceKey) where TService : class where TImplementation : class, TService;
+        public static void TryAddKeyedScoped<TService>(this IServiceCollection collection, object? serviceKey) where TService : class;
+        public static void TryAddKeyedScoped<TService>(this IServiceCollection services, object? serviceKey, Func<IServiceProvider, object, TService> implementationFactory) where TService : class;
+        public static void TryAddKeyedSingleton(this IServiceCollection collection, Type service, object? serviceKey);
+        public static void TryAddKeyedSingleton(this IServiceCollection collection, Type service, object? serviceKey, Func<IServiceProvider, object, object> implementationFactory);
+        public static void TryAddKeyedSingleton(this IServiceCollection collection, Type service, object? serviceKey, Type implementationType);
+        public static void TryAddKeyedSingleton<TService, TImplementation>(this IServiceCollection collection, object? serviceKey) where TService : class where TImplementation : class, TService;
+        public static void TryAddKeyedSingleton<TService>(this IServiceCollection collection, object? serviceKey) where TService : class;
+        public static void TryAddKeyedSingleton<TService>(this IServiceCollection services, object? serviceKey, Func<IServiceProvider, object, TService> implementationFactory) where TService : class;
+        public static void TryAddKeyedSingleton<TService>(this IServiceCollection collection, object? serviceKey, TService instance) where TService : class;
+        public static void TryAddKeyedTransient(this IServiceCollection collection, Type service, object? serviceKey);
+        public static void TryAddKeyedTransient(this IServiceCollection collection, Type service, object? serviceKey, Func<IServiceProvider, object, object> implementationFactory);
+        public static void TryAddKeyedTransient(this IServiceCollection collection, Type service, object? serviceKey, Type implementationType);
+        public static void TryAddKeyedTransient<TService, TImplementation>(this IServiceCollection collection, object? serviceKey) where TService : class where TImplementation : class, TService;
+        public static void TryAddKeyedTransient<TService>(this IServiceCollection collection, object? serviceKey) where TService : class;
+        public static void TryAddKeyedTransient<TService>(this IServiceCollection services, object? serviceKey, Func<IServiceProvider, object, TService> implementationFactory) where TService : class;
     }
 }
```

