# Microsoft.Extensions.DependencyInjection

``` diff
 namespace Microsoft.Extensions.DependencyInjection {
+    public static class CascadingAuthenticationStateServiceCollectionExtensions {
+        public static IServiceCollection AddCascadingAuthenticationState(this IServiceCollection serviceCollection);
+    }
+    public static class CascadingValueServiceCollectionExtensions {
+        public static IServiceCollection AddCascadingValue<TValue>(this IServiceCollection serviceCollection, Func<IServiceProvider, CascadingValueSource<TValue>> sourceFactory);
+        public static IServiceCollection AddCascadingValue<TValue>(this IServiceCollection serviceCollection, Func<IServiceProvider, TValue> valueFactory);
+        public static IServiceCollection AddCascadingValue<TValue>(this IServiceCollection serviceCollection, string name, Func<IServiceProvider, TValue> valueFactory);
+    }
+    public class FromKeyedServicesAttribute : Attribute {
+        public FromKeyedServicesAttribute(object key);
+        public object Key { get; }
+    }
     public static class HttpClientBuilderExtensions {
+        public static IHttpClientBuilder AddDefaultLogger(this IHttpClientBuilder builder);
+        public static IHttpClientBuilder AddLogger(this IHttpClientBuilder builder, Func<IServiceProvider, IHttpClientLogger> httpClientLoggerFactory, bool wrapHandlersPipeline = false);
+        public static IHttpClientBuilder AddLogger<TLogger>(this IHttpClientBuilder builder, bool wrapHandlersPipeline = false) where TLogger : IHttpClientLogger;
+        public static IHttpClientBuilder ConfigureAdditionalHttpMessageHandlers(this IHttpClientBuilder builder, Action<IList<DelegatingHandler>, IServiceProvider> configureAdditionalHandlers);
+        public static IHttpClientBuilder ConfigurePrimaryHttpMessageHandler(this IHttpClientBuilder builder, Action<HttpMessageHandler, IServiceProvider> configureHandler);
+        public static IHttpClientBuilder RemoveAllLoggers(this IHttpClientBuilder builder);
+        public static IHttpClientBuilder UseSocketsHttpHandler(this IHttpClientBuilder builder, Action<ISocketsHttpHandlerBuilder> configureBuilder);
+        public static IHttpClientBuilder UseSocketsHttpHandler(this IHttpClientBuilder builder, Action<SocketsHttpHandler, IServiceProvider>? configureHandler = null);
     }
     public static class HttpClientFactoryServiceCollectionExtensions {
+        public static IServiceCollection ConfigureHttpClientDefaults(IServiceCollection services, Action<IHttpClientBuilder> configure);
     }
+    public interface IKeyedServiceProvider : IServiceProvider {
+        object? GetKeyedService(Type serviceType, object? serviceKey);
+        object GetRequiredKeyedService(Type serviceType, object? serviceKey);
+    }
+    public interface IServiceProviderIsKeyedService : IServiceProviderIsService {
+        bool IsKeyedService(Type serviceType, object? serviceKey);
+    }
+    public interface ISocketsHttpHandlerBuilder {
+        string Name { get; }
+        IServiceCollection Services { get; }
+    }
+    public static class KeyedService {
+        public static object AnyKey { get; }
+    }
+    public class RazorComponentOptions {
+        public RazorComponentOptions();
+        public bool FormMappingUseCurrentCulture { get; set; }
+        public int MaxFormMappingCollectionSize { get; set; }
+        public int MaxFormMappingErrorCount { get; set; }
+        public int MaxFormMappingKeySize { get; set; }
+        public int MaxFormMappingRecursionDepth { get; set; }
+    }
     public static class RazorComponentsServiceCollectionExtensions {
+        public static IRazorComponentsBuilder AddRazorComponents(this IServiceCollection services, Action<RazorComponentOptions> setupAction);
     }
     public static class ServiceCollectionServiceExtensions {
+        public static IServiceCollection AddKeyedScoped(this IServiceCollection services, Type serviceType, object? serviceKey);
+        public static IServiceCollection AddKeyedScoped(this IServiceCollection services, Type serviceType, object? serviceKey, Func<IServiceProvider, object, object> implementationFactory);
+        public static IServiceCollection AddKeyedScoped(this IServiceCollection services, Type serviceType, object? serviceKey, Type implementationType);
+        public static IServiceCollection AddKeyedScoped<TService, TImplementation>(this IServiceCollection services, object? serviceKey) where TService : class where TImplementation : class, TService;
+        public static IServiceCollection AddKeyedScoped<TService, TImplementation>(this IServiceCollection services, object? serviceKey, Func<IServiceProvider, object, TImplementation> implementationFactory) where TService : class where TImplementation : class, TService;
+        public static IServiceCollection AddKeyedScoped<TService>(this IServiceCollection services, object? serviceKey) where TService : class;
+        public static IServiceCollection AddKeyedScoped<TService>(this IServiceCollection services, object? serviceKey, Func<IServiceProvider, object, TService> implementationFactory) where TService : class;
+        public static IServiceCollection AddKeyedSingleton(this IServiceCollection services, Type serviceType, object? serviceKey);
+        public static IServiceCollection AddKeyedSingleton(this IServiceCollection services, Type serviceType, object? serviceKey, Func<IServiceProvider, object, object> implementationFactory);
+        public static IServiceCollection AddKeyedSingleton(this IServiceCollection services, Type serviceType, object? serviceKey, object implementationInstance);
+        public static IServiceCollection AddKeyedSingleton(this IServiceCollection services, Type serviceType, object? serviceKey, Type implementationType);
+        public static IServiceCollection AddKeyedSingleton<TService, TImplementation>(this IServiceCollection services, object? serviceKey) where TService : class where TImplementation : class, TService;
+        public static IServiceCollection AddKeyedSingleton<TService, TImplementation>(this IServiceCollection services, object? serviceKey, Func<IServiceProvider, object, TImplementation> implementationFactory) where TService : class where TImplementation : class, TService;
+        public static IServiceCollection AddKeyedSingleton<TService>(this IServiceCollection services, object? serviceKey) where TService : class;
+        public static IServiceCollection AddKeyedSingleton<TService>(this IServiceCollection services, object? serviceKey, Func<IServiceProvider, object, TService> implementationFactory) where TService : class;
+        public static IServiceCollection AddKeyedSingleton<TService>(this IServiceCollection services, object? serviceKey, TService implementationInstance) where TService : class;
+        public static IServiceCollection AddKeyedTransient(this IServiceCollection services, Type serviceType, object? serviceKey);
+        public static IServiceCollection AddKeyedTransient(this IServiceCollection services, Type serviceType, object? serviceKey, Func<IServiceProvider, object, object> implementationFactory);
+        public static IServiceCollection AddKeyedTransient(this IServiceCollection services, Type serviceType, object? serviceKey, Type implementationType);
+        public static IServiceCollection AddKeyedTransient<TService, TImplementation>(this IServiceCollection services, object? serviceKey) where TService : class where TImplementation : class, TService;
+        public static IServiceCollection AddKeyedTransient<TService, TImplementation>(this IServiceCollection services, object? serviceKey, Func<IServiceProvider, object, TImplementation> implementationFactory) where TService : class where TImplementation : class, TService;
+        public static IServiceCollection AddKeyedTransient<TService>(this IServiceCollection services, object? serviceKey) where TService : class;
+        public static IServiceCollection AddKeyedTransient<TService>(this IServiceCollection services, object? serviceKey, Func<IServiceProvider, object, TService> implementationFactory) where TService : class;
     }
     public class ServiceDescriptor {
+        public ServiceDescriptor(Type serviceType, object? serviceKey, Func<IServiceProvider, object?, object> factory, ServiceLifetime lifetime);
+        public ServiceDescriptor(Type serviceType, object? serviceKey, object instance);
+        public ServiceDescriptor(Type serviceType, object? serviceKey, Type implementationType, ServiceLifetime lifetime);
+        public bool IsKeyedService { get; }
+        public Func<IServiceProvider, object?, object>? KeyedImplementationFactory { get; }
+        public object? KeyedImplementationInstance { get; }
+        public Type? KeyedImplementationType { get; }
+        public object? ServiceKey { get; }
+        public static ServiceDescriptor DescribeKeyed(Type serviceType, object? serviceKey, Func<IServiceProvider, object, object> implementationFactory, ServiceLifetime lifetime);
+        public static ServiceDescriptor DescribeKeyed(Type serviceType, object? serviceKey, Type implementationType, ServiceLifetime lifetime);
+        public static ServiceDescriptor KeyedScoped(Type service, object? serviceKey, Func<IServiceProvider, object, object> implementationFactory);
+        public static ServiceDescriptor KeyedScoped(Type service, object? serviceKey, Type implementationType);
+        public static ServiceDescriptor KeyedScoped<TService, TImplementation>(object? serviceKey) where TService : class where TImplementation : class, TService;
+        public static ServiceDescriptor KeyedScoped<TService, TImplementation>(object? serviceKey, Func<IServiceProvider, object, TImplementation> implementationFactory) where TService : class where TImplementation : class, TService;
+        public static ServiceDescriptor KeyedScoped<TService>(object? serviceKey, Func<IServiceProvider, object, TService> implementationFactory) where TService : class;
+        public static ServiceDescriptor KeyedSingleton(Type serviceType, object? serviceKey, Func<IServiceProvider, object, object> implementationFactory);
+        public static ServiceDescriptor KeyedSingleton(Type serviceType, object? serviceKey, object implementationInstance);
+        public static ServiceDescriptor KeyedSingleton(Type service, object? serviceKey, Type implementationType);
+        public static ServiceDescriptor KeyedSingleton<TService, TImplementation>(object? serviceKey) where TService : class where TImplementation : class, TService;
+        public static ServiceDescriptor KeyedSingleton<TService, TImplementation>(object? serviceKey, Func<IServiceProvider, object, TImplementation> implementationFactory) where TService : class where TImplementation : class, TService;
+        public static ServiceDescriptor KeyedSingleton<TService>(object? serviceKey, Func<IServiceProvider, object, TService> implementationFactory) where TService : class;
+        public static ServiceDescriptor KeyedSingleton<TService>(object? serviceKey, TService implementationInstance) where TService : class;
+        public static ServiceDescriptor KeyedTransient(Type service, object? serviceKey, Func<IServiceProvider, object, object> implementationFactory);
+        public static ServiceDescriptor KeyedTransient(Type service, object? serviceKey, Type implementationType);
+        public static ServiceDescriptor KeyedTransient<TService, TImplementation>(object? serviceKey) where TService : class where TImplementation : class, TService;
+        public static ServiceDescriptor KeyedTransient<TService, TImplementation>(object? serviceKey, Func<IServiceProvider, object, TImplementation> implementationFactory) where TService : class where TImplementation : class, TService;
+        public static ServiceDescriptor KeyedTransient<TService>(object? serviceKey, Func<IServiceProvider, object, TService> implementationFactory) where TService : class;
     }
+    public class ServiceKeyAttribute : Attribute {
+        public ServiceKeyAttribute();
+    }
-    public sealed class ServiceProvider : IAsyncDisposable, IDisposable, IServiceProvider {
+    public sealed class ServiceProvider : IAsyncDisposable, IDisposable, IKeyedServiceProvider, IServiceProvider {
+        public object? GetKeyedService(Type serviceType, object? serviceKey);
+        public object GetRequiredKeyedService(Type serviceType, object? serviceKey);
     }
+    public static class ServiceProviderKeyedServiceExtensions {
+        public static T? GetKeyedService<T>(this IServiceProvider provider, object? serviceKey);
+        public static IEnumerable<object?> GetKeyedServices(this IServiceProvider provider, Type serviceType, object? serviceKey);
+        public static IEnumerable<T> GetKeyedServices<T>(this IServiceProvider provider, object? serviceKey);
+        public static object GetRequiredKeyedService(this IServiceProvider provider, Type serviceType, object? serviceKey);
+        public static T GetRequiredKeyedService<T>(this IServiceProvider provider, object? serviceKey);
+    }
+    public static class SocketsHttpHandlerBuilderExtensions {
+        public static ISocketsHttpHandlerBuilder Configure(this ISocketsHttpHandlerBuilder builder, IConfiguration configuration);
+        public static ISocketsHttpHandlerBuilder Configure(this ISocketsHttpHandlerBuilder builder, Action<SocketsHttpHandler, IServiceProvider> configure);
+    }
 }
```

