# Microsoft.Extensions.Http.Logging

``` diff
 namespace Microsoft.Extensions.Http.Logging {
+    public interface IHttpClientAsyncLogger : IHttpClientLogger {
+        ValueTask LogRequestFailedAsync(object? context, HttpRequestMessage request, HttpResponseMessage? response, Exception exception, TimeSpan elapsed, CancellationToken cancellationToken = default(CancellationToken));
+        ValueTask<object?> LogRequestStartAsync(HttpRequestMessage request, CancellationToken cancellationToken = default(CancellationToken));
+        ValueTask LogRequestStopAsync(object? context, HttpRequestMessage request, HttpResponseMessage response, TimeSpan elapsed, CancellationToken cancellationToken = default(CancellationToken));
+    }
+    public interface IHttpClientLogger {
+        void LogRequestFailed(object? context, HttpRequestMessage request, HttpResponseMessage? response, Exception exception, TimeSpan elapsed);
+        object? LogRequestStart(HttpRequestMessage request);
+        void LogRequestStop(object? context, HttpRequestMessage request, HttpResponseMessage response, TimeSpan elapsed);
+    }
 }
```

