# System.Net.Http

``` diff
 namespace System.Net.Http {
     public class HttpClientHandler : HttpMessageHandler {
+        public IMeterFactory MeterFactory { get; set; }
     }
+    public class HttpIOException : IOException {
+        public HttpIOException(HttpRequestError httpRequestError, string? message = null, Exception? innerException = null);
+        public HttpRequestError HttpRequestError { get; }
+    }
-    public sealed class HttpProtocolException : IOException
+    public sealed class HttpProtocolException : HttpIOException
+    public enum HttpRequestError {
+        ConfigurationLimitExceeded = 11,
+        ConnectionError = 2,
+        ExtendedConnectNotSupported = 5,
+        HttpProtocolError = 4,
+        InvalidResponse = 9,
+        NameResolutionError = 1,
+        ProxyTunnelError = 8,
+        ResponseEnded = 10,
+        SecureConnectionError = 3,
+        Unknown = 0,
+        UserAuthenticationError = 7,
+        VersionNegotiationError = 6,
+    }
     public class HttpRequestException : Exception {
+        public HttpRequestException(HttpRequestError httpRequestError, string message = null, Exception inner = null, HttpStatusCode? statusCode = default(HttpStatusCode?));
+        public HttpRequestError HttpRequestError { get; }
     }
     public sealed class SocketsHttpHandler : HttpMessageHandler {
+        public IMeterFactory MeterFactory { get; set; }
     }
 }
```

