# System.Runtime.Intrinsics.Wasm

``` diff
 namespace System.Runtime.Intrinsics.Wasm {
     public abstract class PackedSimd {
+        public static Vector128<sbyte> ConvertNarrowingSaturateSigned(Vector128<short> lower, Vector128<short> upper);
+        public static Vector128<short> ConvertNarrowingSaturateSigned(Vector128<int> lower, Vector128<int> upper);
+        public static Vector128<byte> ConvertNarrowingSaturateUnsigned(Vector128<short> lower, Vector128<short> upper);
+        public static Vector128<ushort> ConvertNarrowingSaturateUnsigned(Vector128<int> lower, Vector128<int> upper);
+        public static Vector128<uint> ConvertToUInt32Saturate(Vector128<double> value);
+        public static Vector128<uint> ConvertToUInt32Saturate(Vector128<float> value);
-        public static uint ExtractLane(Vector128<byte> value, byte index);

-        public static double ExtractLane(Vector128<double> value, byte index);

-        public static int ExtractLane(Vector128<short> value, byte index);

-        public static int ExtractLane(Vector128<int> value, byte index);

-        public static long ExtractLane(Vector128<long> value, byte index);

-        public static IntPtr ExtractLane(Vector128<IntPtr> value, byte index);

-        public static int ExtractLane(Vector128<sbyte> value, byte index);

-        public static float ExtractLane(Vector128<float> value, byte index);

-        public static uint ExtractLane(Vector128<ushort> value, byte index);

-        public static uint ExtractLane(Vector128<uint> value, byte index);

-        public static ulong ExtractLane(Vector128<ulong> value, byte index);

-        public static UIntPtr ExtractLane(Vector128<UIntPtr> value, byte index);

+        public static uint ExtractScalar(Vector128<byte> value, byte index);
+        public static double ExtractScalar(Vector128<double> value, byte index);
+        public static int ExtractScalar(Vector128<short> value, byte index);
+        public static int ExtractScalar(Vector128<int> value, byte index);
+        public static long ExtractScalar(Vector128<long> value, byte index);
+        public static IntPtr ExtractScalar(Vector128<IntPtr> value, byte index);
+        public static int ExtractScalar(Vector128<sbyte> value, byte index);
+        public static float ExtractScalar(Vector128<float> value, byte index);
+        public static uint ExtractScalar(Vector128<ushort> value, byte index);
+        public static uint ExtractScalar(Vector128<uint> value, byte index);
+        public static ulong ExtractScalar(Vector128<ulong> value, byte index);
+        public static UIntPtr ExtractScalar(Vector128<UIntPtr> value, byte index);
-        public static Vector128<byte> ReplaceLane(Vector128<byte> vector, byte imm, uint value);

-        public static Vector128<double> ReplaceLane(Vector128<double> vector, byte imm, double value);

-        public static Vector128<short> ReplaceLane(Vector128<short> vector, byte imm, int value);

-        public static Vector128<int> ReplaceLane(Vector128<int> vector, byte imm, int value);

-        public static Vector128<long> ReplaceLane(Vector128<long> vector, byte imm, long value);

-        public static Vector128<IntPtr> ReplaceLane(Vector128<IntPtr> vector, byte imm, IntPtr value);

-        public static Vector128<sbyte> ReplaceLane(Vector128<sbyte> vector, byte imm, int value);

-        public static Vector128<float> ReplaceLane(Vector128<float> vector, byte imm, float value);

-        public static Vector128<ushort> ReplaceLane(Vector128<ushort> vector, byte imm, uint value);

-        public static Vector128<int> ReplaceLane(Vector128<uint> vector, byte imm, uint value);

-        public static Vector128<ulong> ReplaceLane(Vector128<ulong> vector, byte imm, ulong value);

-        public static Vector128<UIntPtr> ReplaceLane(Vector128<UIntPtr> vector, byte imm, UIntPtr value);

+        public static Vector128<byte> ReplaceScalar(Vector128<byte> vector, byte imm, uint value);
+        public static Vector128<double> ReplaceScalar(Vector128<double> vector, byte imm, double value);
+        public static Vector128<short> ReplaceScalar(Vector128<short> vector, byte imm, int value);
+        public static Vector128<int> ReplaceScalar(Vector128<int> vector, byte imm, int value);
+        public static Vector128<long> ReplaceScalar(Vector128<long> vector, byte imm, long value);
+        public static Vector128<IntPtr> ReplaceScalar(Vector128<IntPtr> vector, byte imm, IntPtr value);
+        public static Vector128<sbyte> ReplaceScalar(Vector128<sbyte> vector, byte imm, int value);
+        public static Vector128<float> ReplaceScalar(Vector128<float> vector, byte imm, float value);
+        public static Vector128<ushort> ReplaceScalar(Vector128<ushort> vector, byte imm, uint value);
+        public static Vector128<int> ReplaceScalar(Vector128<uint> vector, byte imm, uint value);
+        public static Vector128<ulong> ReplaceScalar(Vector128<ulong> vector, byte imm, ulong value);
+        public static Vector128<UIntPtr> ReplaceScalar(Vector128<UIntPtr> vector, byte imm, UIntPtr value);
     }
 }
```

