# Microsoft.Win32

``` diff
 namespace Microsoft.Win32 {
+    public abstract class CommonItemDialog : CommonDialog {
+        public bool AddToRecent { get; set; }
+        public Guid? ClientGuid { get; set; }
+        public IList<FileDialogCustomPlace> CustomPlaces { get; set; }
+        public string DefaultDirectory { get; set; }
+        public bool DereferenceLinks { get; set; }
+        public string InitialDirectory { get; set; }
+        public string RootDirectory { get; set; }
+        public bool ShowHiddenItems { get; set; }
+        public string Title { get; set; }
+        public bool ValidateNames { get; set; }
+        protected virtual void OnItemOk(CancelEventArgs e);
+        public override void Reset();
+        protected override bool RunDialog(IntPtr hwndOwner);
+        public override string ToString();
+    }
-    public abstract class FileDialog : CommonDialog {
+    public abstract class FileDialog : CommonItemDialog {
-        protected FileDialog();

-        public virtual bool CheckFileExists { get; set; }
+        public bool CheckFileExists { get; set; }
-        public IList<FileDialogCustomPlace> CustomPlaces { get; set; }

-        public bool DereferenceLinks { get; set; }

-        public string InitialDirectory { get; set; }

-        protected int Options { get; }

-        public string Title { get; set; }

-        public bool ValidateNames { get; set; }

-        protected override IntPtr HookProc(IntPtr hwnd, int msg, IntPtr wParam, IntPtr lParam);

-        protected void OnFileOk(CancelEventArgs e);

+        protected override void OnItemOk(CancelEventArgs e);
-        protected override bool RunDialog(IntPtr hwndOwner);

     }
     public sealed class OpenFileDialog : FileDialog {
+        public bool ForcePreviewPane { get; set; }
-        protected override void CheckPermissionsToShowDialog();

     }
+    public sealed class OpenFolderDialog : CommonItemDialog {
+        public OpenFolderDialog();
+        public string FolderName { get; set; }
+        public string[] FolderNames { get; }
+        public bool Multiselect { get; set; }
+        public string SafeFolderName { get; }
+        public string[] SafeFolderNames { get; }
+        public event CancelEventHandler FolderOk;
+        protected override void OnItemOk(CancelEventArgs e);
+        public override void Reset();
+        public override string ToString();
+    }
     public sealed class SaveFileDialog : FileDialog {
+        public bool CreateTestFile { get; set; }
     }
 }
```

