# Microsoft.AspNetCore.Builder

``` diff
 namespace Microsoft.AspNetCore.Builder {
     public class ForwardedHeadersOptions {
+        public string ForwardedPrefixHeaderName { get; set; }
+        public string OriginalPrefixHeaderName { get; set; }
     }
-    public class RazorComponentEndpointConventionBuilder : IEndpointConventionBuilder {
-        public ComponentApplicationBuilder ApplicationBuilder { get; }
-        public void Add(Action<EndpointBuilder> convention);
-        public RazorComponentEndpointConventionBuilder AddServerRenderMode();
-        public RazorComponentEndpointConventionBuilder AddWebAssemblyRenderMode();
-        public void Finally(Action<EndpointBuilder> finallyConvention);
-    }
+    public sealed class RazorComponentsEndpointConventionBuilder : IEndpointConventionBuilder {
+        public void Add(Action<EndpointBuilder> convention);
+        public void AddRenderMode(IComponentRenderMode renderMode);
+        public RazorComponentsEndpointConventionBuilder AddServerRenderMode();
+        public void Finally(Action<EndpointBuilder> finallyConvention);
+    }
+    public static class RazorComponentsEndpointConventionBuilderExtensions {
+        public static RazorComponentsEndpointConventionBuilder AddAdditionalAssemblies(this RazorComponentsEndpointConventionBuilder builder, params Assembly[] assemblies);
+    }
     public static class RazorComponentsEndpointRouteBuilderExtensions {
-        public static RazorComponentEndpointConventionBuilder MapRazorComponents<TRootComponent>(this IEndpointRouteBuilder endpoints);
+        public static RazorComponentsEndpointConventionBuilder MapRazorComponents<TRootComponent>(this IEndpointRouteBuilder endpoints);
     }
     public static class RoutingEndpointConventionBuilderExtensions {
+        public static TBuilder WithFormMappingOptions<TBuilder>(this TBuilder builder, int? maxCollectionSize = default(int?), int? maxRecursionDepth = default(int?), int? maxKeySize = default(int?)) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder WithFormOptions<TBuilder>(this TBuilder builder, bool? bufferBody = default(bool?), int? memoryBufferThreshold = default(int?), long? bufferBodyLengthLimit = default(long?), int? valueCountLimit = default(int?), int? keyLengthLimit = default(int?), int? valueLengthLimit = default(int?), int? multipartBoundaryLengthLimit = default(int?), int? multipartHeadersCountLimit = default(int?), int? multipartHeadersLengthLimit = default(int?), long? multipartBodyLengthLimit = default(long?)) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder WithOrder<TBuilder>(this TBuilder builder, int order) where TBuilder : IEndpointConventionBuilder;
     }
     public sealed class WebApplicationBuilder : IHostApplicationBuilder {
+        public IMetricsBuilder Metrics { get; }
     }
 }
```

